/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.style;

import java.util.Enumeration;
import org.w3c.dom.Element;
import writer2latex.latex.Context;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.style.BeforeAfter;
import writer2latex.latex.style.ListStyleConverter;
import writer2latex.latex.style.StyleConverter;
import writer2latex.office.MasterPage;
import writer2latex.office.PageMaster;
import writer2latex.office.ParStyle;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class PageStyleConverter
extends StyleConverter {
    private String sMainMasterPage = null;
    private String sChapterField1 = null;
    private String sChapterField2 = null;

    public PageStyleConverter(WriterStyleCollection writerStyleCollection, Config config, ConverterPalette converterPalette) {
        super(writerStyleCollection, config, converterPalette);
    }

    public void appendDeclarations(LaTeXDocumentPortion laTeXDocumentPortion, LaTeXDocumentPortion laTeXDocumentPortion2) {
        Object object;
        if (this.config.pageFormatting() == 4) {
            laTeXDocumentPortion.append("\\usepackage{calc}").nl();
        }
        if (this.sMainMasterPage == null) {
            this.sMainMasterPage = this.wsc.getFirstMasterPageName();
            if (this.sMainMasterPage != null) {
                this.styleNames.addName(this.sMainMasterPage);
            }
        }
        String string = null;
        if (this.sMainMasterPage != null && (object = this.wsc.getMasterPage(this.sMainMasterPage)) != null) {
            string = ((MasterPage)object).getProperty("style:page-master-name");
        }
        this.convertMasterPages(laTeXDocumentPortion2);
        object = new BeforeAfter();
        this.applyMasterPage(this.sMainMasterPage, (BeforeAfter)object);
        laTeXDocumentPortion2.append(((BeforeAfter)object).getBefore());
    }

    public void setChapterField1(String string) {
        this.sChapterField1 = string;
    }

    public void setChapterField2(String string) {
        this.sChapterField2 = string;
    }

    public void applyMasterPage(String string, BeforeAfter beforeAfter) {
        if (this.config.pageFormatting() == 0) {
            return;
        }
        MasterPage masterPage = this.wsc.getMasterPage(string);
        if (masterPage == null) {
            return;
        }
        String string2 = masterPage.getProperty("style:next-style-name");
        MasterPage masterPage2 = this.wsc.getMasterPage(string2);
        if (masterPage == masterPage2 || masterPage2 == null) {
            beforeAfter.add("\\pagestyle{" + this.styleNames.getExportName(string) + "}\n", "");
        } else {
            beforeAfter.add("\\pagestyle{" + this.styleNames.getExportName(string2) + "}\n" + "\\thispagestyle{" + this.styleNames.getExportName(string) + "}\n", "");
        }
    }

    public void collectMasterPage(ParStyle parStyle) {
        if (parStyle == null || this.sMainMasterPage != null) {
            return;
        }
        String string = parStyle.getMasterPageName();
        if (string != null && string.length() != 0) {
            this.sMainMasterPage = string;
        }
    }

    private void convertMasterPages(LaTeXDocumentPortion laTeXDocumentPortion) {
        if (this.config.pageFormatting() == 0) {
            return;
        }
        Context context = new Context();
        context.resetFormattingFromStyle(this.wsc.getDefaultParStyle());
        context.setInHeaderFooter(true);
        Enumeration enumeration = this.wsc.getMasterPages().getStylesEnumeration();
        laTeXDocumentPortion.append("% Pages styles (master pages)").nl().append("\\makeatletter").nl();
        while (enumeration.hasMoreElements()) {
            MasterPage masterPage = (MasterPage)enumeration.nextElement();
            String string = masterPage.getName();
            if (!this.styleNames.containsName(string)) continue;
            laTeXDocumentPortion.append("\\newcommand\\ps@").append(this.styleNames.getExportName(string)).append("{%").nl();
            this.sChapterField1 = null;
            this.sChapterField2 = null;
            laTeXDocumentPortion.append("\\renewcommand\\@oddhead{");
            if (masterPage.getHeader() != null) {
                this.traverseHeaderFooter((Element)masterPage.getHeader(), laTeXDocumentPortion, context);
            }
            laTeXDocumentPortion.append("}%").nl();
            laTeXDocumentPortion.append("\\renewcommand\\@evenhead{");
            if (masterPage.getHeaderLeft() != null) {
                this.traverseHeaderFooter((Element)masterPage.getHeaderLeft(), laTeXDocumentPortion, context);
            } else if (masterPage.getHeader() != null) {
                laTeXDocumentPortion.append("\\@oddhead");
            }
            laTeXDocumentPortion.append("}%").nl();
            laTeXDocumentPortion.append("\\renewcommand\\@oddfoot{");
            if (masterPage.getFooter() != null) {
                this.traverseHeaderFooter((Element)masterPage.getFooter(), laTeXDocumentPortion, context);
            }
            laTeXDocumentPortion.append("}%").nl();
            laTeXDocumentPortion.append("\\renewcommand\\@evenfoot{");
            if (masterPage.getFooterLeft() != null) {
                this.traverseHeaderFooter((Element)masterPage.getFooterLeft(), laTeXDocumentPortion, context);
            } else if (masterPage.getFooter() != null) {
                laTeXDocumentPortion.append("\\@oddfoot");
            }
            laTeXDocumentPortion.append("}%").nl();
            if (this.sChapterField1 != null) {
                laTeXDocumentPortion.append("\\def\\sectionmark##1{\\markboth{");
                if ("name".equals(this.sChapterField1)) {
                    laTeXDocumentPortion.append("##1");
                } else if ("number".equals(this.sChapterField1) || "plain-number".equals(this.sChapterField1)) {
                    laTeXDocumentPortion.append("\\thesection");
                } else {
                    laTeXDocumentPortion.append("\\thesection ##1");
                }
                laTeXDocumentPortion.append("}{}}").nl();
            }
            if (this.sChapterField2 != null) {
                if (this.sChapterField1 == null) {
                    laTeXDocumentPortion.append("\\def\\sectionmark##1{\\markboth{}{}}").nl();
                }
                laTeXDocumentPortion.append("\\def\\subsectionmark##1{\\markright{");
                if ("name".equals(this.sChapterField2)) {
                    laTeXDocumentPortion.append("##1");
                } else if ("number".equals(this.sChapterField2) || "plain-number".equals(this.sChapterField1)) {
                    laTeXDocumentPortion.append("\\thesubsection");
                } else {
                    laTeXDocumentPortion.append("\\thesubsection ##1");
                }
                laTeXDocumentPortion.append("}{}}").nl();
            }
            String string2 = masterPage.getProperty("style:page-master-name");
            this.convertPageMaster(string2, laTeXDocumentPortion);
            laTeXDocumentPortion.append("}").nl();
        }
        laTeXDocumentPortion.append("\\makeatother").nl();
    }

    private void traverseHeaderFooter(Element element, LaTeXDocumentPortion laTeXDocumentPortion, Context context) {
        Element element2 = Misc.getChildByTagName(element, "text:p");
        if (element2 == null) {
            return;
        }
        String string = element2.getAttribute("text:style-name");
        BeforeAfter beforeAfter = new BeforeAfter();
        if (element2.hasChildNodes()) {
            laTeXDocumentPortion.append(beforeAfter.getBefore());
            this.palette.getInlineCv().traverseInlineText(element2, laTeXDocumentPortion, context, false);
            laTeXDocumentPortion.append(beforeAfter.getAfter());
        }
    }

    private void convertPageMaster(String string, LaTeXDocumentPortion laTeXDocumentPortion) {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        if (this.config.pageFormatting() != 4) {
            return;
        }
        PageMaster pageMaster = this.wsc.getPageMaster(string);
        if (pageMaster == null) {
            return;
        }
        String string7 = "0cm";
        String string8 = "0cm";
        if (pageMaster.hasHeaderStyle()) {
            string7 = "12pt";
            string8 = pageMaster.getHeaderProperty("fo:margin-bottom");
            if (string8 == null) {
                string8 = "0cm";
            }
        }
        String string9 = "0cm";
        String string10 = "0cm";
        if (pageMaster.hasFooterStyle()) {
            string9 = "12pt";
            string10 = pageMaster.getFooterProperty("fo:margin-top");
            if (string10 == null) {
                string10 = "0cm";
            }
        }
        laTeXDocumentPortion.append("\\setlength\\paperwidth{").append(pageMaster.getAbsoluteProperty("fo:page-width")).append("}").append("\\setlength\\paperheight{").append(pageMaster.getAbsoluteProperty("fo:page-height")).append("}");
        if (this.config.getBackend() == 2 && !this.config.useHyperref()) {
            laTeXDocumentPortion.append("\\setlength\\pdfpagewidth{").append(pageMaster.getAbsoluteProperty("fo:page-width")).append("}").append("\\setlength\\pdfpageheight{").append(pageMaster.getAbsoluteProperty("fo:page-height")).append("}");
        }
        laTeXDocumentPortion.append("\\setlength\\voffset{-1in}");
        laTeXDocumentPortion.append("\\setlength\\hoffset{-1in}");
        laTeXDocumentPortion.append("\\setlength\\topmargin{").append(pageMaster.getProperty("fo:margin-top")).append("}");
        laTeXDocumentPortion.append("\\setlength\\headheight{").append(string7).append("}");
        laTeXDocumentPortion.append("\\setlength\\headsep{").append(string8).append("}");
        laTeXDocumentPortion.append("\\setlength\\footskip{").append(string9).append("+").append(string10).append("}");
        laTeXDocumentPortion.append("\\setlength\\textheight{").append(pageMaster.getProperty("fo:page-height")).append("-").append(pageMaster.getProperty("fo:margin-top")).append("-").append(pageMaster.getProperty("fo:margin-bottom")).append("-").append(string8).append("-").append(string7).append("-").append(string10).append("-").append(string9).append("}");
        laTeXDocumentPortion.append("\\setlength\\oddsidemargin{").append(pageMaster.getProperty("fo:margin-left")).append("}");
        if ("mirrored".equals(pageMaster.getPageUsage())) {
            laTeXDocumentPortion.append("\\setlength\\evensidemargin{").append(pageMaster.getProperty("fo:margin-right")).append("}");
        }
        laTeXDocumentPortion.append("\\setlength\\textwidth{").append(pageMaster.getProperty("fo:page-width")).append("-").append(pageMaster.getProperty("fo:margin-left")).append("-").append(pageMaster.getProperty("fo:margin-right")).append("}").nl();
        String string11 = pageMaster.getProperty("style:num-format");
        if (string11 != null) {
            laTeXDocumentPortion.append("\\renewcommand\\thepage{").append(ListStyleConverter.numFormat(string11)).append("{page}}").nl();
        }
        if ((string6 = pageMaster.getProperty("style:first-page-number")) != null && !string6.equals("continue")) {
            laTeXDocumentPortion.append("\\setcounter{page}{").append(Integer.toString(Misc.getPosInteger(string6, 0))).append("}").nl();
        }
        if ((string5 = pageMaster.getFootnoteProperty("style:distance-before-sep")) == null) {
            string5 = "1mm";
        }
        if ((string4 = pageMaster.getFootnoteProperty("style:distance-after-sep")) == null) {
            string4 = "1mm";
        }
        if ((string3 = pageMaster.getFootnoteProperty("style:width")) == null) {
            string3 = "0.2mm";
        }
        if ((string2 = pageMaster.getFootnoteProperty("style:rel-width")) == null) {
            string2 = "25%";
        }
        string2 = Float.toString(Misc.getFloat(string2.substring(0, string2.length() - 1), 1.0f) / 100.0f);
        BeforeAfter beforeAfter = new BeforeAfter();
        this.palette.getCharSc().applyThisColor(pageMaster.getFootnoteProperty("style:color"), false, beforeAfter);
        laTeXDocumentPortion.append("\\setlength{\\skip\\footins}{").append(string5).append("}");
        laTeXDocumentPortion.append("\\renewcommand\\footnoterule{\\vspace*{-").append(string3).append("}\\noindent").append(beforeAfter.getBefore()).append("\\rule{").append(string2).append("\\columnwidth}{").append(string3).append("}").append(beforeAfter.getAfter()).append("\\vspace*{").append(string4).append("}}").nl();
    }
}

