/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.DataDb;
import com.sleepycat.bdb.DataIndex;
import com.sleepycat.bdb.DataThang;
import com.sleepycat.bdb.ForeignKeyIndex;
import com.sleepycat.bdb.PrimaryKeyAssigner;
import com.sleepycat.bdb.RecordNumberFormat;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class DataStore {
    DataDb db;
    DataFormat keyFormat;
    DataFormat valueFormat;
    PrimaryKeyAssigner keyAssigner;
    ArrayList indices;
    ArrayList inverseIndices;

    public DataStore(Db db, DataFormat dataFormat, DataFormat dataFormat2, PrimaryKeyAssigner primaryKeyAssigner) {
        this.db = new DataDb(db);
        this.keyFormat = dataFormat;
        this.valueFormat = dataFormat2;
        this.keyAssigner = primaryKeyAssigner;
        if (dataFormat instanceof RecordNumberFormat && !this.db.hasRecNumAccess()) {
            throw new IllegalArgumentException(this.db.toString() + " RecordNumberFormat is only allowed when the" + " access method has record number keys");
        }
        if (dataFormat2 instanceof RecordNumberFormat) {
            throw new IllegalArgumentException(this.db.toString() + " RecordNumberFormat is only allowed for keys");
        }
    }

    public void close() throws DbException {
        this.db.close();
        if (this.indices != null) {
            int n = 0;
            while (n < this.indices.size()) {
                DataIndex dataIndex = (DataIndex)this.indices.get(n);
                dataIndex.db.close();
                ++n;
            }
        }
    }

    public final DbEnv getEnv() {
        return this.db.env.getEnv();
    }

    public final DataFormat getKeyFormat() {
        return this.keyFormat;
    }

    public final PrimaryKeyAssigner getKeyAssigner() {
        return this.keyAssigner;
    }

    public final DataFormat getValueFormat() {
        return this.valueFormat;
    }

    public final Iterator getIndices() {
        return this.indices != null ? this.indices.iterator() : null;
    }

    public String toString() {
        return this.db.toString();
    }

    final void addIndex(DataIndex dataIndex) {
        if (this.db.areDuplicatesAllowed()) {
            throw new IllegalArgumentException("The primary store of an index must now allow duplicates");
        }
        if (this.indices == null) {
            this.indices = new ArrayList();
        }
        this.indices.add(dataIndex);
    }

    final void addInverseIndex(ForeignKeyIndex foreignKeyIndex) {
        if (this.inverseIndices == null) {
            this.inverseIndices = new ArrayList();
        }
        this.inverseIndices.add(foreignKeyIndex);
    }

    void applyChange(DataThang dataThang, DataThang dataThang2, DataThang dataThang3) throws DbException, IOException {
        DataIndex dataIndex;
        int n;
        if (dataThang3 == null && this.inverseIndices != null) {
            n = 0;
            while (n < this.inverseIndices.size()) {
                dataIndex = (ForeignKeyIndex)this.inverseIndices.get(n);
                ((ForeignKeyIndex)dataIndex).applyForeignDelete(dataThang);
                ++n;
            }
        }
        if (this.indices != null) {
            n = 0;
            while (n < this.indices.size()) {
                dataIndex = (DataIndex)this.indices.get(n);
                dataIndex.applyChange(dataThang, dataThang2, dataThang3);
                ++n;
            }
        }
    }
}

