/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.DataDb;
import com.sleepycat.bdb.DataEnvironment;
import com.sleepycat.bdb.DataThang;
import com.sleepycat.bdb.bind.serial.ClassCatalog;
import com.sleepycat.bdb.util.IOExceptionWrapper;
import com.sleepycat.bdb.util.UtfOps;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbTxn;
import com.sleepycat.db.Dbc;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;

public class StoredClassCatalog
implements ClassCatalog {
    private static final byte REC_LAST_CLASS_ID = 0;
    private static final byte REC_CLASS_FORMAT = 1;
    private static final byte REC_CLASS_INFO = 2;
    private static final byte[] LAST_CLASS_ID_KEY = new byte[]{0};
    private DataEnvironment env;
    private DataDb db;
    private HashMap classMap;
    private HashMap formatMap;

    public StoredClassCatalog(DbEnv dbEnv, String string, String string2, int n) throws FileNotFoundException, DbException {
        this.env = DataEnvironment.getEnvironment(dbEnv);
        DbTxn dbTxn = this.env.getTxn();
        if (dbTxn != null) {
            n &= ~Db.DB_AUTO_COMMIT;
        }
        Db db = new Db(dbEnv, 0);
        db.open(dbTxn, string, string2, 1, n, 0);
        this.db = new DataDb(db);
        this.classMap = new HashMap();
        this.formatMap = new HashMap();
    }

    public synchronized void close() throws IOException {
        try {
            if (this.db != null) {
                this.db.close();
                this.db = null;
            }
        }
        catch (DbException dbException) {
            throw new IOExceptionWrapper(dbException);
        }
        this.db = null;
        this.formatMap = null;
        this.classMap = null;
    }

    public synchronized byte[] getClassID(String string) throws IOException, ClassNotFoundException {
        try {
            ClassInfo classInfo = this.getClassInfo(string);
            return classInfo.getClassID();
        }
        catch (DbException dbException) {
            throw new IOExceptionWrapper(dbException);
        }
    }

    public synchronized ObjectStreamClass getClassFormat(String string) throws IOException, ClassNotFoundException {
        try {
            ClassInfo classInfo = this.getClassInfo(string);
            return classInfo.getClassFormat();
        }
        catch (DbException dbException) {
            throw new IOExceptionWrapper(dbException);
        }
    }

    public ObjectStreamClass getClassFormat(byte[] byArray) throws IOException, ClassNotFoundException {
        try {
            return this.getClassFormat(byArray, this.newDbt());
        }
        catch (DbException dbException) {
            throw new IOExceptionWrapper(dbException);
        }
    }

    private synchronized ObjectStreamClass getClassFormat(byte[] byArray, DataThang dataThang) throws DbException, ClassNotFoundException, IOException {
        BigInteger bigInteger = new BigInteger(byArray);
        ObjectStreamClass objectStreamClass = (ObjectStreamClass)this.formatMap.get(bigInteger);
        if (objectStreamClass == null) {
            byte[] byArray2 = new byte[byArray.length + 1];
            byArray2[0] = 1;
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            DataThang dataThang2 = this.newDbt();
            dataThang2.setBytes(byArray2);
            int n = this.db.get(dataThang2, dataThang, 0);
            if (n != 0) {
                throw new ClassNotFoundException("Catalog class ID not found");
            }
            ObjectInputStream objectInputStream = new ObjectInputStream(dataThang.getByteStream());
            objectStreamClass = (ObjectStreamClass)objectInputStream.readObject();
            this.formatMap.put(bigInteger, objectStreamClass);
        }
        return objectStreamClass;
    }

    private ClassInfo getClassInfo(String string) throws IOException, ClassNotFoundException, DbException, DbException {
        ClassInfo classInfo = (ClassInfo)this.classMap.get(string);
        if (classInfo != null) {
            return classInfo;
        }
        Class<?> clazz = Class.forName(string);
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[1 + UtfOps.getByteLength(cArray)];
        byArray[0] = 2;
        UtfOps.charsToBytes(cArray, 0, byArray, 1, cArray.length);
        DataThang dataThang = this.newDbt();
        dataThang.setBytes(byArray);
        DataThang dataThang2 = this.newDbt();
        int n = this.db.get(dataThang, dataThang2, 0);
        if (n != 0) {
            classInfo = this.putClassInfo(new ClassInfo(), string, dataThang, objectStreamClass);
        } else {
            classInfo = new ClassInfo(dataThang2);
            DataThang dataThang3 = this.newDbt();
            ObjectStreamClass objectStreamClass2 = this.getClassFormat(classInfo.getClassID(), dataThang3);
            if (!StoredClassCatalog.areClassFormatsEqual(objectStreamClass2, dataThang3.getBytes(), objectStreamClass)) {
                classInfo = this.putClassInfo(classInfo, string, dataThang, objectStreamClass);
            }
            classInfo.setClassFormat(objectStreamClass);
            this.classMap.put(string, classInfo);
        }
        return classInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ClassInfo putClassInfo(ClassInfo classInfo, String string, DataThang dataThang, ObjectStreamClass objectStreamClass) throws DbException, ClassNotFoundException {
        ClassInfo classInfo2;
        Dbc dbc;
        block7: {
            ClassInfo classInfo3;
            block6: {
                dbc = this.db.openCursor(true);
                try {
                    DataThang dataThang2 = this.newDbt();
                    dataThang2.setBytes(LAST_CLASS_ID_KEY);
                    DataThang dataThang3 = this.newDbt();
                    int n = Db.DB_CURRENT;
                    int n2 = dbc.get(dataThang2, dataThang3, Db.DB_SET | this.env.getWriteLockFlag());
                    if (n2 != 0) {
                        dataThang3.setBytes(new byte[1]);
                        n = Db.DB_KEYLAST;
                    }
                    byte[] byArray = dataThang3.getBytes();
                    Object v = this.classMap.get(string);
                    if (v != null) {
                        classInfo3 = (ClassInfo)v;
                        Object var18_13 = null;
                        break block6;
                    }
                    byArray = StoredClassCatalog.incrementID(byArray);
                    dataThang3.setBytes(byArray);
                    dbc.put(dataThang2, dataThang3, n);
                    byte[] byArray2 = new byte[1 + byArray.length];
                    byArray2[0] = 1;
                    System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
                    dataThang2.setBytes(byArray2);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    try {
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                        objectOutputStream.writeObject(objectStreamClass);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    dataThang3.setBytes(byteArrayOutputStream.toByteArray());
                    this.db.put(dataThang2, dataThang3, 0);
                    classInfo.setClassID(byArray);
                    classInfo.toDbt(dataThang3);
                    this.db.put(dataThang, dataThang3, 0);
                    classInfo.setClassFormat(objectStreamClass);
                    this.classMap.put(string, classInfo);
                    this.formatMap.put(new BigInteger(byArray), objectStreamClass);
                    classInfo2 = classInfo;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var18_15 = null;
                    this.db.closeCursor(dbc);
                    throw throwable;
                }
            }
            this.db.closeCursor(dbc);
            return classInfo3;
        }
        Object var18_14 = null;
        this.db.closeCursor(dbc);
        return classInfo2;
    }

    private static byte[] incrementID(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(byArray);
        bigInteger = bigInteger.add(BigInteger.valueOf(1L));
        return bigInteger.toByteArray();
    }

    private static boolean areClassFormatsEqual(ObjectStreamClass objectStreamClass, byte[] byArray, ObjectStreamClass objectStreamClass2) {
        try {
            if (byArray == null) {
                byArray = StoredClassCatalog.getObjectBytes(objectStreamClass);
            }
            byte[] byArray2 = StoredClassCatalog.getObjectBytes(objectStreamClass2);
            return Arrays.equals(byArray2, byArray);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static byte[] getObjectBytes(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        return byteArrayOutputStream.toByteArray();
    }

    private DataThang newDbt() {
        return new DataThang();
    }

    private static class ClassInfo
    implements Serializable {
        private byte[] classID;
        private transient ObjectStreamClass classFormat;

        ClassInfo() {
        }

        ClassInfo(DataThang dataThang) {
            byte[] byArray = dataThang.getDataBytes();
            byte by = byArray[0];
            this.classID = new byte[by];
            System.arraycopy(byArray, 1, this.classID, 0, by);
        }

        void toDbt(DataThang dataThang) {
            byte[] byArray = new byte[1 + this.classID.length];
            byArray[0] = (byte)this.classID.length;
            System.arraycopy(this.classID, 0, byArray, 1, this.classID.length);
            dataThang.setData(byArray, 0, byArray.length);
        }

        void setClassID(byte[] byArray) {
            this.classID = byArray;
        }

        byte[] getClassID() {
            return this.classID;
        }

        ObjectStreamClass getClassFormat() {
            return this.classFormat;
        }

        void setClassFormat(ObjectStreamClass objectStreamClass) {
            this.classFormat = objectStreamClass;
        }
    }
}

