/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.bind.serial;

import com.sleepycat.bdb.bind.DataBuffer;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.bdb.bind.KeyExtractor;
import com.sleepycat.bdb.bind.serial.SerialFormat;
import com.sleepycat.bdb.bind.tuple.TupleFormat;
import com.sleepycat.bdb.bind.tuple.TupleInput;
import com.sleepycat.bdb.bind.tuple.TupleOutput;
import java.io.IOException;

public abstract class TupleSerialKeyExtractor
implements KeyExtractor {
    protected TupleFormat primaryKeyFormat;
    protected SerialFormat valueFormat;
    protected TupleFormat indexKeyFormat;

    public TupleSerialKeyExtractor(TupleFormat tupleFormat, SerialFormat serialFormat, TupleFormat tupleFormat2) {
        this.primaryKeyFormat = tupleFormat;
        this.valueFormat = serialFormat;
        this.indexKeyFormat = tupleFormat2;
    }

    public DataFormat getPrimaryKeyFormat() {
        return this.primaryKeyFormat;
    }

    public DataFormat getValueFormat() {
        return this.valueFormat;
    }

    public DataFormat getIndexKeyFormat() {
        return this.indexKeyFormat;
    }

    public void extractIndexKey(DataBuffer dataBuffer, DataBuffer dataBuffer2, DataBuffer dataBuffer3) throws IOException {
        TupleOutput tupleOutput = this.indexKeyFormat.newOutput();
        TupleInput tupleInput = this.primaryKeyFormat != null ? this.primaryKeyFormat.dataToInput(dataBuffer) : null;
        Object object = this.valueFormat != null ? this.valueFormat.dataToObject(dataBuffer2) : null;
        this.extractIndexKey(tupleInput, object, tupleOutput);
        this.indexKeyFormat.outputToData(tupleOutput, dataBuffer3);
    }

    public void clearIndexKey(DataBuffer dataBuffer) throws IOException {
        Object object = this.valueFormat.dataToObject(dataBuffer);
        this.clearIndexKey(object);
        this.valueFormat.objectToData(object, dataBuffer);
    }

    public abstract void extractIndexKey(TupleInput var1, Object var2, TupleOutput var3) throws IOException;

    public abstract void clearIndexKey(Object var1) throws IOException;
}

