/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.collection;

import com.sleepycat.bdb.DataCursor;
import com.sleepycat.bdb.collection.StoredCollection;
import com.sleepycat.bdb.collection.StoredContainer;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbException;
import java.io.IOException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class StoredIterator
implements ListIterator,
Cloneable {
    private boolean lockForWrite;
    private StoredCollection coll;
    private DataCursor cursor;
    private int toNext;
    private int toPrevious;
    private int toCurrent;
    private boolean writeAllowed;
    private boolean setAndRemoveAllowed;
    private Object currentData;
    private final int NEXT_FLAG;
    private final int PREV_FLAG;
    private final boolean recNumAccess;

    public static void close(Iterator iterator) {
        if (iterator instanceof StoredIterator) {
            ((StoredIterator)iterator).close();
        }
    }

    StoredIterator(StoredCollection storedCollection, boolean bl, DataCursor dataCursor) {
        try {
            this.coll = storedCollection;
            this.writeAllowed = bl;
            this.cursor = dataCursor == null ? new DataCursor(storedCollection.view, bl) : dataCursor;
            this.recNumAccess = this.cursor.hasRecNumAccess();
            if (storedCollection.iterateDuplicates()) {
                this.NEXT_FLAG = Db.DB_NEXT;
                this.PREV_FLAG = Db.DB_PREV;
            } else {
                this.NEXT_FLAG = Db.DB_NEXT_NODUP;
                this.PREV_FLAG = Db.DB_PREV_NODUP;
            }
            this.reset();
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    protected Object clone() {
        try {
            StoredIterator storedIterator = (StoredIterator)super.clone();
            storedIterator.cursor = new DataCursor(this.cursor);
            return storedIterator;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    public final boolean getLockForWrite() {
        return this.lockForWrite;
    }

    public void setLockForWrite(boolean bl) {
        this.lockForWrite = bl;
    }

    public boolean hasNext() {
        if (this.cursor == null) {
            return false;
        }
        try {
            int n;
            if (this.toNext != 0 && (n = this.cursor.get(null, null, this.toNext, this.lockForWrite)) == 0) {
                this.toNext = 0;
                this.toPrevious = this.PREV_FLAG;
                this.toCurrent = this.PREV_FLAG;
            }
            return this.toNext == 0;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    public boolean hasPrevious() {
        if (this.cursor == null) {
            return false;
        }
        try {
            int n;
            if (this.toPrevious != 0 && (n = this.cursor.get(null, null, this.toPrevious, this.lockForWrite)) == 0) {
                this.toPrevious = 0;
                this.toNext = this.NEXT_FLAG;
                this.toCurrent = this.NEXT_FLAG;
            }
            return this.toPrevious == 0;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    public Object next() {
        try {
            int n;
            if (this.toNext != 0 && (n = this.cursor.get(null, null, this.toNext, this.lockForWrite)) == 0) {
                this.toNext = 0;
            }
            if (this.toNext == 0) {
                this.currentData = this.coll.makeIteratorData(this, this.cursor);
                this.toNext = this.NEXT_FLAG;
                this.toPrevious = 0;
                this.toCurrent = 0;
                this.setAndRemoveAllowed = true;
                return this.currentData;
            }
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
        throw new NoSuchElementException();
    }

    public Object previous() {
        try {
            int n;
            if (this.toPrevious != 0 && (n = this.cursor.get(null, null, this.toPrevious, this.lockForWrite)) == 0) {
                this.toPrevious = 0;
            }
            if (this.toPrevious == 0) {
                this.currentData = this.coll.makeIteratorData(this, this.cursor);
                this.toPrevious = this.PREV_FLAG;
                this.toNext = 0;
                this.toCurrent = 0;
                this.setAndRemoveAllowed = true;
                return this.currentData;
            }
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
        throw new NoSuchElementException();
    }

    public int nextIndex() {
        if (!this.recNumAccess) {
            throw new UnsupportedOperationException("Record number access not supported");
        }
        try {
            return this.hasNext() ? this.cursor.getCurrentRecordNumber() - this.coll.getIndexOffset() : Integer.MAX_VALUE;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    public int previousIndex() {
        if (!this.recNumAccess) {
            throw new UnsupportedOperationException("Record number access not supported");
        }
        try {
            return this.hasPrevious() ? this.cursor.getCurrentRecordNumber() - this.coll.getIndexOffset() : -1;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    public void set(Object object) {
        if (!this.coll.hasValues()) {
            throw new UnsupportedOperationException();
        }
        if (!this.setAndRemoveAllowed) {
            throw new IllegalStateException();
        }
        try {
            this.moveToCurrent();
            this.cursor.put(null, object, Db.DB_CURRENT, null);
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    public void remove() {
        if (!this.setAndRemoveAllowed) {
            throw new IllegalStateException();
        }
        try {
            this.moveToCurrent();
            this.cursor.delete();
            this.setAndRemoveAllowed = false;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(Object object) {
        this.coll.checkIterAddAllowed();
        try {
            int n = 0;
            if (this.toNext != 0 && this.toPrevious != 0) {
                if (!this.coll.view.areKeysRenumbered()) throw new IllegalStateException("Collection is empty, cannot add() duplicate");
                this.close();
                n = this.coll.view.append(object, null, null);
                this.cursor = new DataCursor(this.coll.view, this.writeAllowed);
                this.reset();
                this.next();
            } else {
                int n2;
                if (this.coll.view.areKeysRenumbered()) {
                    this.moveToCurrent();
                    n2 = this.hasNext() ? Db.DB_BEFORE : Db.DB_AFTER;
                } else {
                    n2 = this.coll.areDuplicatesOrdered() ? Db.DB_NODUPDATA : (this.toNext == 0 ? Db.DB_BEFORE : Db.DB_AFTER);
                }
                n = this.cursor.put(null, object, n2, null, true);
                if (n2 == Db.DB_BEFORE) {
                    this.toPrevious = 0;
                    this.toNext = this.NEXT_FLAG;
                }
            }
            if (n == -30996) {
                throw new IllegalArgumentException("Duplicate value");
            }
            if (n != 0) {
                throw new IllegalArgumentException("Could not insert: " + n);
            }
            this.setAndRemoveAllowed = false;
            return;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    private void reset() {
        this.toNext = Db.DB_FIRST;
        this.toPrevious = this.PREV_FLAG;
        this.toCurrent = 0;
        this.currentData = null;
        this.hasNext();
    }

    public int count() {
        if (!this.setAndRemoveAllowed) {
            throw new IllegalStateException();
        }
        try {
            this.moveToCurrent();
            return this.cursor.count();
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    public void close() {
        if (this.cursor != null) {
            this.coll.closeCursor(this.cursor);
            this.cursor = null;
        }
    }

    public final StoredCollection getCollection() {
        return this.coll;
    }

    final boolean isCurrentData(Object object) {
        return this.currentData == object;
    }

    final boolean moveToIndex(int n) {
        try {
            int n2 = this.cursor.get(new Integer(n), null, Db.DB_SET, this.lockForWrite);
            this.setAndRemoveAllowed = n2 == 0;
            return this.setAndRemoveAllowed;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    private void moveToCurrent() throws DbException, IOException {
        if (this.toCurrent != 0) {
            this.cursor.get(null, null, this.toCurrent, this.lockForWrite);
            this.toCurrent = 0;
        }
    }
}

