/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.debug;

import gnu.classpath.SystemProperties;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class Simple1LineFormatter
extends Formatter {
    private static final String DAT_PATTERN = "yyyy-MM-dd HH:mm:ss.SSSS Z ";
    private static final DateFormat DAT_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSS Z ");
    private static final String THREAD_PATTERN = " #########0;-#########0";
    private static final NumberFormat THREAD_FORMAT = new DecimalFormat(" #########0;-#########0");
    private static final String SPACES_32 = "                                ";
    private static final String SPACES_6 = "      ";
    private static final String LS = SystemProperties.getProperty("line.separator");

    public String format(LogRecord logRecord) {
        StringBuffer stringBuffer = new StringBuffer(180).append(DAT_FORMAT.format(new Date(logRecord.getMillis()))).append(THREAD_FORMAT.format(logRecord.getThreadID())).append(" ");
        String string = logRecord.getSourceClassName();
        if (string == null) {
            stringBuffer.append(SPACES_32);
        } else {
            int n = (string = string.trim()).lastIndexOf(".");
            if (n != -1) {
                string = string.substring(n + 1);
            }
            string = (string + SPACES_32).substring(0, 32);
        }
        stringBuffer.append(string).append(" ");
        string = logRecord.getSourceMethodName();
        if (string == null) {
            stringBuffer.append(SPACES_32);
        } else {
            string = (string = string.trim()).endsWith("()") ? (string.trim() + SPACES_32).substring(0, 32) : (string.trim() + "()                                ").substring(0, 32);
        }
        stringBuffer.append(string).append(" ");
        string = String.valueOf(logRecord.getLevel());
        if (string == null) {
            stringBuffer.append(SPACES_6);
        } else {
            string = (string.trim() + SPACES_6).substring(0, 6);
        }
        stringBuffer.append(string).append(" - ").append(this.formatMessage(logRecord)).append(LS);
        Throwable throwable = logRecord.getThrown();
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter, true));
            stringBuffer.append(stringWriter.toString());
        }
        return stringBuffer.toString();
    }
}

