/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.cipher;

import gnu.java.security.util.Util;
import gnu.javax.crypto.cipher.BaseCipher;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public final class Square
extends BaseCipher {
    private static final int DEFAULT_BLOCK_SIZE = 16;
    private static final int DEFAULT_KEY_SIZE = 16;
    private static final int ROUNDS = 8;
    private static final int ROOT = 501;
    private static final int[] OFFSET = new int[8];
    private static final String Sdata = "\ub1ce\uc395\u5aad\ue702\u4d44\ufb91\u0c87\ua150\ucb67\u54dd\u468f\ue14e\uf0fd\ufceb\uf9c4\u1a6e\u5ef5\ucc8d\u1c56\u43fe\u0761\uf875\u59ff\u0322\u8ad1\u13ee\u8800\u0e34\u1580\u94e3\uedb5\u5323\u4b47\u17a7\u9035\uabd8\ub8df\u4f57\u9a92\udb1b\u3cc8\u9904\u8ee0\ud77d\u85bb\u402c\u3a45\uf142\u6520\u4118\u7225\u9370\u3605\uf20b\ua379\uec08\u2731\u32b6\u7cb0\u0a73\u5b7b\ub781\ud20d\u6a26\u9e58\u9c83\u74b3\uac30\u7a69\u770f\uae21\uded0\u2e97\u10a4\u98a8\ud468\u2d62\u296d\u1649\u76c7\ue8c1\u9637\ue5ca\uf4e9\u6312\uc2a6\u14bc\ud328\uaf2f\ue624\u52c6\ua009\ubd8c\ucf5d\u115f\u01c5\u9f3d\ua29b\uc93b\ube51\u191f\u3f5c\ub2ef\u4acd\ubfba\u6f64\ud9f3\u3eb4\uaadc\ud506\uc07e\uf666\u6c84\u7138\ub91d\u7f9d\u488b\u2ada\ua533\u8239\ud678\u86fa\ue42b\ua91e\u8960\u6bea\u554c\uf7e2";
    private static final byte[] Se = new byte[256];
    private static final byte[] Sd = new byte[256];
    private static final int[] Te = new int[256];
    private static final int[] Td = new int[256];
    private static final byte[] KAT_KEY = Util.toBytesFromString("00000000000000000000020000000000");
    private static final byte[] KAT_CT = Util.toBytesFromString("A9DF031B4E25E89F527EFFF89CB0BEBA");
    private static Boolean valid;

    private static final void square(byte[] byArray, int n, byte[] byArray2, int n2, int[][] nArray, int[] nArray2, byte[] byArray3) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray[0][0];
        int n8 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray[0][1];
        int n9 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray[0][2];
        int n10 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF) ^ nArray[0][3];
        int n11 = 1;
        while (n11 < 8) {
            n6 = nArray2[n7 >>> 24] ^ Square.rot32R(nArray2[n8 >>> 24], 8) ^ Square.rot32R(nArray2[n9 >>> 24], 16) ^ Square.rot32R(nArray2[n10 >>> 24], 24) ^ nArray[n11][0];
            n5 = nArray2[n7 >>> 16 & 0xFF] ^ Square.rot32R(nArray2[n8 >>> 16 & 0xFF], 8) ^ Square.rot32R(nArray2[n9 >>> 16 & 0xFF], 16) ^ Square.rot32R(nArray2[n10 >>> 16 & 0xFF], 24) ^ nArray[n11][1];
            n4 = nArray2[n7 >>> 8 & 0xFF] ^ Square.rot32R(nArray2[n8 >>> 8 & 0xFF], 8) ^ Square.rot32R(nArray2[n9 >>> 8 & 0xFF], 16) ^ Square.rot32R(nArray2[n10 >>> 8 & 0xFF], 24) ^ nArray[n11][2];
            n3 = nArray2[n7 & 0xFF] ^ Square.rot32R(nArray2[n8 & 0xFF], 8) ^ Square.rot32R(nArray2[n9 & 0xFF], 16) ^ Square.rot32R(nArray2[n10 & 0xFF], 24) ^ nArray[n11][3];
            n7 = n6;
            n8 = n5;
            n9 = n4;
            n10 = n3;
            ++n11;
        }
        n6 = (byArray3[n7 >>> 24] << 24 | (byArray3[n8 >>> 24] & 0xFF) << 16 | (byArray3[n9 >>> 24] & 0xFF) << 8 | byArray3[n10 >>> 24] & 0xFF) ^ nArray[n11][0];
        n5 = (byArray3[n7 >>> 16 & 0xFF] << 24 | (byArray3[n8 >>> 16 & 0xFF] & 0xFF) << 16 | (byArray3[n9 >>> 16 & 0xFF] & 0xFF) << 8 | byArray3[n10 >>> 16 & 0xFF] & 0xFF) ^ nArray[n11][1];
        n4 = (byArray3[n7 >>> 8 & 0xFF] << 24 | (byArray3[n8 >>> 8 & 0xFF] & 0xFF) << 16 | (byArray3[n9 >>> 8 & 0xFF] & 0xFF) << 8 | byArray3[n10 >>> 8 & 0xFF] & 0xFF) ^ nArray[n11][2];
        n3 = (byArray3[n7 & 0xFF] << 24 | (byArray3[n8 & 0xFF] & 0xFF) << 16 | (byArray3[n9 & 0xFF] & 0xFF) << 8 | byArray3[n10 & 0xFF] & 0xFF) ^ nArray[n11][3];
        byArray2[n2++] = (byte)(n6 >>> 24);
        byArray2[n2++] = (byte)(n6 >>> 16);
        byArray2[n2++] = (byte)(n6 >>> 8);
        byArray2[n2++] = (byte)n6;
        byArray2[n2++] = (byte)(n5 >>> 24);
        byArray2[n2++] = (byte)(n5 >>> 16);
        byArray2[n2++] = (byte)(n5 >>> 8);
        byArray2[n2++] = (byte)n5;
        byArray2[n2++] = (byte)(n4 >>> 24);
        byArray2[n2++] = (byte)(n4 >>> 16);
        byArray2[n2++] = (byte)(n4 >>> 8);
        byArray2[n2++] = (byte)n4;
        byArray2[n2++] = (byte)(n3 >>> 24);
        byArray2[n2++] = (byte)(n3 >>> 16);
        byArray2[n2++] = (byte)(n3 >>> 8);
        byArray2[n2] = (byte)n3;
    }

    private static final void transform(int[] nArray, int[] nArray2) {
        int n = 0;
        while (n < 4) {
            int n2 = nArray[n];
            int n3 = n2 >>> 8;
            int n4 = n2 >>> 16;
            int n5 = n2 >>> 24;
            int n6 = ((Square.mul(n5, 2) ^ Square.mul(n4, 3) ^ n3 ^ n2) & 0xFF) << 24;
            n6 ^= ((n5 ^ Square.mul(n4, 2) ^ Square.mul(n3, 3) ^ n2) & 0xFF) << 16;
            n6 ^= ((n5 ^ n4 ^ Square.mul(n3, 2) ^ Square.mul(n2, 3)) & 0xFF) << 8;
            nArray2[n] = n6 ^= (Square.mul(n5, 3) ^ n4 ^ n3 ^ Square.mul(n2, 2)) & 0xFF;
            ++n;
        }
    }

    private static final int rot32L(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    private static final int rot32R(int n, int n2) {
        return n >>> n2 | n << 32 - n2;
    }

    private static final int mul(int n, int n2) {
        if (n == 0) {
            return 0;
        }
        n &= 0xFF;
        n2 &= 0xFF;
        int n3 = 0;
        while (n2 != 0) {
            if ((n2 & 1) != 0) {
                n3 ^= n;
            }
            n2 >>>= 1;
            if ((n <<= 1) <= 255) continue;
            n ^= 0x1F5;
        }
        return n3 & 0xFF;
    }

    public final Object clone() {
        Square square = new Square();
        square.currentBlockSize = this.currentBlockSize;
        return square;
    }

    public final Iterator blockSizes() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(new Integer(16));
        return Collections.unmodifiableList(arrayList).iterator();
    }

    public final Iterator keySizes() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(new Integer(16));
        return Collections.unmodifiableList(arrayList).iterator();
    }

    public final Object makeKey(byte[] byArray, int n) throws InvalidKeyException {
        if (n != 16) {
            throw new IllegalArgumentException();
        }
        if (byArray == null) {
            throw new InvalidKeyException("Empty key");
        }
        if (byArray.length != 16) {
            throw new InvalidKeyException("Key is not 128-bit.");
        }
        int[][] nArray = new int[9][4];
        int[][] nArray2 = new int[9][4];
        int[][] nArray3 = new int[9][4];
        int n2 = 0;
        nArray[0][0] = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        nArray3[0][0] = nArray[0][0];
        nArray[0][1] = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        nArray3[0][1] = nArray[0][1];
        nArray[0][2] = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
        nArray3[0][2] = nArray[0][2];
        nArray[0][3] = (byArray[n2++] & 0xFF) << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2] & 0xFF;
        nArray3[0][3] = nArray[0][3];
        n2 = 1;
        int n3 = 0;
        while (n2 < 9) {
            nArray3[n2][0] = nArray3[n3][0] ^ Square.rot32L(nArray3[n3][3], 8) ^ OFFSET[n3];
            nArray3[n2][1] = nArray3[n3][1] ^ nArray3[n2][0];
            nArray3[n2][2] = nArray3[n3][2] ^ nArray3[n2][1];
            nArray3[n2][3] = nArray3[n3][3] ^ nArray3[n2][2];
            System.arraycopy(nArray3[n2], 0, nArray[n2], 0, 4);
            Square.transform(nArray[n3], nArray[n3]);
            ++n2;
            ++n3;
        }
        n2 = 0;
        while (n2 < 8) {
            System.arraycopy(nArray3[8 - n2], 0, nArray2[n2], 0, 4);
            ++n2;
        }
        Square.transform(nArray3[0], nArray2[8]);
        return new Object[]{nArray, nArray2};
    }

    public final void encrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object, int n3) {
        if (n3 != 16) {
            throw new IllegalArgumentException();
        }
        int[][] nArray = (int[][])((Object[])object)[0];
        Square.square(byArray, n, byArray2, n2, nArray, Te, Se);
    }

    public final void decrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object, int n3) {
        if (n3 != 16) {
            throw new IllegalArgumentException();
        }
        int[][] nArray = (int[][])((Object[])object)[1];
        Square.square(byArray, n, byArray2, n2, nArray, Td, Sd);
    }

    public final boolean selfTest() {
        if (valid == null) {
            boolean bl = super.selfTest();
            if (bl) {
                bl = this.testKat(KAT_KEY, KAT_CT);
            }
            valid = new Boolean(bl);
        }
        return valid;
    }

    public Square() {
        super("square", 16, 16);
    }

    static {
        int n = Sdata.length();
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            char c = Sdata.charAt(n2);
            Square.Se[n3++] = (byte)(c >>> 8);
            Square.Se[n3++] = (byte)c;
            ++n2;
        }
        n2 = 0;
        while (n2 < 256) {
            Square.Sd[Square.Se[n2] & 0xFF] = (byte)n2;
            ++n2;
        }
        Square.OFFSET[0] = 1;
        n2 = 1;
        while (n2 < 8) {
            Square.OFFSET[n2] = Square.mul(OFFSET[n2 - 1], 2);
            int n4 = n2 - 1;
            OFFSET[n4] = OFFSET[n4] << 24;
            ++n2;
        }
        OFFSET[7] = OFFSET[7] << 24;
        n2 = 0;
        while (n2 < 256) {
            n3 = Se[n2] & 0xFF;
            int n5 = 0;
            if (Se[n2 & 3] != 0) {
                n5 = Square.mul(n3, 2) << 24 | n3 << 16 | n3 << 8 | Square.mul(n3, 3);
            }
            Square.Te[n2] = n5;
            n3 = Sd[n2] & 0xFF;
            int n6 = 0;
            if (Sd[n2 & 3] != 0) {
                n6 = Square.mul(n3, 14) << 24 | Square.mul(n3, 9) << 16 | Square.mul(n3, 13) << 8 | Square.mul(n3, 11);
            }
            Square.Td[n2] = n6;
            ++n2;
        }
    }
}

