/*
 * Decompiled with CFR 0.152.
 */
package com.metasploit.meterpreter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TLVPacket {
    public static final int TLV_META_TYPE_NONE = 0;
    public static final int TLV_META_TYPE_STRING = 65536;
    public static final int TLV_META_TYPE_UINT = 131072;
    public static final int TLV_META_TYPE_RAW = 262144;
    public static final int TLV_META_TYPE_BOOL = 524288;
    public static final int TLV_META_TYPE_COMPRESSED = 0x20000000;
    public static final int TLV_META_TYPE_GROUP = 0x40000000;
    public static final int TLV_META_TYPE_COMPLEX = Integer.MIN_VALUE;
    public static final int TLV_META_TYPE_MASK = -535887872;
    private List typeOrder = new ArrayList();
    private Map valueMap = new HashMap();
    private List overflowList = new ArrayList();

    public TLVPacket() {
    }

    public TLVPacket(DataInputStream dataInputStream, int n) throws IOException {
        while (n > 0) {
            Object object;
            Object object2;
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            if (n2 > n) break;
            byte[] byArray = new byte[n2 - 8];
            n -= n2;
            if ((n3 & 0x20000000) != 0) {
                dataInputStream.readFully(byArray);
                object2 = byArray;
            } else if ((n3 & 0x10000) != 0) {
                dataInputStream.readFully(byArray);
                object = new String(byArray, "ISO-8859-1");
                if (!((String)object).endsWith("\u0000")) {
                    throw new IOException("C string is not 0 terminated: " + (String)object);
                }
                if (((String)(object = ((String)object).substring(0, ((String)object).length() - 1))).indexOf(0) != -1) {
                    throw new IOException("Embedded null detected: " + (String)object);
                }
                object2 = object;
            } else if ((n3 & 0x20000) != 0 && n2 == 12) {
                object2 = new Integer(dataInputStream.readInt());
            } else if ((n3 & 0x80000) != 0 && n2 == 9) {
                object2 = new Boolean(dataInputStream.readBoolean());
            } else if ((n3 & 0x40000) != 0) {
                dataInputStream.readFully(byArray);
                object2 = byArray;
            } else if ((n3 & 0x40000000) != 0) {
                dataInputStream.readFully(byArray);
                object = new DataInputStream(new ByteArrayInputStream(byArray));
                object2 = new TLVPacket((DataInputStream)object, byArray.length);
                ((FilterInputStream)object).close();
            } else if ((n3 & Integer.MIN_VALUE) != 0) {
                dataInputStream.readFully(byArray);
                object2 = byArray;
            } else {
                throw new IOException("Unsupported type: " + n3 + "/" + n2);
            }
            this.add(n3, object2);
        }
        if (n != 0) {
            throw new IOException("Incomplete packets detected");
        }
    }

    public void add(int n, Object object) throws IOException {
        Integer n2 = new Integer(n);
        this.typeOrder.add(n2);
        if (this.valueMap.containsKey(n2)) {
            throw new IOException("Duplicate type: " + n);
        }
        this.valueMap.put(n2, object);
    }

    public void addOverflow(int n, Object object) throws IOException {
        this.overflowList.add(new Integer(n));
        this.overflowList.add(object);
    }

    public void add(int n, int n2) throws IOException {
        this.add(n, new Integer(n2));
    }

    public void add(int n, boolean bl) throws IOException {
        this.add(n, new Boolean(bl));
    }

    public List getTypeOrder() {
        return Collections.unmodifiableList(this.typeOrder);
    }

    public Object getValue(int n) {
        Object v = this.valueMap.get(new Integer(n));
        if (v == null) {
            throw new IllegalArgumentException("Cannot find type " + n);
        }
        return v;
    }

    public Object getValue(int n, Object object) {
        Object object2 = this.valueMap.get(new Integer(n));
        if (object2 == null) {
            object2 = object;
        }
        return object2;
    }

    public String getStringValue(int n) {
        return (String)this.getValue(n);
    }

    public String getStringValue(int n, String string) {
        return (String)this.getValue(n, string);
    }

    public int getIntValue(int n) {
        return (Integer)this.getValue(n);
    }

    public boolean getBooleanValue(int n) {
        return (Boolean)this.getValue(n);
    }

    public byte[] getRawValue(int n) {
        return (byte[])this.getValue(n);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        Object object;
        int n;
        Integer n2;
        Iterator iterator = this.typeOrder.iterator();
        while (iterator.hasNext()) {
            n2 = (Integer)iterator.next();
            n = n2;
            object = this.valueMap.get(n2);
            TLVPacket.write(dataOutputStream, n, object);
        }
        iterator = this.overflowList.iterator();
        while (iterator.hasNext()) {
            n2 = (Integer)iterator.next();
            n = n2;
            object = iterator.next();
            TLVPacket.write(dataOutputStream, n, object);
        }
    }

    private static void write(DataOutputStream dataOutputStream, int n, Object object) throws IOException {
        byte[] byArray;
        if ((n & 0x10000) != 0) {
            byArray = ((String)object + "\u0000").getBytes("ISO-8859-1");
        } else {
            if ((n & 0x20000) != 0) {
                dataOutputStream.writeInt(12);
                dataOutputStream.writeInt(n);
                dataOutputStream.writeInt((Integer)object);
                return;
            }
            if ((n & 0x80000) != 0) {
                dataOutputStream.writeInt(9);
                dataOutputStream.writeInt(n);
                dataOutputStream.writeBoolean((Boolean)object);
                return;
            }
            if ((n & 0x40000) != 0) {
                byArray = (byte[])object;
            } else if ((n & 0x40000000) != 0) {
                byArray = ((TLVPacket)object).toByteArray();
            } else if ((n & Integer.MIN_VALUE) != 0) {
                byArray = (byte[])object;
            } else {
                throw new IOException("Unsupported type: " + n);
            }
        }
        dataOutputStream.writeInt(8 + byArray.length);
        dataOutputStream.writeInt(n);
        dataOutputStream.write(byArray);
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.write(new DataOutputStream(byteArrayOutputStream));
        return byteArrayOutputStream.toByteArray();
    }
}

