##
# $Id: tftp.rb 10012 2010-08-14 04:58:27Z jduck $
##

require 'rex/proto/tftp'

module Msf

###
#
# This mixin provides a TFTPServer
#
###
module Exploit::TFTPServer

	def initialize(info = {})
		super

		@tftp = nil
	end

	def start_service(tag, exe)
		@tftp = Rex::Proto::TFTP::Server.new
		@tftp.register_file(tag, exe)
		print_status("Starting TFTP server to host \"#{tag}\" (#{exe.length} bytes)") if datastore['VERBOSE']
		@tftp.start
		add_socket(@tftp.sock)
		@tftp
	end

	def stop_service
		print_status("Stopping TFTP server") if datastore['VERBOSE']
		@tftp.stop
	end

	attr_accessor :tftp
end

end
