# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = %q{id3lib-ruby}
  s.version = "0.6.0"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["Robin Stocker"]
  s.date = %q{2010-05-15}
  s.description = %q{= id3lib-ruby

id3lib-ruby provides a Ruby interface to the id3lib C++ library for easily
editing ID3 tags (v1 and v2) of MP3 audio files.

The class documentation starts at ID3Lib::Tag.


== Features

* Read and write ID3v1 and ID3v2 tags
* Simple interface for adding, changing and removing frames
* Quick access to common text frames like title and performer
* Custom data frames like attached picture (APIC)
* Pretty complete coverage of id3lib's features
* UTF-16 support (warning: id3lib writes broken UTF-16 frames)
* Windows binary gem available

The CHANGES file contains a list of changes between versions.


== Installation

See INSTALL.


== Online Information

The home of id3lib-ruby is http://id3lib-ruby.rubyforge.org


== Usage

  require 'rubygems'
  require 'id3lib'

  # Load a tag from a file
  tag = ID3Lib::Tag.new('talk.mp3')

  # Get and set text frames with convenience methods
  tag.title  #=> "Talk"
  tag.album = 'X&Y'
  tag.track = '5/13'

  # Tag is a subclass of Array and each frame is a Hash
  tag[0]
  #=> { :id => :TPE1, :textenc => 0, :text => "Coldplay" }

  # Get the number of frames
  tag.length  #=> 7

  # Remove all comment frames
  tag.delete_if{ |frame| frame[:id] == :COMM }

  # Get info about APIC frame to see which fields are allowed
  ID3Lib::Info.frame(:APIC)
  #=> [ 2, :APIC, "Attached picture",
  #=>   [:textenc, :mimetype, :picturetype, :description, :data] ]

  # Add an attached picture frame
  cover = {
    :id          => :APIC,
    :mimetype    => 'image/jpeg',
    :picturetype => 3,
    :description => 'A pretty picture',
    :textenc     => 0,
    :data        => File.read('cover.jpg')
  }
  tag << cover

  # Last but not least, apply changes
  tag.update!


== Licence

This library has Ruby's licence:

http://www.ruby-lang.org/en/LICENSE.txt


== Author

Robin Stocker <robinstocker at rubyforge.org>
}
  s.email = %q{robinstocker@rubyforge.org}
  s.extensions = ["ext/id3lib_api/extconf.rb"]
  s.extra_rdoc_files = ["README", "INSTALL", "TODO", "CHANGES"]
  s.files = ["lib/id3lib/accessors.rb", "lib/id3lib/info.rb", "lib/id3lib.rb", "test/test_unicode.rb", "test/test_writing.rb", "test/test_reading.rb", "test/data/sample.mp3", "test/data/unicode.mp3", "test/data/cover.jpg", "Rakefile", "usage.rb", "setup.rb", "ext/id3lib_api/extconf.rb", "ext/id3lib_api/id3lib_api_wrap.cxx", "ext/id3lib_api/id3lib_api.i", "ext/id3lib_api/Rakefile", "README", "INSTALL", "TODO", "CHANGES"]
  s.homepage = %q{http://id3lib-ruby.rubyforge.org}
  s.rdoc_options = ["--inline-source", "--line-numbers", "--main", "README"]
  s.require_paths = ["lib"]
  s.requirements = ["id3lib C++ library"]
  s.rubyforge_project = %q{id3lib-ruby}
  s.rubygems_version = %q{1.3.7}
  s.summary = %q{id3lib-ruby provides a Ruby interface to the id3lib C++ library for easily editing ID3 tags (v1 and v2) of MP3 audio files.}
  s.test_files = ["test/test_unicode.rb", "test/test_writing.rb", "test/test_reading.rb"]

  if s.respond_to? :specification_version then
    current_version = Gem::Specification::CURRENT_SPECIFICATION_VERSION
    s.specification_version = 3

    if Gem::Version.new(Gem::VERSION) >= Gem::Version.new('1.2.0') then
    else
    end
  else
  end
end
