/* $OpenBSD: ec_curve.c,v 1.58 2025/05/10 05:54:38 tb Exp $ */
/*
 * Written by Nils Larsch for the OpenSSL project.
 */
/* ====================================================================
 * Copyright (c) 1998-2010 The OpenSSL Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit. (http://www.openssl.org/)"
 *
 * 4. The names "OpenSSL Toolkit" and "OpenSSL Project" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    openssl-core@openssl.org.
 *
 * 5. Products derived from this software may not be called "OpenSSL"
 *    nor may "OpenSSL" appear in their names without prior written
 *    permission of the OpenSSL Project.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit (http://www.openssl.org/)"
 *
 * THIS SOFTWARE IS PROVIDED BY THE OpenSSL PROJECT ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OpenSSL PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This product includes cryptographic software written by Eric Young
 * (eay@cryptsoft.com).  This product includes software written by Tim
 * Hudson (tjh@cryptsoft.com).
 *
 */
/* ====================================================================
 * Copyright 2002 Sun Microsystems, Inc. ALL RIGHTS RESERVED.
 *
 * Portions of the attached software ("Contribution") are developed by
 * SUN MICROSYSTEMS, INC., and are contributed to the OpenSSL project.
 *
 * The Contribution is licensed pursuant to the OpenSSL open source
 * license provided above.
 *
 * The elliptic curve binary polynomial software is originally written by
 * Sheueling Chang Shantz and Douglas Stebila of Sun Microsystems Laboratories.
 *
 */

#include <limits.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>

#include <openssl/opensslconf.h>

#include <openssl/bn.h>
#include <openssl/ec.h>
#include <openssl/objects.h>

#include "ec_local.h"
#include "err_local.h"

static const struct {
	uint8_t seed[20];
	uint8_t p[28];
	uint8_t a[28];
	uint8_t b[28];
	uint8_t x[28];
	uint8_t y[28];
	uint8_t order[28];
} _EC_NIST_PRIME_224 = {
	.seed = {
		0xbd, 0x71, 0x34, 0x47, 0x99, 0xd5, 0xc7, 0xfc, 0xdc, 0x45,
		0xb5, 0x9f, 0xa3, 0xb9, 0xab, 0x8f, 0x6a, 0x94, 0x8b, 0xc5,
	},
	.p = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	},
	.a = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
	},
	.b = {
		0xb4, 0x05, 0x0a, 0x85, 0x0c, 0x04, 0xb3, 0xab, 0xf5, 0x41,
		0x32, 0x56, 0x50, 0x44, 0xb0, 0xb7, 0xd7, 0xbf, 0xd8, 0xba,
		0x27, 0x0b, 0x39, 0x43, 0x23, 0x55, 0xff, 0xb4,
	},
	.x = {
		0xb7, 0x0e, 0x0c, 0xbd, 0x6b, 0xb4, 0xbf, 0x7f, 0x32, 0x13,
		0x90, 0xb9, 0x4a, 0x03, 0xc1, 0xd3, 0x56, 0xc2, 0x11, 0x22,
		0x34, 0x32, 0x80, 0xd6, 0x11, 0x5c, 0x1d, 0x21,
	},
	.y = {
		0xbd, 0x37, 0x63, 0x88, 0xb5, 0xf7, 0x23, 0xfb, 0x4c, 0x22,
		0xdf, 0xe6, 0xcd, 0x43, 0x75, 0xa0, 0x5a, 0x07, 0x47, 0x64,
		0x44, 0xd5, 0x81, 0x99, 0x85, 0x00, 0x7e, 0x34,
	},
	.order = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0x16, 0xa2, 0xe0, 0xb8, 0xf0, 0x3e,
		0x13, 0xdd, 0x29, 0x45, 0x5c, 0x5c, 0x2a, 0x3d,
	},
};

static const struct {
	uint8_t seed[20];
	uint8_t p[32];
	uint8_t a[32];
	uint8_t b[32];
	uint8_t x[32];
	uint8_t y[32];
	uint8_t order[32];
} _EC_NIST_PRIME_256 = {
	.seed = {
		0xc4, 0x9d, 0x36, 0x08, 0x86, 0xe7, 0x04, 0x93, 0x6a, 0x66,
		0x78, 0xe1, 0x13, 0x9d, 0x26, 0xb7, 0x81, 0x9f, 0x7e, 0x90,
	},
	.p = {
		0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff,
	},
	.a = {
		0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xfc,
	},
	.b = {
		0x5a, 0xc6, 0x35, 0xd8, 0xaa, 0x3a, 0x93, 0xe7, 0xb3, 0xeb,
		0xbd, 0x55, 0x76, 0x98, 0x86, 0xbc, 0x65, 0x1d, 0x06, 0xb0,
		0xcc, 0x53, 0xb0, 0xf6, 0x3b, 0xce, 0x3c, 0x3e, 0x27, 0xd2,
		0x60, 0x4b,
	},
	.x = {
		0x6b, 0x17, 0xd1, 0xf2, 0xe1, 0x2c, 0x42, 0x47, 0xf8, 0xbc,
		0xe6, 0xe5, 0x63, 0xa4, 0x40, 0xf2, 0x77, 0x03, 0x7d, 0x81,
		0x2d, 0xeb, 0x33, 0xa0, 0xf4, 0xa1, 0x39, 0x45, 0xd8, 0x98,
		0xc2, 0x96,
	},
	.y = {
		0x4f, 0xe3, 0x42, 0xe2, 0xfe, 0x1a, 0x7f, 0x9b, 0x8e, 0xe7,
		0xeb, 0x4a, 0x7c, 0x0f, 0x9e, 0x16, 0x2b, 0xce, 0x33, 0x57,
		0x6b, 0x31, 0x5e, 0xce, 0xcb, 0xb6, 0x40, 0x68, 0x37, 0xbf,
		0x51, 0xf5,
	},
	.order = {
		0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad,
		0xa7, 0x17, 0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63,
		0x25, 0x51,
	},
};

static const struct {
	uint8_t seed[20];
	uint8_t p[48];
	uint8_t a[48];
	uint8_t b[48];
	uint8_t x[48];
	uint8_t y[48];
	uint8_t order[48];
} _EC_NIST_PRIME_384 = {
	.seed = {
		0xa3, 0x35, 0x92, 0x6a, 0xa3, 0x19, 0xa2, 0x7a, 0x1d, 0x00,
		0x89, 0x6a, 0x67, 0x73, 0xa4, 0x82, 0x7a, 0xcd, 0xac, 0x73,
	},
	.p = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
	},
	.a = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xfe, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xfc,
	},
	.b = {
		0xb3, 0x31, 0x2f, 0xa7, 0xe2, 0x3e, 0xe7, 0xe4, 0x98, 0x8e,
		0x05, 0x6b, 0xe3, 0xf8, 0x2d, 0x19, 0x18, 0x1d, 0x9c, 0x6e,
		0xfe, 0x81, 0x41, 0x12, 0x03, 0x14, 0x08, 0x8f, 0x50, 0x13,
		0x87, 0x5a, 0xc6, 0x56, 0x39, 0x8d, 0x8a, 0x2e, 0xd1, 0x9d,
		0x2a, 0x85, 0xc8, 0xed, 0xd3, 0xec, 0x2a, 0xef,
	},
	.x = {
		0xaa, 0x87, 0xca, 0x22, 0xbe, 0x8b, 0x05, 0x37, 0x8e, 0xb1,
		0xc7, 0x1e, 0xf3, 0x20, 0xad, 0x74, 0x6e, 0x1d, 0x3b, 0x62,
		0x8b, 0xa7, 0x9b, 0x98, 0x59, 0xf7, 0x41, 0xe0, 0x82, 0x54,
		0x2a, 0x38, 0x55, 0x02, 0xf2, 0x5d, 0xbf, 0x55, 0x29, 0x6c,
		0x3a, 0x54, 0x5e, 0x38, 0x72, 0x76, 0x0a, 0xb7,
	},
	.y = {
		0x36, 0x17, 0xde, 0x4a, 0x96, 0x26, 0x2c, 0x6f, 0x5d, 0x9e,
		0x98, 0xbf, 0x92, 0x92, 0xdc, 0x29, 0xf8, 0xf4, 0x1d, 0xbd,
		0x28, 0x9a, 0x14, 0x7c, 0xe9, 0xda, 0x31, 0x13, 0xb5, 0xf0,
		0xb8, 0xc0, 0x0a, 0x60, 0xb1, 0xce, 0x1d, 0x7e, 0x81, 0x9d,
		0x7a, 0x43, 0x1d, 0x7c, 0x90, 0xea, 0x0e, 0x5f,
	},
	.order = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xc7, 0x63, 0x4d, 0x81, 0xf4, 0x37,
		0x2d, 0xdf, 0x58, 0x1a, 0x0d, 0xb2, 0x48, 0xb0, 0xa7, 0x7a,
		0xec, 0xec, 0x19, 0x6a, 0xcc, 0xc5, 0x29, 0x73,
	},
};

static const struct {
	uint8_t seed[20];
	uint8_t p[66];
	uint8_t a[66];
	uint8_t b[66];
	uint8_t x[66];
	uint8_t y[66];
	uint8_t order[66];
} _EC_NIST_PRIME_521 = {
	.seed = {
		0xd0, 0x9e, 0x88, 0x00, 0x29, 0x1c, 0xb8, 0x53, 0x96, 0xcc,
		0x67, 0x17, 0x39, 0x32, 0x84, 0xaa, 0xa0, 0xda, 0x64, 0xba,
	},
	.p = {
		0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	},
	.a = {
		0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
	},
	.b = {
		0x00, 0x51, 0x95, 0x3e, 0xb9, 0x61, 0x8e, 0x1c, 0x9a, 0x1f,
		0x92, 0x9a, 0x21, 0xa0, 0xb6, 0x85, 0x40, 0xee, 0xa2, 0xda,
		0x72, 0x5b, 0x99, 0xb3, 0x15, 0xf3, 0xb8, 0xb4, 0x89, 0x91,
		0x8e, 0xf1, 0x09, 0xe1, 0x56, 0x19, 0x39, 0x51, 0xec, 0x7e,
		0x93, 0x7b, 0x16, 0x52, 0xc0, 0xbd, 0x3b, 0xb1, 0xbf, 0x07,
		0x35, 0x73, 0xdf, 0x88, 0x3d, 0x2c, 0x34, 0xf1, 0xef, 0x45,
		0x1f, 0xd4, 0x6b, 0x50, 0x3f, 0x00,
	},
	.x = {
		0x00, 0xc6, 0x85, 0x8e, 0x06, 0xb7, 0x04, 0x04, 0xe9, 0xcd,
		0x9e, 0x3e, 0xcb, 0x66, 0x23, 0x95, 0xb4, 0x42, 0x9c, 0x64,
		0x81, 0x39, 0x05, 0x3f, 0xb5, 0x21, 0xf8, 0x28, 0xaf, 0x60,
		0x6b, 0x4d, 0x3d, 0xba, 0xa1, 0x4b, 0x5e, 0x77, 0xef, 0xe7,
		0x59, 0x28, 0xfe, 0x1d, 0xc1, 0x27, 0xa2, 0xff, 0xa8, 0xde,
		0x33, 0x48, 0xb3, 0xc1, 0x85, 0x6a, 0x42, 0x9b, 0xf9, 0x7e,
		0x7e, 0x31, 0xc2, 0xe5, 0xbd, 0x66,
	},
	.y = {
		0x01, 0x18, 0x39, 0x29, 0x6a, 0x78, 0x9a, 0x3b, 0xc0, 0x04,
		0x5c, 0x8a, 0x5f, 0xb4, 0x2c, 0x7d, 0x1b, 0xd9, 0x98, 0xf5,
		0x44, 0x49, 0x57, 0x9b, 0x44, 0x68, 0x17, 0xaf, 0xbd, 0x17,
		0x27, 0x3e, 0x66, 0x2c, 0x97, 0xee, 0x72, 0x99, 0x5e, 0xf4,
		0x26, 0x40, 0xc5, 0x50, 0xb9, 0x01, 0x3f, 0xad, 0x07, 0x61,
		0x35, 0x3c, 0x70, 0x86, 0xa2, 0x72, 0xc2, 0x40, 0x88, 0xbe,
		0x94, 0x76, 0x9f, 0xd1, 0x66, 0x50,
	},
	.order = {
		0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xfa, 0x51, 0x86, 0x87, 0x83, 0xbf, 0x2f,
		0x96, 0x6b, 0x7f, 0xcc, 0x01, 0x48, 0xf7, 0x09, 0xa5, 0xd0,
		0x3b, 0xb5, 0xc9, 0xb8, 0x89, 0x9c, 0x47, 0xae, 0xbb, 0x6f,
		0xb7, 0x1e, 0x91, 0x38, 0x64, 0x09,
	},
};

static const struct {
	uint8_t p[29];
	uint8_t a[29];
	uint8_t b[29];
	uint8_t x[29];
	uint8_t y[29];
	uint8_t order[29];
} _EC_SECG_PRIME_224K1 = {
	.p = {
		0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xe5, 0x6d,
	},
	.a = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	},
	.b = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
	},
	.x = {
		0x00, 0xa1, 0x45, 0x5b, 0x33, 0x4d, 0xf0, 0x99, 0xdf, 0x30,
		0xfc, 0x28, 0xa1, 0x69, 0xa4, 0x67, 0xe9, 0xe4, 0x70, 0x75,
		0xa9, 0x0f, 0x7e, 0x65, 0x0e, 0xb6, 0xb7, 0xa4, 0x5c,
	},
	.y = {
		0x00, 0x7e, 0x08, 0x9f, 0xed, 0x7f, 0xba, 0x34, 0x42, 0x82,
		0xca, 0xfb, 0xd6, 0xf7, 0xe3, 0x19, 0xf7, 0xc0, 0xb0, 0xbd,
		0x59, 0xe2, 0xca, 0x4b, 0xdb, 0x55, 0x6d, 0x61, 0xa5,
	},
	.order = {
		0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x01, 0xdc, 0xe8, 0xd2, 0xec, 0x61,
		0x84, 0xca, 0xf0, 0xa9, 0x71, 0x76, 0x9f, 0xb1, 0xf7,
	},
};

static const struct {
	uint8_t p[32];
	uint8_t a[32];
	uint8_t b[32];
	uint8_t x[32];
	uint8_t y[32];
	uint8_t order[32];
} _EC_SECG_PRIME_256K1 = {
	.p = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff,
		0xfc, 0x2f,
	},
	.a = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00,
	},
	.b = {
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x07,
	},
	.x = {
		0x79, 0xbe, 0x66, 0x7e, 0xf9, 0xdc, 0xbb, 0xac, 0x55, 0xa0,
		0x62, 0x95, 0xce, 0x87, 0x0b, 0x07, 0x02, 0x9b, 0xfc, 0xdb,
		0x2d, 0xce, 0x28, 0xd9, 0x59, 0xf2, 0x81, 0x5b, 0x16, 0xf8,
		0x17, 0x98,
	},
	.y = {
		0x48, 0x3a, 0xda, 0x77, 0x26, 0xa3, 0xc4, 0x65, 0x5d, 0xa4,
		0xfb, 0xfc, 0x0e, 0x11, 0x08, 0xa8, 0xfd, 0x17, 0xb4, 0x48,
		0xa6, 0x85, 0x54, 0x19, 0x9c, 0x47, 0xd0, 0x8f, 0xfb, 0x10,
		0xd4, 0xb8,
	},
	.order = {
		0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
		0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xba, 0xae, 0xdc, 0xe6,
		0xaf, 0x48, 0xa0, 0x3b, 0xbf, 0xd2, 0x5e, 0x8c, 0xd0, 0x36,
		0x41, 0x41,
	},
};

static const struct {
	uint8_t p[28];
	uint8_t a[28];
	uint8_t b[28];
	uint8_t x[28];
	uint8_t y[28];
	uint8_t order[28];
} _EC_brainpoolP224r1 = {
	.p = {
		0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18,
		0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57,
		0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff,
	},
	.a = {
		0x68, 0xa5, 0xe6, 0x2c, 0xa9, 0xce, 0x6c, 0x1c, 0x29, 0x98,
		0x03, 0xa6, 0xc1, 0x53, 0x0b, 0x51, 0x4e, 0x18, 0x2a, 0xd8,
		0xb0, 0x04, 0x2a, 0x59, 0xca, 0xd2, 0x9f, 0x43,
	},
	.b = {
		0x25, 0x80, 0xf6, 0x3c, 0xcf, 0xe4, 0x41, 0x38, 0x87, 0x07,
		0x13, 0xb1, 0xa9, 0x23, 0x69, 0xe3, 0x3e, 0x21, 0x35, 0xd2,
		0x66, 0xdb, 0xb3, 0x72, 0x38, 0x6c, 0x40, 0x0b,
	},
	.x = {
		0x0d, 0x90, 0x29, 0xad, 0x2c, 0x7e, 0x5c, 0xf4, 0x34, 0x08,
		0x23, 0xb2, 0xa8, 0x7d, 0xc6, 0x8c, 0x9e, 0x4c, 0xe3, 0x17,
		0x4c, 0x1e, 0x6e, 0xfd, 0xee, 0x12, 0xc0, 0x7d,
	},
	.y = {
		0x58, 0xaa, 0x56, 0xf7, 0x72, 0xc0, 0x72, 0x6f, 0x24, 0xc6,
		0xb8, 0x9e, 0x4e, 0xcd, 0xac, 0x24, 0x35, 0x4b, 0x9e, 0x99,
		0xca, 0xa3, 0xf6, 0xd3, 0x76, 0x14, 0x02, 0xcd,
	},
	.order = {
		0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18,
		0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b,
		0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f,
	},
};

static const struct {
	uint8_t p[28];
	uint8_t a[28];
	uint8_t b[28];
	uint8_t x[28];
	uint8_t y[28];
	uint8_t order[28];
} _EC_brainpoolP224t1 = {
	.p = {
		0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18,
		0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57,
		0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xff,
	},
	.a = {
		0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18,
		0x30, 0x25, 0x75, 0xd1, 0xd7, 0x87, 0xb0, 0x9f, 0x07, 0x57,
		0x97, 0xda, 0x89, 0xf5, 0x7e, 0xc8, 0xc0, 0xfc,
	},
	.b = {
		0x4b, 0x33, 0x7d, 0x93, 0x41, 0x04, 0xcd, 0x7b, 0xef, 0x27,
		0x1b, 0xf6, 0x0c, 0xed, 0x1e, 0xd2, 0x0d, 0xa1, 0x4c, 0x08,
		0xb3, 0xbb, 0x64, 0xf1, 0x8a, 0x60, 0x88, 0x8d,
	},
	.x = {
		0x6a, 0xb1, 0xe3, 0x44, 0xce, 0x25, 0xff, 0x38, 0x96, 0x42,
		0x4e, 0x7f, 0xfe, 0x14, 0x76, 0x2e, 0xcb, 0x49, 0xf8, 0x92,
		0x8a, 0xc0, 0xc7, 0x60, 0x29, 0xb4, 0xd5, 0x80,
	},
	.y = {
		0x03, 0x74, 0xe9, 0xf5, 0x14, 0x3e, 0x56, 0x8c, 0xd2, 0x3f,
		0x3f, 0x4d, 0x7c, 0x0d, 0x4b, 0x1e, 0x41, 0xc8, 0xcc, 0x0d,
		0x1c, 0x6a, 0xbd, 0x5f, 0x1a, 0x46, 0xdb, 0x4c,
	},
	.order = {
		0xd7, 0xc1, 0x34, 0xaa, 0x26, 0x43, 0x66, 0x86, 0x2a, 0x18,
		0x30, 0x25, 0x75, 0xd0, 0xfb, 0x98, 0xd1, 0x16, 0xbc, 0x4b,
		0x6d, 0xde, 0xbc, 0xa3, 0xa5, 0xa7, 0x93, 0x9f,
	},
};

static const struct {
	uint8_t p[32];
	uint8_t a[32];
	uint8_t b[32];
	uint8_t x[32];
	uint8_t y[32];
	uint8_t order[32];
} _EC_brainpoolP256r1 = {
	.p = {
		0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66,
		0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23,
		0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e,
		0x53, 0x77,
	},
	.a = {
		0x7d, 0x5a, 0x09, 0x75, 0xfc, 0x2c, 0x30, 0x57, 0xee, 0xf6,
		0x75, 0x30, 0x41, 0x7a, 0xff, 0xe7, 0xfb, 0x80, 0x55, 0xc1,
		0x26, 0xdc, 0x5c, 0x6c, 0xe9, 0x4a, 0x4b, 0x44, 0xf3, 0x30,
		0xb5, 0xd9,
	},
	.b = {
		0x26, 0xdc, 0x5c, 0x6c, 0xe9, 0x4a, 0x4b, 0x44, 0xf3, 0x30,
		0xb5, 0xd9, 0xbb, 0xd7, 0x7c, 0xbf, 0x95, 0x84, 0x16, 0x29,
		0x5c, 0xf7, 0xe1, 0xce, 0x6b, 0xcc, 0xdc, 0x18, 0xff, 0x8c,
		0x07, 0xb6,
	},
	.x = {
		0x8b, 0xd2, 0xae, 0xb9, 0xcb, 0x7e, 0x57, 0xcb, 0x2c, 0x4b,
		0x48, 0x2f, 0xfc, 0x81, 0xb7, 0xaf, 0xb9, 0xde, 0x27, 0xe1,
		0xe3, 0xbd, 0x23, 0xc2, 0x3a, 0x44, 0x53, 0xbd, 0x9a, 0xce,
		0x32, 0x62,
	},
	.y = {
		0x54, 0x7e, 0xf8, 0x35, 0xc3, 0xda, 0xc4, 0xfd, 0x97, 0xf8,
		0x46, 0x1a, 0x14, 0x61, 0x1d, 0xc9, 0xc2, 0x77, 0x45, 0x13,
		0x2d, 0xed, 0x8e, 0x54, 0x5c, 0x1d, 0x54, 0xc7, 0x2f, 0x04,
		0x69, 0x97,
	},
	.order = {
		0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66,
		0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3,
		0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48,
		0x56, 0xa7,
	},
};

static const struct {
	uint8_t p[32];
	uint8_t a[32];
	uint8_t b[32];
	uint8_t x[32];
	uint8_t y[32];
	uint8_t order[32];
} _EC_brainpoolP256t1 = {
	.p = {
		0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66,
		0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23,
		0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e,
		0x53, 0x77,
	},
	.a = {
		0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66,
		0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x72, 0x6e, 0x3b, 0xf6, 0x23,
		0xd5, 0x26, 0x20, 0x28, 0x20, 0x13, 0x48, 0x1d, 0x1f, 0x6e,
		0x53, 0x74,
	},
	.b = {
		0x66, 0x2c, 0x61, 0xc4, 0x30, 0xd8, 0x4e, 0xa4, 0xfe, 0x66,
		0xa7, 0x73, 0x3d, 0x0b, 0x76, 0xb7, 0xbf, 0x93, 0xeb, 0xc4,
		0xaf, 0x2f, 0x49, 0x25, 0x6a, 0xe5, 0x81, 0x01, 0xfe, 0xe9,
		0x2b, 0x04,
	},
	.x = {
		0xa3, 0xe8, 0xeb, 0x3c, 0xc1, 0xcf, 0xe7, 0xb7, 0x73, 0x22,
		0x13, 0xb2, 0x3a, 0x65, 0x61, 0x49, 0xaf, 0xa1, 0x42, 0xc4,
		0x7a, 0xaf, 0xbc, 0x2b, 0x79, 0xa1, 0x91, 0x56, 0x2e, 0x13,
		0x05, 0xf4,
	},
	.y = {
		0x2d, 0x99, 0x6c, 0x82, 0x34, 0x39, 0xc5, 0x6d, 0x7f, 0x7b,
		0x22, 0xe1, 0x46, 0x44, 0x41, 0x7e, 0x69, 0xbc, 0xb6, 0xde,
		0x39, 0xd0, 0x27, 0x00, 0x1d, 0xab, 0xe8, 0xf3, 0x5b, 0x25,
		0xc9, 0xbe,
	},
	.order = {
		0xa9, 0xfb, 0x57, 0xdb, 0xa1, 0xee, 0xa9, 0xbc, 0x3e, 0x66,
		0x0a, 0x90, 0x9d, 0x83, 0x8d, 0x71, 0x8c, 0x39, 0x7a, 0xa3,
		0xb5, 0x61, 0xa6, 0xf7, 0x90, 0x1e, 0x0e, 0x82, 0x97, 0x48,
		0x56, 0xa7,
	},
};

static const struct {
	uint8_t p[40];
	uint8_t a[40];
	uint8_t b[40];
	uint8_t x[40];
	uint8_t y[40];
	uint8_t order[40];
} _EC_brainpoolP320r1 = {
	.p = {
		0xd3, 0x5e, 0x47, 0x20, 0x36, 0xbc, 0x4f, 0xb7, 0xe1, 0x3c,
		0x78, 0x5e, 0xd2, 0x01, 0xe0, 0x65, 0xf9, 0x8f, 0xcf, 0xa6,
		0xf6, 0xf4, 0x0d, 0xef, 0x4f, 0x92, 0xb9, 0xec, 0x78, 0x93,
		0xec, 0x28, 0xfc, 0xd4, 0x12, 0xb1, 0xf1, 0xb3, 0x2e, 0x27,
	},
	.a = {
		0x3e, 0xe3, 0x0b, 0x56, 0x8f, 0xba, 0xb0, 0xf8, 0x83, 0xcc,
		0xeb, 0xd4, 0x6d, 0x3f, 0x3b, 0xb8, 0xa2, 0xa7, 0x35, 0x13,
		0xf5, 0xeb, 0x79, 0xda, 0x66, 0x19, 0x0e, 0xb0, 0x85, 0xff,
		0xa9, 0xf4, 0x92, 0xf3, 0x75, 0xa9, 0x7d, 0x86, 0x0e, 0xb4,
	},
	.b = {
		0x52, 0x08, 0x83, 0x94, 0x9d, 0xfd, 0xbc, 0x42, 0xd3, 0xad,
		0x19, 0x86, 0x40, 0x68, 0x8a, 0x6f, 0xe1, 0x3f, 0x41, 0x34,
		0x95, 0x54, 0xb4, 0x9a, 0xcc, 0x31, 0xdc, 0xcd, 0x88, 0x45,
		0x39, 0x81, 0x6f, 0x5e, 0xb4, 0xac, 0x8f, 0xb1, 0xf1, 0xa6,
	},
	.x = {
		0x43, 0xbd, 0x7e, 0x9a, 0xfb, 0x53, 0xd8, 0xb8, 0x52, 0x89,
		0xbc, 0xc4, 0x8e, 0xe5, 0xbf, 0xe6, 0xf2, 0x01, 0x37, 0xd1,
		0x0a, 0x08, 0x7e, 0xb6, 0xe7, 0x87, 0x1e, 0x2a, 0x10, 0xa5,
		0x99, 0xc7, 0x10, 0xaf, 0x8d, 0x0d, 0x39, 0xe2, 0x06, 0x11,
	},
	.y = {
		0x14, 0xfd, 0xd0, 0x55, 0x45, 0xec, 0x1c, 0xc8, 0xab, 0x40,
		0x93, 0x24, 0x7f, 0x77, 0x27, 0x5e, 0x07, 0x43, 0xff, 0xed,
		0x11, 0x71, 0x82, 0xea, 0xa9, 0xc7, 0x78, 0x77, 0xaa, 0xac,
		0x6a, 0xc7, 0xd3, 0x52, 0x45, 0xd1, 0x69, 0x2e, 0x8e, 0xe1,
	},
	.order = {
		0xd3, 0x5e, 0x47, 0x20, 0x36, 0xbc, 0x4f, 0xb7, 0xe1, 0x3c,
		0x78, 0x5e, 0xd2, 0x01, 0xe0, 0x65, 0xf9, 0x8f, 0xcf, 0xa5,
		0xb6, 0x8f, 0x12, 0xa3, 0x2d, 0x48, 0x2e, 0xc7, 0xee, 0x86,
		0x58, 0xe9, 0x86, 0x91, 0x55, 0x5b, 0x44, 0xc5, 0x93, 0x11,
	},
};

static const struct {
	uint8_t p[40];
	uint8_t a[40];
	uint8_t b[40];
	uint8_t x[40];
	uint8_t y[40];
	uint8_t order[40];
} _EC_brainpoolP320t1 = {
	.p = {
		0xd3, 0x5e, 0x47, 0x20, 0x36, 0xbc, 0x4f, 0xb7, 0xe1, 0x3c,
		0x78, 0x5e, 0xd2, 0x01, 0xe0, 0x65, 0xf9, 0x8f, 0xcf, 0xa6,
		0xf6, 0xf4, 0x0d, 0xef, 0x4f, 0x92, 0xb9, 0xec, 0x78, 0x93,
		0xec, 0x28, 0xfc, 0xd4, 0x12, 0xb1, 0xf1, 0xb3, 0x2e, 0x27,
	},
	.a = {
		0xd3, 0x5e, 0x47, 0x20, 0x36, 0xbc, 0x4f, 0xb7, 0xe1, 0x3c,
		0x78, 0x5e, 0xd2, 0x01, 0xe0, 0x65, 0xf9, 0x8f, 0xcf, 0xa6,
		0xf6, 0xf4, 0x0d, 0xef, 0x4f, 0x92, 0xb9, 0xec, 0x78, 0x93,
		0xec, 0x28, 0xfc, 0xd4, 0x12, 0xb1, 0xf1, 0xb3, 0x2e, 0x24,
	},
	.b = {
		0xa7, 0xf5, 0x61, 0xe0, 0x38, 0xeb, 0x1e, 0xd5, 0x60, 0xb3,
		0xd1, 0x47, 0xdb, 0x78, 0x20, 0x13, 0x06, 0x4c, 0x19, 0xf2,
		0x7e, 0xd2, 0x7c, 0x67, 0x80, 0xaa, 0xf7, 0x7f, 0xb8, 0xa5,
		0x47, 0xce, 0xb5, 0xb4, 0xfe, 0xf4, 0x22, 0x34, 0x03, 0x53,
	},
	.x = {
		0x92, 0x5b, 0xe9, 0xfb, 0x01, 0xaf, 0xc6, 0xfb, 0x4d, 0x3e,
		0x7d, 0x49, 0x90, 0x01, 0x0f, 0x81, 0x34, 0x08, 0xab, 0x10,
		0x6c, 0x4f, 0x09, 0xcb, 0x7e, 0xe0, 0x78, 0x68, 0xcc, 0x13,
		0x6f, 0xff, 0x33, 0x57, 0xf6, 0x24, 0xa2, 0x1b, 0xed, 0x52,
	},
	.y = {
		0x63, 0xba, 0x3a, 0x7a, 0x27, 0x48, 0x3e, 0xbf, 0x66, 0x71,
		0xdb, 0xef, 0x7a, 0xbb, 0x30, 0xeb, 0xee, 0x08, 0x4e, 0x58,
		0xa0, 0xb0, 0x77, 0xad, 0x42, 0xa5, 0xa0, 0x98, 0x9d, 0x1e,
		0xe7, 0x1b, 0x1b, 0x9b, 0xc0, 0x45, 0x5f, 0xb0, 0xd2, 0xc3,
	},
	.order = {
		0xd3, 0x5e, 0x47, 0x20, 0x36, 0xbc, 0x4f, 0xb7, 0xe1, 0x3c,
		0x78, 0x5e, 0xd2, 0x01, 0xe0, 0x65, 0xf9, 0x8f, 0xcf, 0xa5,
		0xb6, 0x8f, 0x12, 0xa3, 0x2d, 0x48, 0x2e, 0xc7, 0xee, 0x86,
		0x58, 0xe9, 0x86, 0x91, 0x55, 0x5b, 0x44, 0xc5, 0x93, 0x11,
	},
};

static const struct {
	uint8_t p[48];
	uint8_t a[48];
	uint8_t b[48];
	uint8_t x[48];
	uint8_t y[48];
	uint8_t order[48];
} _EC_brainpoolP384r1 = {
	.p = {
		0x8c, 0xb9, 0x1e, 0x82, 0xa3, 0x38, 0x6d, 0x28, 0x0f, 0x5d,
		0x6f, 0x7e, 0x50, 0xe6, 0x41, 0xdf, 0x15, 0x2f, 0x71, 0x09,
		0xed, 0x54, 0x56, 0xb4, 0x12, 0xb1, 0xda, 0x19, 0x7f, 0xb7,
		0x11, 0x23, 0xac, 0xd3, 0xa7, 0x29, 0x90, 0x1d, 0x1a, 0x71,
		0x87, 0x47, 0x00, 0x13, 0x31, 0x07, 0xec, 0x53,
	},
	.a = {
		0x7b, 0xc3, 0x82, 0xc6, 0x3d, 0x8c, 0x15, 0x0c, 0x3c, 0x72,
		0x08, 0x0a, 0xce, 0x05, 0xaf, 0xa0, 0xc2, 0xbe, 0xa2, 0x8e,
		0x4f, 0xb2, 0x27, 0x87, 0x13, 0x91, 0x65, 0xef, 0xba, 0x91,
		0xf9, 0x0f, 0x8a, 0xa5, 0x81, 0x4a, 0x50, 0x3a, 0xd4, 0xeb,
		0x04, 0xa8, 0xc7, 0xdd, 0x22, 0xce, 0x28, 0x26,
	},
	.b = {
		0x04, 0xa8, 0xc7, 0xdd, 0x22, 0xce, 0x28, 0x26, 0x8b, 0x39,
		0xb5, 0x54, 0x16, 0xf0, 0x44, 0x7c, 0x2f, 0xb7, 0x7d, 0xe1,
		0x07, 0xdc, 0xd2, 0xa6, 0x2e, 0x88, 0x0e, 0xa5, 0x3e, 0xeb,
		0x62, 0xd5, 0x7c, 0xb4, 0x39, 0x02, 0x95, 0xdb, 0xc9, 0x94,
		0x3a, 0xb7, 0x86, 0x96, 0xfa, 0x50, 0x4c, 0x11,
	},
	.x = {
		0x1d, 0x1c, 0x64, 0xf0, 0x68, 0xcf, 0x45, 0xff, 0xa2, 0xa6,
		0x3a, 0x81, 0xb7, 0xc1, 0x3f, 0x6b, 0x88, 0x47, 0xa3, 0xe7,
		0x7e, 0xf1, 0x4f, 0xe3, 0xdb, 0x7f, 0xca, 0xfe, 0x0c, 0xbd,
		0x10, 0xe8, 0xe8, 0x26, 0xe0, 0x34, 0x36, 0xd6, 0x46, 0xaa,
		0xef, 0x87, 0xb2, 0xe2, 0x47, 0xd4, 0xaf, 0x1e,
	},
	.y = {
		0x8a, 0xbe, 0x1d, 0x75, 0x20, 0xf9, 0xc2, 0xa4, 0x5c, 0xb1,
		0xeb, 0x8e, 0x95, 0xcf, 0xd5, 0x52, 0x62, 0xb7, 0x0b, 0x29,
		0xfe, 0xec, 0x58, 0x64, 0xe1, 0x9c, 0x05, 0x4f, 0xf9, 0x91,
		0x29, 0x28, 0x0e, 0x46, 0x46, 0x21, 0x77, 0x91, 0x81, 0x11,
		0x42, 0x82, 0x03, 0x41, 0x26, 0x3c, 0x53, 0x15,
	},
	.order = {
		0x8c, 0xb9, 0x1e, 0x82, 0xa3, 0x38, 0x6d, 0x28, 0x0f, 0x5d,
		0x6f, 0x7e, 0x50, 0xe6, 0x41, 0xdf, 0x15, 0x2f, 0x71, 0x09,
		0xed, 0x54, 0x56, 0xb3, 0x1f, 0x16, 0x6e, 0x6c, 0xac, 0x04,
		0x25, 0xa7, 0xcf, 0x3a, 0xb6, 0xaf, 0x6b, 0x7f, 0xc3, 0x10,
		0x3b, 0x88, 0x32, 0x02, 0xe9, 0x04, 0x65, 0x65,
	},
};

static const struct {
	uint8_t p[48];
	uint8_t a[48];
	uint8_t b[48];
	uint8_t x[48];
	uint8_t y[48];
	uint8_t order[48];
} _EC_brainpoolP384t1 = {
	.p = {
		0x8c, 0xb9, 0x1e, 0x82, 0xa3, 0x38, 0x6d, 0x28, 0x0f, 0x5d,
		0x6f, 0x7e, 0x50, 0xe6, 0x41, 0xdf, 0x15, 0x2f, 0x71, 0x09,
		0xed, 0x54, 0x56, 0xb4, 0x12, 0xb1, 0xda, 0x19, 0x7f, 0xb7,
		0x11, 0x23, 0xac, 0xd3, 0xa7, 0x29, 0x90, 0x1d, 0x1a, 0x71,
		0x87, 0x47, 0x00, 0x13, 0x31, 0x07, 0xec, 0x53,
	},
	.a = {
		0x8c, 0xb9, 0x1e, 0x82, 0xa3, 0x38, 0x6d, 0x28, 0x0f, 0x5d,
		0x6f, 0x7e, 0x50, 0xe6, 0x41, 0xdf, 0x15, 0x2f, 0x71, 0x09,
		0xed, 0x54, 0x56, 0xb4, 0x12, 0xb1, 0xda, 0x19, 0x7f, 0xb7,
		0x11, 0x23, 0xac, 0xd3, 0xa7, 0x29, 0x90, 0x1d, 0x1a, 0x71,
		0x87, 0x47, 0x00, 0x13, 0x31, 0x07, 0xec, 0x50,
	},
	.b = {
		0x7f, 0x51, 0x9e, 0xad, 0xa7, 0xbd, 0xa8, 0x1b, 0xd8, 0x26,
		0xdb, 0xa6, 0x47, 0x91, 0x0f, 0x8c, 0x4b, 0x93, 0x46, 0xed,
		0x8c, 0xcd, 0xc6, 0x4e, 0x4b, 0x1a, 0xbd, 0x11, 0x75, 0x6d,
		0xce, 0x1d, 0x20, 0x74, 0xaa, 0x26, 0x3b, 0x88, 0x80, 0x5c,
		0xed, 0x70, 0x35, 0x5a, 0x33, 0xb4, 0x71, 0xee,
	},
	.x = {
		0x18, 0xde, 0x98, 0xb0, 0x2d, 0xb9, 0xa3, 0x06, 0xf2, 0xaf,
		0xcd, 0x72, 0x35, 0xf7, 0x2a, 0x81, 0x9b, 0x80, 0xab, 0x12,
		0xeb, 0xd6, 0x53, 0x17, 0x24, 0x76, 0xfe, 0xcd, 0x46, 0x2a,
		0xab, 0xff, 0xc4, 0xff, 0x19, 0x1b, 0x94, 0x6a, 0x5f, 0x54,
		0xd8, 0xd0, 0xaa, 0x2f, 0x41, 0x88, 0x08, 0xcc,
	},
	.y = {
		0x25, 0xab, 0x05, 0x69, 0x62, 0xd3, 0x06, 0x51, 0xa1, 0x14,
		0xaf, 0xd2, 0x75, 0x5a, 0xd3, 0x36, 0x74, 0x7f, 0x93, 0x47,
		0x5b, 0x7a, 0x1f, 0xca, 0x3b, 0x88, 0xf2, 0xb6, 0xa2, 0x08,
		0xcc, 0xfe, 0x46, 0x94, 0x08, 0x58, 0x4d, 0xc2, 0xb2, 0x91,
		0x26, 0x75, 0xbf, 0x5b, 0x9e, 0x58, 0x29, 0x28,
	},
	.order = {
		0x8c, 0xb9, 0x1e, 0x82, 0xa3, 0x38, 0x6d, 0x28, 0x0f, 0x5d,
		0x6f, 0x7e, 0x50, 0xe6, 0x41, 0xdf, 0x15, 0x2f, 0x71, 0x09,
		0xed, 0x54, 0x56, 0xb3, 0x1f, 0x16, 0x6e, 0x6c, 0xac, 0x04,
		0x25, 0xa7, 0xcf, 0x3a, 0xb6, 0xaf, 0x6b, 0x7f, 0xc3, 0x10,
		0x3b, 0x88, 0x32, 0x02, 0xe9, 0x04, 0x65, 0x65,
	},
};

static const struct {
	uint8_t p[64];
	uint8_t a[64];
	uint8_t b[64];
	uint8_t x[64];
	uint8_t y[64];
	uint8_t order[64];
} _EC_brainpoolP512r1 = {
	.p = {
		0xaa, 0xdd, 0x9d, 0xb8, 0xdb, 0xe9, 0xc4, 0x8b, 0x3f, 0xd4,
		0xe6, 0xae, 0x33, 0xc9, 0xfc, 0x07, 0xcb, 0x30, 0x8d, 0xb3,
		0xb3, 0xc9, 0xd2, 0x0e, 0xd6, 0x63, 0x9c, 0xca, 0x70, 0x33,
		0x08, 0x71, 0x7d, 0x4d, 0x9b, 0x00, 0x9b, 0xc6, 0x68, 0x42,
		0xae, 0xcd, 0xa1, 0x2a, 0xe6, 0xa3, 0x80, 0xe6, 0x28, 0x81,
		0xff, 0x2f, 0x2d, 0x82, 0xc6, 0x85, 0x28, 0xaa, 0x60, 0x56,
		0x58, 0x3a, 0x48, 0xf3,
	},
	.a = {
		0x78, 0x30, 0xa3, 0x31, 0x8b, 0x60, 0x3b, 0x89, 0xe2, 0x32,
		0x71, 0x45, 0xac, 0x23, 0x4c, 0xc5, 0x94, 0xcb, 0xdd, 0x8d,
		0x3d, 0xf9, 0x16, 0x10, 0xa8, 0x34, 0x41, 0xca, 0xea, 0x98,
		0x63, 0xbc, 0x2d, 0xed, 0x5d, 0x5a, 0xa8, 0x25, 0x3a, 0xa1,
		0x0a, 0x2e, 0xf1, 0xc9, 0x8b, 0x9a, 0xc8, 0xb5, 0x7f, 0x11,
		0x17, 0xa7, 0x2b, 0xf2, 0xc7, 0xb9, 0xe7, 0xc1, 0xac, 0x4d,
		0x77, 0xfc, 0x94, 0xca,
	},
	.b = {
		0x3d, 0xf9, 0x16, 0x10, 0xa8, 0x34, 0x41, 0xca, 0xea, 0x98,
		0x63, 0xbc, 0x2d, 0xed, 0x5d, 0x5a, 0xa8, 0x25, 0x3a, 0xa1,
		0x0a, 0x2e, 0xf1, 0xc9, 0x8b, 0x9a, 0xc8, 0xb5, 0x7f, 0x11,
		0x17, 0xa7, 0x2b, 0xf2, 0xc7, 0xb9, 0xe7, 0xc1, 0xac, 0x4d,
		0x77, 0xfc, 0x94, 0xca, 0xdc, 0x08, 0x3e, 0x67, 0x98, 0x40,
		0x50, 0xb7, 0x5e, 0xba, 0xe5, 0xdd, 0x28, 0x09, 0xbd, 0x63,
		0x80, 0x16, 0xf7, 0x23,
	},
	.x = {
		0x81, 0xae, 0xe4, 0xbd, 0xd8, 0x2e, 0xd9, 0x64, 0x5a, 0x21,
		0x32, 0x2e, 0x9c, 0x4c, 0x6a, 0x93, 0x85, 0xed, 0x9f, 0x70,
		0xb5, 0xd9, 0x16, 0xc1, 0xb4, 0x3b, 0x62, 0xee, 0xf4, 0xd0,
		0x09, 0x8e, 0xff, 0x3b, 0x1f, 0x78, 0xe2, 0xd0, 0xd4, 0x8d,
		0x50, 0xd1, 0x68, 0x7b, 0x93, 0xb9, 0x7d, 0x5f, 0x7c, 0x6d,
		0x50, 0x47, 0x40, 0x6a, 0x5e, 0x68, 0x8b, 0x35, 0x22, 0x09,
		0xbc, 0xb9, 0xf8, 0x22,
	},
	.y = {
		0x7d, 0xde, 0x38, 0x5d, 0x56, 0x63, 0x32, 0xec, 0xc0, 0xea,
		0xbf, 0xa9, 0xcf, 0x78, 0x22, 0xfd, 0xf2, 0x09, 0xf7, 0x00,
		0x24, 0xa5, 0x7b, 0x1a, 0xa0, 0x00, 0xc5, 0x5b, 0x88, 0x1f,
		0x81, 0x11, 0xb2, 0xdc, 0xde, 0x49, 0x4a, 0x5f, 0x48, 0x5e,
		0x5b, 0xca, 0x4b, 0xd8, 0x8a, 0x27, 0x63, 0xae, 0xd1, 0xca,
		0x2b, 0x2f, 0xa8, 0xf0, 0x54, 0x06, 0x78, 0xcd, 0x1e, 0x0f,
		0x3a, 0xd8, 0x08, 0x92,
	},
	.order = {
		0xaa, 0xdd, 0x9d, 0xb8, 0xdb, 0xe9, 0xc4, 0x8b, 0x3f, 0xd4,
		0xe6, 0xae, 0x33, 0xc9, 0xfc, 0x07, 0xcb, 0x30, 0x8d, 0xb3,
		0xb3, 0xc9, 0xd2, 0x0e, 0xd6, 0x63, 0x9c, 0xca, 0x70, 0x33,
		0x08, 0x70, 0x55, 0x3e, 0x5c, 0x41, 0x4c, 0xa9, 0x26, 0x19,
		0x41, 0x86, 0x61, 0x19, 0x7f, 0xac, 0x10, 0x47, 0x1d, 0xb1,
		0xd3, 0x81, 0x08, 0x5d, 0xda, 0xdd, 0xb5, 0x87, 0x96, 0x82,
		0x9c, 0xa9, 0x00, 0x69,
	},
};

static const struct {
	uint8_t p[64];
	uint8_t a[64];
	uint8_t b[64];
	uint8_t x[64];
	uint8_t y[64];
	uint8_t order[64];
} _EC_brainpoolP512t1 = {
	.p = {
		0xaa, 0xdd, 0x9d, 0xb8, 0xdb, 0xe9, 0xc4, 0x8b, 0x3f, 0xd4,
		0xe6, 0xae, 0x33, 0xc9, 0xfc, 0x07, 0xcb, 0x30, 0x8d, 0xb3,
		0xb3, 0xc9, 0xd2, 0x0e, 0xd6, 0x63, 0x9c, 0xca, 0x70, 0x33,
		0x08, 0x71, 0x7d, 0x4d, 0x9b, 0x00, 0x9b, 0xc6, 0x68, 0x42,
		0xae, 0xcd, 0xa1, 0x2a, 0xe6, 0xa3, 0x80, 0xe6, 0x28, 0x81,
		0xff, 0x2f, 0x2d, 0x82, 0xc6, 0x85, 0x28, 0xaa, 0x60, 0x56,
		0x58, 0x3a, 0x48, 0xf3,
	},
	.a = {
		0xaa, 0xdd, 0x9d, 0xb8, 0xdb, 0xe9, 0xc4, 0x8b, 0x3f, 0xd4,
		0xe6, 0xae, 0x33, 0xc9, 0xfc, 0x07, 0xcb, 0x30, 0x8d, 0xb3,
		0xb3, 0xc9, 0xd2, 0x0e, 0xd6, 0x63, 0x9c, 0xca, 0x70, 0x33,
		0x08, 0x71, 0x7d, 0x4d, 0x9b, 0x00, 0x9b, 0xc6, 0x68, 0x42,
		0xae, 0xcd, 0xa1, 0x2a, 0xe6, 0xa3, 0x80, 0xe6, 0x28, 0x81,
		0xff, 0x2f, 0x2d, 0x82, 0xc6, 0x85, 0x28, 0xaa, 0x60, 0x56,
		0x58, 0x3a, 0x48, 0xf0,
	},
	.b = {
		0x7c, 0xbb, 0xbc, 0xf9, 0x44, 0x1c, 0xfa, 0xb7, 0x6e, 0x18,
		0x90, 0xe4, 0x68, 0x84, 0xea, 0xe3, 0x21, 0xf7, 0x0c, 0x0b,
		0xcb, 0x49, 0x81, 0x52, 0x78, 0x97, 0x50, 0x4b, 0xec, 0x3e,
		0x36, 0xa6, 0x2b, 0xcd, 0xfa, 0x23, 0x04, 0x97, 0x65, 0x40,
		0xf6, 0x45, 0x00, 0x85, 0xf2, 0xda, 0xe1, 0x45, 0xc2, 0x25,
		0x53, 0xb4, 0x65, 0x76, 0x36, 0x89, 0x18, 0x0e, 0xa2, 0x57,
		0x18, 0x67, 0x42, 0x3e,
	},
	.x = {
		0x64, 0x0e, 0xce, 0x5c, 0x12, 0x78, 0x87, 0x17, 0xb9, 0xc1,
		0xba, 0x06, 0xcb, 0xc2, 0xa6, 0xfe, 0xba, 0x85, 0x84, 0x24,
		0x58, 0xc5, 0x6d, 0xde, 0x9d, 0xb1, 0x75, 0x8d, 0x39, 0xc0,
		0x31, 0x3d, 0x82, 0xba, 0x51, 0x73, 0x5c, 0xdb, 0x3e, 0xa4,
		0x99, 0xaa, 0x77, 0xa7, 0xd6, 0x94, 0x3a, 0x64, 0xf7, 0xa3,
		0xf2, 0x5f, 0xe2, 0x6f, 0x06, 0xb5, 0x1b, 0xaa, 0x26, 0x96,
		0xfa, 0x90, 0x35, 0xda,
	},
	.y = {
		0x5b, 0x53, 0x4b, 0xd5, 0x95, 0xf5, 0xaf, 0x0f, 0xa2, 0xc8,
		0x92, 0x37, 0x6c, 0x84, 0xac, 0xe1, 0xbb, 0x4e, 0x30, 0x19,
		0xb7, 0x16, 0x34, 0xc0, 0x11, 0x31, 0x15, 0x9c, 0xae, 0x03,
		0xce, 0xe9, 0xd9, 0x93, 0x21, 0x84, 0xbe, 0xef, 0x21, 0x6b,
		0xd7, 0x1d, 0xf2, 0xda, 0xdf, 0x86, 0xa6, 0x27, 0x30, 0x6e,
		0xcf, 0xf9, 0x6d, 0xbb, 0x8b, 0xac, 0xe1, 0x98, 0xb6, 0x1e,
		0x00, 0xf8, 0xb3, 0x32,
	},
	.order = {
		0xaa, 0xdd, 0x9d, 0xb8, 0xdb, 0xe9, 0xc4, 0x8b, 0x3f, 0xd4,
		0xe6, 0xae, 0x33, 0xc9, 0xfc, 0x07, 0xcb, 0x30, 0x8d, 0xb3,
		0xb3, 0xc9, 0xd2, 0x0e, 0xd6, 0x63, 0x9c, 0xca, 0x70, 0x33,
		0x08, 0x70, 0x55, 0x3e, 0x5c, 0x41, 0x4c, 0xa9, 0x26, 0x19,
		0x41, 0x86, 0x61, 0x19, 0x7f, 0xac, 0x10, 0x47, 0x1d, 0xb1,
		0xd3, 0x81, 0x08, 0x5d, 0xda, 0xdd, 0xb5, 0x87, 0x96, 0x82,
		0x9c, 0xa9, 0x00, 0x69,
	},
};

static const struct {
	uint8_t p[32];
	uint8_t a[32];
	uint8_t b[32];
	uint8_t x[32];
	uint8_t y[32];
	uint8_t order[32];
} _EC_FRP256v1 = {
	.p = {
		0xf1, 0xfd, 0x17, 0x8c, 0x0b, 0x3a, 0xd5, 0x8f, 0x10, 0x12,
		0x6d, 0xe8, 0xce, 0x42, 0x43, 0x5b, 0x39, 0x61, 0xad, 0xbc,
		0xab, 0xc8, 0xca, 0x6d, 0xe8, 0xfc, 0xf3, 0x53, 0xd8, 0x6e,
		0x9c, 0x03,
	},
	.a = {
		0xf1, 0xfd, 0x17, 0x8c, 0x0b, 0x3a, 0xd5, 0x8f, 0x10, 0x12,
		0x6d, 0xe8, 0xce, 0x42, 0x43, 0x5b, 0x39, 0x61, 0xad, 0xbc,
		0xab, 0xc8, 0xca, 0x6d, 0xe8, 0xfc, 0xf3, 0x53, 0xd8, 0x6e,
		0x9c, 0x00,
	},
	.b = {
		0xee, 0x35, 0x3f, 0xca, 0x54, 0x28, 0xa9, 0x30, 0x0d, 0x4a,
		0xba, 0x75, 0x4a, 0x44, 0xc0, 0x0f, 0xdf, 0xec, 0x0c, 0x9a,
		0xe4, 0xb1, 0xa1, 0x80, 0x30, 0x75, 0xed, 0x96, 0x7b, 0x7b,
		0xb7, 0x3f,
	},
	.x = {
		0xb6, 0xb3, 0xd4, 0xc3, 0x56, 0xc1, 0x39, 0xeb, 0x31, 0x18,
		0x3d, 0x47, 0x49, 0xd4, 0x23, 0x95, 0x8c, 0x27, 0xd2, 0xdc,
		0xaf, 0x98, 0xb7, 0x01, 0x64, 0xc9, 0x7a, 0x2d, 0xd9, 0x8f,
		0x5c, 0xff,
	},
	.y = {
		0x61, 0x42, 0xe0, 0xf7, 0xc8, 0xb2, 0x04, 0x91, 0x1f, 0x92,
		0x71, 0xf0, 0xf3, 0xec, 0xef, 0x8c, 0x27, 0x01, 0xc3, 0x07,
		0xe8, 0xe4, 0xc9, 0xe1, 0x83, 0x11, 0x5a, 0x15, 0x54, 0x06,
		0x2c, 0xfb,
	},
	.order = {
		0xf1, 0xfd, 0x17, 0x8c, 0x0b, 0x3a, 0xd5, 0x8f, 0x10, 0x12,
		0x6d, 0xe8, 0xce, 0x42, 0x43, 0x5b, 0x53, 0xdc, 0x67, 0xe1,
		0x40, 0xd2, 0xbf, 0x94, 0x1f, 0xfd, 0xd4, 0x59, 0xc6, 0xd6,
		0x55, 0xe1,
	},
};

static const struct ec_curve {
	const char *comment;
	int nid;
	int seed_len;
	int param_len;
	unsigned int cofactor;
	const uint8_t *seed;
	const uint8_t *p;
	const uint8_t *a;
	const uint8_t *b;
	const uint8_t *x;
	const uint8_t *y;
	const uint8_t *order;
} ec_curve_list[] = {
	/* secg curves */
	{
		.comment = "SECG curve secp224k1",
		.nid = NID_secp224k1,
		.param_len = sizeof(_EC_SECG_PRIME_224K1.p),
		.p = _EC_SECG_PRIME_224K1.p,
		.a = _EC_SECG_PRIME_224K1.a,
		.b = _EC_SECG_PRIME_224K1.b,
		.x = _EC_SECG_PRIME_224K1.x,
		.y = _EC_SECG_PRIME_224K1.y,
		.order = _EC_SECG_PRIME_224K1.order,
		.cofactor = 1,
	},
	{
		.comment = "NIST/SECG curve secp224r1",
		.nid = NID_secp224r1,
		.seed_len = sizeof(_EC_NIST_PRIME_224.seed),
		.param_len = sizeof(_EC_NIST_PRIME_224.p),
		.seed = _EC_NIST_PRIME_224.seed,
		.p = _EC_NIST_PRIME_224.p,
		.a = _EC_NIST_PRIME_224.a,
		.b = _EC_NIST_PRIME_224.b,
		.x = _EC_NIST_PRIME_224.x,
		.y = _EC_NIST_PRIME_224.y,
		.order = _EC_NIST_PRIME_224.order,
		.cofactor = 1,
	},
	{
		.comment = "SECG curve secp256k1",
		.nid = NID_secp256k1,
		.param_len = sizeof(_EC_SECG_PRIME_256K1.p),
		.p = _EC_SECG_PRIME_256K1.p,
		.a = _EC_SECG_PRIME_256K1.a,
		.b = _EC_SECG_PRIME_256K1.b,
		.x = _EC_SECG_PRIME_256K1.x,
		.y = _EC_SECG_PRIME_256K1.y,
		.order = _EC_SECG_PRIME_256K1.order,
		.cofactor = 1,
	},
	{
		/* Everyone except OpenSSL calls this secp256r1 or P-256. */
		.comment = "X9.62/SECG curve prime256v1",
		.nid = NID_X9_62_prime256v1,
		.seed_len = sizeof(_EC_NIST_PRIME_256.seed),
		.param_len = sizeof(_EC_NIST_PRIME_256.p),
		.seed = _EC_NIST_PRIME_256.seed,
		.p = _EC_NIST_PRIME_256.p,
		.a = _EC_NIST_PRIME_256.a,
		.b = _EC_NIST_PRIME_256.b,
		.x = _EC_NIST_PRIME_256.x,
		.y = _EC_NIST_PRIME_256.y,
		.order = _EC_NIST_PRIME_256.order,
		.cofactor = 1,
	},
	{
		.comment = "NIST/SECG curve secp384r1",
		.nid = NID_secp384r1,
		.seed_len = sizeof(_EC_NIST_PRIME_384.seed),
		.param_len = sizeof(_EC_NIST_PRIME_384.p),
		.seed = _EC_NIST_PRIME_384.seed,
		.p = _EC_NIST_PRIME_384.p,
		.a = _EC_NIST_PRIME_384.a,
		.b = _EC_NIST_PRIME_384.b,
		.x = _EC_NIST_PRIME_384.x,
		.y = _EC_NIST_PRIME_384.y,
		.order = _EC_NIST_PRIME_384.order,
		.cofactor = 1,
	},
	{
		.comment = "NIST/SECG curve secp521r1",
		.nid = NID_secp521r1,
		.seed_len = sizeof(_EC_NIST_PRIME_521.seed),
		.param_len = sizeof(_EC_NIST_PRIME_521.p),
		.seed = _EC_NIST_PRIME_521.seed,
		.p = _EC_NIST_PRIME_521.p,
		.a = _EC_NIST_PRIME_521.a,
		.b = _EC_NIST_PRIME_521.b,
		.x = _EC_NIST_PRIME_521.x,
		.y = _EC_NIST_PRIME_521.y,
		.order = _EC_NIST_PRIME_521.order,
		.cofactor = 1,
	},
	/* RFC 5639 curves */
	{
		.comment = "RFC 5639 curve brainpoolP224r1",
		.nid = NID_brainpoolP224r1,
		.param_len = sizeof(_EC_brainpoolP224r1.p),
		.p = _EC_brainpoolP224r1.p,
		.a = _EC_brainpoolP224r1.a,
		.b = _EC_brainpoolP224r1.b,
		.x = _EC_brainpoolP224r1.x,
		.y = _EC_brainpoolP224r1.y,
		.order = _EC_brainpoolP224r1.order,
		.cofactor = 1,
	},
	{
		.comment = "RFC 5639 curve brainpoolP224t1",
		.nid = NID_brainpoolP224t1,
		.param_len = sizeof(_EC_brainpoolP224t1.p),
		.p = _EC_brainpoolP224t1.p,
		.a = _EC_brainpoolP224t1.a,
		.b = _EC_brainpoolP224t1.b,
		.x = _EC_brainpoolP224t1.x,
		.y = _EC_brainpoolP224t1.y,
		.order = _EC_brainpoolP224t1.order,
		.cofactor = 1,
	},
	{
		.comment = "RFC 5639 curve brainpoolP256r1",
		.nid = NID_brainpoolP256r1,
		.param_len = sizeof(_EC_brainpoolP256r1.p),
		.p = _EC_brainpoolP256r1.p,
		.a = _EC_brainpoolP256r1.a,
		.b = _EC_brainpoolP256r1.b,
		.x = _EC_brainpoolP256r1.x,
		.y = _EC_brainpoolP256r1.y,
		.order = _EC_brainpoolP256r1.order,
		.cofactor = 1,
	},
	{
		.comment = "RFC 5639 curve brainpoolP256t1",
		.nid = NID_brainpoolP256t1,
		.param_len = sizeof(_EC_brainpoolP256t1.p),
		.p = _EC_brainpoolP256t1.p,
		.a = _EC_brainpoolP256t1.a,
		.b = _EC_brainpoolP256t1.b,
		.x = _EC_brainpoolP256t1.x,
		.y = _EC_brainpoolP256t1.y,
		.order = _EC_brainpoolP256t1.order,
		.cofactor = 1,
	},
	{
		.comment = "RFC 5639 curve brainpoolP320r1",
		.nid = NID_brainpoolP320r1,
		.param_len = sizeof(_EC_brainpoolP320r1.p),
		.p = _EC_brainpoolP320r1.p,
		.a = _EC_brainpoolP320r1.a,
		.b = _EC_brainpoolP320r1.b,
		.x = _EC_brainpoolP320r1.x,
		.y = _EC_brainpoolP320r1.y,
		.order = _EC_brainpoolP320r1.order,
		.cofactor = 1,
	},
	{
		.comment = "RFC 5639 curve brainpoolP320t1",
		.nid = NID_brainpoolP320t1,
		.param_len = sizeof(_EC_brainpoolP320t1.p),
		.p = _EC_brainpoolP320t1.p,
		.a = _EC_brainpoolP320t1.a,
		.b = _EC_brainpoolP320t1.b,
		.x = _EC_brainpoolP320t1.x,
		.y = _EC_brainpoolP320t1.y,
		.order = _EC_brainpoolP320t1.order,
		.cofactor = 1,
	},
	{
		.comment = "RFC 5639 curve brainpoolP384r1",
		.nid = NID_brainpoolP384r1,
		.param_len = sizeof(_EC_brainpoolP384r1.p),
		.p = _EC_brainpoolP384r1.p,
		.a = _EC_brainpoolP384r1.a,
		.b = _EC_brainpoolP384r1.b,
		.x = _EC_brainpoolP384r1.x,
		.y = _EC_brainpoolP384r1.y,
		.order = _EC_brainpoolP384r1.order,
		.cofactor = 1,
	},
	{
		.comment = "RFC 5639 curve brainpoolP384t1",
		.nid = NID_brainpoolP384t1,
		.param_len = sizeof(_EC_brainpoolP384t1.p),
		.p = _EC_brainpoolP384t1.p,
		.a = _EC_brainpoolP384t1.a,
		.b = _EC_brainpoolP384t1.b,
		.x = _EC_brainpoolP384t1.x,
		.y = _EC_brainpoolP384t1.y,
		.order = _EC_brainpoolP384t1.order,
		.cofactor = 1,
	},
	{
		.comment = "RFC 5639 curve brainpoolP512r1",
		.nid = NID_brainpoolP512r1,
		.param_len = sizeof(_EC_brainpoolP512r1.p),
		.p = _EC_brainpoolP512r1.p,
		.a = _EC_brainpoolP512r1.a,
		.b = _EC_brainpoolP512r1.b,
		.x = _EC_brainpoolP512r1.x,
		.y = _EC_brainpoolP512r1.y,
		.order = _EC_brainpoolP512r1.order,
		.cofactor = 1,
	},
	{
		.comment = "RFC 5639 curve brainpoolP512t1",
		.nid = NID_brainpoolP512t1,
		.param_len = sizeof(_EC_brainpoolP512t1.p),
		.p = _EC_brainpoolP512t1.p,
		.a = _EC_brainpoolP512t1.a,
		.b = _EC_brainpoolP512t1.b,
		.x = _EC_brainpoolP512t1.x,
		.y = _EC_brainpoolP512t1.y,
		.order = _EC_brainpoolP512t1.order,
		.cofactor = 1,
	},
	/* ANSSI */
	{
		.comment = "ANSSI curve FRP256v1",
		.nid = NID_FRP256v1,
		.param_len = sizeof(_EC_FRP256v1.p),
		.p = _EC_FRP256v1.p,
		.a = _EC_FRP256v1.a,
		.b = _EC_FRP256v1.b,
		.x = _EC_FRP256v1.x,
		.y = _EC_FRP256v1.y,
		.order = _EC_FRP256v1.order,
		.cofactor = 1,
	},
};

#define EC_CURVE_LIST_LENGTH (sizeof(ec_curve_list) / sizeof(ec_curve_list[0]))

static EC_GROUP *
ec_group_new_from_data(const struct ec_curve *curve)
{
	EC_GROUP *group = NULL, *ret = NULL;
	EC_POINT *generator = NULL;
	BN_CTX *ctx = NULL;
	BIGNUM *p, *a, *b, *x, *y, *order, *cofactor;

	if ((ctx = BN_CTX_new()) == NULL) {
		ECerror(ERR_R_MALLOC_FAILURE);
		goto err;
	}
	BN_CTX_start(ctx);

	if ((p = BN_CTX_get(ctx)) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if ((a = BN_CTX_get(ctx)) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if ((b = BN_CTX_get(ctx)) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if ((x = BN_CTX_get(ctx)) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if ((y = BN_CTX_get(ctx)) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if ((order = BN_CTX_get(ctx)) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if ((cofactor = BN_CTX_get(ctx)) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}

	if (BN_bin2bn(curve->p, curve->param_len, p) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if (BN_bin2bn(curve->a, curve->param_len, a) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if (BN_bin2bn(curve->b, curve->param_len, b) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if ((group = EC_GROUP_new_curve_GFp(p, a, b, ctx)) == NULL) {
		ECerror(ERR_R_EC_LIB);
		goto err;
	}
	EC_GROUP_set_curve_name(group, curve->nid);

	if ((generator = EC_POINT_new(group)) == NULL) {
		ECerror(ERR_R_EC_LIB);
		goto err;
	}
	if (BN_bin2bn(curve->x, curve->param_len, x) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if (BN_bin2bn(curve->y, curve->param_len, y) == NULL) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if (!EC_POINT_set_affine_coordinates(group, generator, x, y, ctx)) {
		ECerror(ERR_R_EC_LIB);
		goto err;
	}
	if (BN_bin2bn(curve->order, curve->param_len, order) == NULL) {
		ECerror(ERR_R_EC_LIB);
		goto err;
	}
	if (!BN_set_word(cofactor, curve->cofactor)) {
		ECerror(ERR_R_BN_LIB);
		goto err;
	}
	if (!EC_GROUP_set_generator(group, generator, order, cofactor)) {
		ECerror(ERR_R_EC_LIB);
		goto err;
	}

	if (curve->seed != NULL) {
		if (!EC_GROUP_set_seed(group, curve->seed, curve->seed_len)) {
			ECerror(ERR_R_EC_LIB);
			goto err;
		}
	}

	ret = group;
	group = NULL;

 err:
	EC_GROUP_free(group);
	EC_POINT_free(generator);
	BN_CTX_end(ctx);
	BN_CTX_free(ctx);

	return ret;
}

EC_GROUP *
EC_GROUP_new_by_curve_name(int nid)
{
	size_t i;

	if (nid <= 0)
		return NULL;

	for (i = 0; i < EC_CURVE_LIST_LENGTH; i++) {
		if (ec_curve_list[i].nid == nid)
			return ec_group_new_from_data(&ec_curve_list[i]);
	}

	ECerror(EC_R_UNKNOWN_GROUP);
	return NULL;
}
LCRYPTO_ALIAS(EC_GROUP_new_by_curve_name);

static void
ec_curve_free(struct ec_curve *curve)
{
	if (curve == NULL)
		return;

	/* PERM UGLY CASTS */
	free((uint8_t *)curve->seed);
	free((uint8_t *)curve->p);
	free((uint8_t *)curve->a);
	free((uint8_t *)curve->b);
	free((uint8_t *)curve->x);
	free((uint8_t *)curve->y);
	free((uint8_t *)curve->order);

	free(curve);
}

static int
ec_curve_encode_parameter(const BIGNUM *bn, int param_len,
    const uint8_t **out_param)
{
	uint8_t *buf = NULL;
	int ret = 0;

	if (out_param == NULL || *out_param != NULL)
		goto err;

	if ((buf = calloc(1, param_len)) == NULL)
		goto err;
	if (BN_bn2binpad(bn, buf, param_len) != param_len)
		goto err;

	*out_param = buf;
	buf = NULL;

	ret = 1;

 err:
	free(buf);

	return ret;
}

static struct ec_curve *
ec_curve_from_group(const EC_GROUP *group)
{
	struct ec_curve *curve = NULL;
	BN_CTX *ctx;
	BIGNUM *p, *a, *b, *x, *y;
	const EC_POINT *generator = NULL;
	const BIGNUM *order, *cofactor;
	size_t seed_len;

	if ((ctx = BN_CTX_new()) == NULL)
		goto err;
	BN_CTX_start(ctx);

	if ((p = BN_CTX_get(ctx)) == NULL)
		goto err;
	if ((a = BN_CTX_get(ctx)) == NULL)
		goto err;
	if ((b = BN_CTX_get(ctx)) == NULL)
		goto err;
	if ((x = BN_CTX_get(ctx)) == NULL)
		goto err;
	if ((y = BN_CTX_get(ctx)) == NULL)
		goto err;

	if (!EC_GROUP_get_curve(group, p, a, b, ctx))
		goto err;
	if ((generator = EC_GROUP_get0_generator(group)) == NULL)
		goto err;
	if (!EC_POINT_get_affine_coordinates(group, generator, x, y, ctx))
		goto err;
	if ((order = EC_GROUP_get0_order(group)) == NULL)
		goto err;

	if ((curve = calloc(1, sizeof(*curve))) == NULL)
		goto err;

	curve->param_len = BN_num_bytes(p);
	if (BN_num_bytes(order) > curve->param_len)
		curve->param_len = BN_num_bytes(order);

	if (!ec_curve_encode_parameter(p, curve->param_len, &curve->p))
		goto err;
	if (!ec_curve_encode_parameter(a, curve->param_len, &curve->a))
		goto err;
	if (!ec_curve_encode_parameter(b, curve->param_len, &curve->b))
		goto err;
	if (!ec_curve_encode_parameter(x, curve->param_len, &curve->x))
		goto err;
	if (!ec_curve_encode_parameter(y, curve->param_len, &curve->y))
		goto err;
	if (!ec_curve_encode_parameter(order, curve->param_len, &curve->order))
		goto err;

	if ((cofactor = EC_GROUP_get0_cofactor(group)) != NULL) {
		BN_ULONG cofactor_word;

		if ((cofactor_word = BN_get_word(cofactor)) == BN_MASK2)
			goto err;
		if (cofactor_word > INT_MAX)
			goto err;

		curve->cofactor = cofactor_word;
	}

	if ((seed_len = EC_GROUP_get_seed_len(group)) > 0) {
		uint8_t *seed;

		if (seed_len > INT_MAX)
			goto err;
		if ((seed = calloc(1, seed_len)) == NULL)
			goto err;
		memcpy(seed, EC_GROUP_get0_seed(group), seed_len);

		curve->seed = seed;
		curve->seed_len = seed_len;
	}

	BN_CTX_end(ctx);
	BN_CTX_free(ctx);

	return curve;

 err:
	BN_CTX_end(ctx);
	BN_CTX_free(ctx);

	ec_curve_free(curve);

	return NULL;
}

static int
ec_curve_cmp(const struct ec_curve *a, const struct ec_curve *b)
{
	int cmp;

	/* Treat nid as optional. The OID isn't part of EC parameters. */
	if (a->nid != NID_undef && b->nid != NID_undef) {
		if (a->nid < b->nid)
			return -1;
		if (a->nid > b->nid)
			return 1;
	}

	if (a->cofactor < b->cofactor)
		return -1;
	if (a->cofactor > b->cofactor)
		return 1;
	if (a->param_len < b->param_len)
		return -1;
	if (a->param_len > b->param_len)
		return 1;

	if ((cmp = memcmp(a->p, b->p, a->param_len)) != 0)
		return cmp;
	if ((cmp = memcmp(a->a, b->a, a->param_len)) != 0)
		return cmp;
	if ((cmp = memcmp(a->b, b->b, a->param_len)) != 0)
		return cmp;
	if ((cmp = memcmp(a->x, b->x, a->param_len)) != 0)
		return cmp;
	if ((cmp = memcmp(a->y, b->y, a->param_len)) != 0)
		return cmp;
	if ((cmp = memcmp(a->order, b->order, a->param_len)) != 0)
		return cmp;

	/* Seed is optional, not used for computation. Must match if present. */
	if (a->seed_len != 0 && b->seed_len != 0) {
		if (a->seed_len < b->seed_len)
			return -1;
		if (a->seed_len > b->seed_len)
			return 1;
		if (a->seed != NULL && b->seed != NULL) {
			if ((cmp = memcmp(a->seed, b->seed, a->seed_len)) != 0)
				return cmp;
		}
	}

	return 0;
}

static int
ec_group_nid_from_curve(const struct ec_curve *curve)
{
	size_t i;

	for (i = 0; i < EC_CURVE_LIST_LENGTH; i++) {
		if (ec_curve_cmp(curve, &ec_curve_list[i]) == 0)
			return ec_curve_list[i].nid;
	}

	return NID_undef;
}

int
ec_group_is_builtin_curve(const EC_GROUP *group, int *out_nid)
{
	struct ec_curve *curve;
	int ret = 0;
	int nid;

	*out_nid = NID_undef;

	if ((curve = ec_curve_from_group(group)) == NULL)
		goto err;
	if ((nid = ec_group_nid_from_curve(curve)) == NID_undef)
		goto err;

	*out_nid = nid;

	ret = 1;

 err:
	ec_curve_free(curve);

	return ret;
}

size_t
EC_get_builtin_curves(EC_builtin_curve *curves, size_t nitems)
{
	size_t i;

	if (curves == NULL || nitems == 0)
		return EC_CURVE_LIST_LENGTH;

	if (nitems > EC_CURVE_LIST_LENGTH)
		nitems = EC_CURVE_LIST_LENGTH;

	for (i = 0; i < nitems; i++) {
		curves[i].nid = ec_curve_list[i].nid;
		curves[i].comment = ec_curve_list[i].comment;
	}

	return EC_CURVE_LIST_LENGTH;
}
LCRYPTO_ALIAS(EC_get_builtin_curves);

static const struct {
	const char *name;
	int nid;
} nist_curves[] = {
	{ "B-163", NID_sect163r2 },
	{ "B-233", NID_sect233r1 },
	{ "B-283", NID_sect283r1 },
	{ "B-409", NID_sect409r1 },
	{ "B-571", NID_sect571r1 },
	{ "K-163", NID_sect163k1 },
	{ "K-233", NID_sect233k1 },
	{ "K-283", NID_sect283k1 },
	{ "K-409", NID_sect409k1 },
	{ "K-571", NID_sect571k1 },
	{ "P-192", NID_X9_62_prime192v1 },
	{ "P-224", NID_secp224r1 },
	{ "P-256", NID_X9_62_prime256v1 },
	{ "P-384", NID_secp384r1 },
	{ "P-521", NID_secp521r1 }
};

const char *
EC_curve_nid2nist(int nid)
{
	size_t i;

	for (i = 0; i < sizeof(nist_curves) / sizeof(nist_curves[0]); i++) {
		if (nist_curves[i].nid == nid)
			return nist_curves[i].name;
	}

	return NULL;
}
LCRYPTO_ALIAS(EC_curve_nid2nist);

int
EC_curve_nist2nid(const char *name)
{
	size_t i;

	for (i = 0; i < sizeof(nist_curves) / sizeof(nist_curves[0]); i++) {
		if (strcmp(nist_curves[i].name, name) == 0)
			return nist_curves[i].nid;
	}

	return NID_undef;
}
LCRYPTO_ALIAS(EC_curve_nist2nid);
