untrusted comment: verify with openbsd-77-base.pub
RWSbCCUoGpcxVR8WgV1MJ5OP5aSmXq2ei2uh6C3KTKoLtbHiCtJ6UVjwQ+K+WvzQZcSncFMgJKlkFQ75fOT9fGwYzsSp7duUagk=

OpenBSD 7.7 errata 005, June 17, 2025:

In acme-client(1), handle as yet unobserved "processing" state when
fetching an issued certificate by retrying instead of giving up.

Apply by doing:
    signify -Vep /etc/signify/openbsd-77-base.pub -x 005_acme.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install new acme-client:
    cd /usr/src/usr.sbin/acme-client
    make obj
    make
    make install

Index: usr.sbin/acme-client/netproc.c
===================================================================
RCS file: /cvs/src/usr.sbin/acme-client/netproc.c,v
diff -u -p -r1.37 netproc.c
--- usr.sbin/acme-client/netproc.c	10 Oct 2024 09:39:35 -0000	1.37
+++ usr.sbin/acme-client/netproc.c	3 Jun 2025 14:39:54 -0000
@@ -673,7 +673,7 @@ netproc(int kfd, int afd, int Cfd, int c
     int revocate, struct authority_c *authority,
     const char *const *alts, size_t altsz)
 {
-	int		 rc = 0;
+	int		 rc = 0, retries = 0;
 	size_t		 i;
 	char		*cert = NULL, *thumb = NULL, *error = NULL;
 	struct conn	 c;
@@ -863,6 +863,9 @@ netproc(int kfd, int afd, int Cfd, int c
 			if (!docert(&c, order.finalize, cert))
 				goto out;
 			break;
+		case ORDER_PROCESSING:
+			/* we'll just retry */
+			break;
 		default:
 			warnx("unhandled status: %d", order.status);
 			goto out;
@@ -871,8 +874,19 @@ netproc(int kfd, int afd, int Cfd, int c
 			goto out;
 
 		dodbg("order.status %d", order.status);
-		if (order.status == ORDER_PENDING)
+		switch (order.status) {
+		case ORDER_PENDING:
+		case ORDER_PROCESSING:
+			if (retries++ > RETRY_MAX) {
+				warnx("too many retries");
+				goto out;
+			}
 			sleep(RETRY_DELAY);
+			break;
+		default:
+			retries = 0; /* state changed, we made progress */
+			break;
+		}
 	}
 
 	if (order.status != ORDER_VALID) {
