/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiling.presets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.graalvm.visualvm.core.ui.components.Spacer;
import org.graalvm.visualvm.lib.common.ProfilingSettings;
import org.graalvm.visualvm.profiling.presets.ProfilerPreset;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public abstract class SamplerMemoryPanel
extends JPanel {
    private JLabel refreshRateLabel;
    private JLabel refreshUnitsLabel;
    private JComboBox<Integer> refreshCombo;
    private boolean internalChange;

    public SamplerMemoryPanel() {
        this(false);
    }

    SamplerMemoryPanel(boolean mnemonics) {
        this.initComponents(mnemonics);
    }

    public ProfilingSettings getSettings() {
        return null;
    }

    public int getSamplingRate() {
        return (Integer)this.refreshCombo.getSelectedItem();
    }

    public int getRefreshRate() {
        return this.getSamplingRate();
    }

    public boolean settingsValid() {
        return true;
    }

    public void loadFromPreset(ProfilerPreset preset) {
        if (preset == null) {
            return;
        }
        this.internalChange = true;
        this.refreshCombo.setSelectedItem(preset.getSamplingRefreshRateS());
        this.internalChange = false;
    }

    public void saveToPreset(ProfilerPreset preset) {
        if (preset == null) {
            return;
        }
        preset.setSamplingRefreshRateS((Integer)this.refreshCombo.getSelectedItem());
    }

    public abstract void settingsChanged();

    private void syncUI() {
        if (this.internalChange) {
            return;
        }
        this.settingsChanged();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component c : this.getComponents()) {
            c.setEnabled(enabled);
        }
    }

    private void initComponents(boolean mnemonics) {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.refreshRateLabel = new JLabel();
        SamplerMemoryPanel.setText(this.refreshRateLabel, NbBundle.getMessage(SamplerMemoryPanel.class, (String)"LBL_Sampling_refresh"), mnemonics);
        this.refreshRateLabel.setToolTipText(NbBundle.getMessage(SamplerMemoryPanel.class, (String)"TOOLTIP_Sampling_refresh"));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(7, 10, 10, 5);
        this.add((Component)this.refreshRateLabel, constraints);
        Object[] refreshRates = new Integer[]{100, 200, 500, 1000, 2000, 5000, 10000};
        this.refreshCombo = new JComboBox(refreshRates){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.refreshRateLabel.setLabelFor(this.refreshCombo);
        this.refreshCombo.setToolTipText(NbBundle.getMessage(SamplerMemoryPanel.class, (String)"TOOLTIP_Sampling_refresh"));
        this.refreshCombo.setEditable(false);
        this.refreshCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SamplerMemoryPanel.this.syncUI();
            }
        });
        this.refreshCombo.setRenderer(new ComboRenderer(this.refreshCombo));
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(7, 0, 10, 5);
        this.add(this.refreshCombo, constraints);
        this.refreshUnitsLabel = new JLabel(NbBundle.getMessage(SamplerMemoryPanel.class, (String)"LBL_units_ms"));
        this.refreshUnitsLabel.setToolTipText(NbBundle.getMessage(SamplerMemoryPanel.class, (String)"TOOLTIP_Sampling_refresh"));
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(7, 0, 10, 5);
        this.add((Component)this.refreshUnitsLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 3;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(7, 0, 10, 0);
        this.add((Component)Spacer.create(), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)Spacer.create(), constraints);
    }

    private static void setText(JLabel l, String text, boolean mnemonics) {
        if (mnemonics) {
            Mnemonics.setLocalizedText((JLabel)l, (String)text);
        } else {
            l.setText(text.replace("&", ""));
        }
    }

    private static class ComboRenderer
    implements ListCellRenderer {
        private ListCellRenderer renderer;

        ComboRenderer(JComboBox combo) {
            this.renderer = combo.getRenderer();
            if (this.renderer instanceof JLabel) {
                ((JLabel)((Object)this.renderer)).setHorizontalAlignment(11);
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return this.renderer.getListCellRendererComponent(list, NumberFormat.getInstance().format(value), index, isSelected, cellHasFocus);
        }
    }
}

