/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOrRenameOperationImplementation;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FreeformProjectOperations
implements DeleteOperationImplementation,
CopyOperationImplementation,
MoveOrRenameOperationImplementation {
    private FreeformProject project;

    public FreeformProjectOperations(FreeformProject project) {
        this.project = project;
    }

    private static void addFile(FileObject projectDirectory, String fileName, List<FileObject> result) {
        FileObject file = projectDirectory.getFileObject(fileName);
        if (file != null) {
            result.add(file);
        }
    }

    public List<FileObject> getMetadataFiles() {
        FileObject projectDirectory = this.project.getProjectDirectory();
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        FreeformProjectOperations.addFile(projectDirectory, "nbproject", files);
        return files;
    }

    public List<FileObject> getDataFiles() {
        Element genldata = this.project.getPrimaryConfigurationData();
        Element foldersEl = XMLUtil.findElement((Element)genldata, (String)"folders", (String)"http://www.netbeans.org/ns/freeform-project/2");
        List folders = foldersEl != null ? XMLUtil.findSubElements((Element)foldersEl) : Collections.emptyList();
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (Element el : folders) {
            if (!"source-folder".equals(el.getLocalName()) || !"http://www.netbeans.org/ns/freeform-project/2".equals(el.getNamespaceURI())) continue;
            this.addFile(el, result);
        }
        FreeformProjectOperations.addFile(this.project.getProjectDirectory(), "build.xml", result);
        return result;
    }

    private void addFile(Element folder, List<FileObject> result) {
        Element location = XMLUtil.findElement((Element)folder, (String)"location", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (location == null) {
            return;
        }
        PropertyEvaluator evaluator = this.project.evaluator();
        String val = evaluator.evaluate(XMLUtil.findText((Node)location));
        if (val == null) {
            return;
        }
        File f = this.project.helper().resolveFile(val);
        if (f == null) {
            return;
        }
        FileObject fo = FileUtil.toFileObject((File)f);
        if (fo != null && FileUtil.isParentOf((FileObject)this.project.getProjectDirectory(), (FileObject)fo)) {
            result.add(fo);
        }
    }

    public void notifyDeleting() throws IOException {
    }

    public void notifyDeleted() throws IOException {
        this.project.helper().notifyDeleted();
    }

    public void notifyCopying() throws IOException {
    }

    public void notifyCopied(Project original, File originalPath, String nueName) throws IOException {
        if (original != null) {
            this.project.setName(nueName);
        }
    }

    public void notifyMoving() throws IOException {
    }

    public void notifyMoved(Project original, File originalPath, String nueName) throws IOException {
        if (original != null) {
            this.project.setName(nueName);
        } else {
            this.project.helper().notifyDeleted();
        }
    }

    public void notifyRenaming() throws IOException {
    }

    public void notifyRenamed(String nueName) throws IOException {
        this.project.setName(nueName);
    }
}

