/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.testing;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.spi.testing.PhpTestingProvider;
import org.netbeans.modules.php.spi.testing.PhpTestingProviders;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.Parameters;
import org.openide.util.lookup.Lookups;

public final class PhpTesting {
    private static final Logger LOGGER = Logger.getLogger(PhpTesting.class.getName());
    public static final String TESTING_PATH = "PHP/Testing";
    public static final String CUSTOMIZER_IDENT = "Testing";
    private static final Lookup.Result<PhpTestingProvider> TESTING_PROVIDERS = Lookups.forPath((String)"PHP/Testing").lookupResult(PhpTestingProvider.class);

    private PhpTesting() {
    }

    public static List<PhpTestingProvider> getTestingProviders() {
        return new ArrayList<PhpTestingProvider>(TESTING_PROVIDERS.allInstances());
    }

    public static boolean isTestingProviderEnabled(String providerIdentifier, PhpModule phpModule) {
        Parameters.notNull((CharSequence)"providerIdentifier", (Object)providerIdentifier);
        Parameters.notNull((CharSequence)"phpModule", (Object)phpModule);
        PhpTestingProviders testingProviders = (PhpTestingProviders)phpModule.getLookup().lookup(PhpTestingProviders.class);
        if (testingProviders == null) {
            LOGGER.log(Level.INFO, "Cannot find PhpTestingProviders instance in lookup of project {0}", phpModule.getClass().getName());
            return false;
        }
        for (PhpTestingProvider testingProvider : testingProviders.getEnabledTestingProviders()) {
            if (!providerIdentifier.equals(testingProvider.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    public static void addTestingProvidersListener(@NonNull LookupListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        TESTING_PROVIDERS.addLookupListener(listener);
    }

    public static void removeTestingProvidersListener(@NonNull LookupListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        TESTING_PROVIDERS.removeLookupListener(listener);
    }
}

