/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.aggregator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.params.aggregator.ArgumentAccessException;
import org.junit.jupiter.params.aggregator.ArgumentsAccessor;
import org.junit.jupiter.params.converter.DefaultArgumentConverter;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.INTERNAL, since="5.2")
public class DefaultArgumentsAccessor
implements ArgumentsAccessor {
    private final ParameterContext parameterContext;
    private final int invocationIndex;
    private final Object[] arguments;

    public DefaultArgumentsAccessor(ParameterContext parameterContext, int invocationIndex, Object ... arguments) {
        Preconditions.notNull((Object)parameterContext, (String)"ParameterContext must not be null");
        Preconditions.condition((invocationIndex >= 1 ? 1 : 0) != 0, () -> "invocation index must be >= 1");
        Preconditions.notNull((Object)arguments, (String)"Arguments array must not be null");
        this.parameterContext = parameterContext;
        this.invocationIndex = invocationIndex;
        this.arguments = arguments;
    }

    @Override
    public Object get(int index) {
        Preconditions.condition((index >= 0 && index < this.arguments.length ? 1 : 0) != 0, () -> String.format("index must be >= 0 and < %d", this.arguments.length));
        return this.arguments[index];
    }

    @Override
    public <T> T get(int index, Class<T> requiredType) {
        Preconditions.notNull(requiredType, (String)"requiredType must not be null");
        Object value = this.get(index);
        try {
            Object convertedValue = DefaultArgumentConverter.INSTANCE.convert(value, requiredType, this.parameterContext);
            return requiredType.cast(convertedValue);
        }
        catch (Exception ex) {
            String message = String.format("Argument at index [%d] with value [%s] and type [%s] could not be converted or cast to type [%s].", index, value, ClassUtils.nullSafeToString(value == null ? null : value.getClass()), requiredType.getName());
            throw new ArgumentAccessException(message, ex);
        }
    }

    @Override
    public Character getCharacter(int index) {
        return this.get(index, Character.class);
    }

    @Override
    public Boolean getBoolean(int index) {
        return this.get(index, Boolean.class);
    }

    @Override
    public Byte getByte(int index) {
        return this.get(index, Byte.class);
    }

    @Override
    public Short getShort(int index) {
        return this.get(index, Short.class);
    }

    @Override
    public Integer getInteger(int index) {
        return this.get(index, Integer.class);
    }

    @Override
    public Long getLong(int index) {
        return this.get(index, Long.class);
    }

    @Override
    public Float getFloat(int index) {
        return this.get(index, Float.class);
    }

    @Override
    public Double getDouble(int index) {
        return this.get(index, Double.class);
    }

    @Override
    public String getString(int index) {
        return this.get(index, String.class);
    }

    @Override
    public int size() {
        return this.arguments.length;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.arguments, this.arguments.length);
    }

    @Override
    public List<Object> toList() {
        return Collections.unmodifiableList(Arrays.asList(this.arguments));
    }

    @Override
    public int getInvocationIndex() {
        return this.invocationIndex;
    }
}

