/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client;

import java.net.Proxy;
import java.util.Objects;

public final class ProxyConfiguration {
    private final Proxy proxy;
    private final String username;
    private final char[] password;

    public ProxyConfiguration(Proxy proxy, String username, char[] password) {
        this.proxy = Objects.requireNonNull(proxy, "proxy");
        if (proxy.type() == Proxy.Type.DIRECT) {
            throw new IllegalArgumentException("'DIRECT' proxy is not supported");
        }
        this.username = username;
        this.password = password;
    }

    public ProxyConfiguration(Proxy proxy) {
        this(proxy, null, null);
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public String getUsername() {
        return this.username;
    }

    public char[] getPassword() {
        return this.password;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Proxy proxy = null;
        private String username = null;
        private char[] password = null;

        private Builder() {
        }

        public ProxyConfiguration build() {
            return new ProxyConfiguration(this.proxy, this.username, this.password);
        }

        public ProxyConfiguration build(Proxy proxy) {
            this.proxy(proxy);
            return this.build();
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(char[] password) {
            this.password = password;
            return this;
        }
    }
}

