/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seembedded.platform;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.java.j2seembedded.platform.ConnectionMethod;
import org.openide.WizardValidationException;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public final class RemotePlatformProbe {
    private static final String NB_PROP_PREFIX = "netbeans.";
    private static final String PLATFROM_PROP_PREFIX = "platform.";

    private RemotePlatformProbe() {
        throw new IllegalStateException();
    }

    public static File createBuildScript() {
        String resourcesPath = "org/netbeans/modules/java/j2seembedded/resources/validateconnection.xml";
        File buildScript = null;
        try {
            buildScript = FileUtil.normalizeFile((File)Files.createTempFile("antScript", ".xml", new FileAttribute[0]).toFile());
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        try (InputStream inputStream = RemotePlatformProbe.class.getClassLoader().getResourceAsStream("org/netbeans/modules/java/j2seembedded/resources/validateconnection.xml");
             FileOutputStream outputStream = new FileOutputStream(buildScript);){
            FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return buildScript;
    }

    @NonNull
    public static Properties verifyPlatform(@NonNull String jreLocation, @NullAllowed String execDecorator, @NonNull String workingDir, @NonNull ConnectionMethod connectionMethod, @NullAllowed File buildScript) throws WizardValidationException {
        String[] antTargets = null;
        Properties prop = new Properties();
        prop.setProperty("remote.host", connectionMethod.getHost());
        prop.setProperty("remote.port", String.valueOf(connectionMethod.getPort()));
        prop.setProperty("remote.username", connectionMethod.getAuthentification().getUserName());
        prop.setProperty("remote.platform.home", jreLocation);
        if (execDecorator != null) {
            prop.setProperty("remote.exec.decorator", execDecorator);
        }
        prop.setProperty("remote.working.dir", workingDir.length() > 0 ? workingDir : "/home/" + connectionMethod.getAuthentification().getUserName() + "/NetBeansProjects/");
        File probe = InstalledFileLocator.getDefault().locate("modules/ext/org-netbeans-modules-java-j2seembedded-probe.jar", "org.netbeans.modules.java.j2seembedded", false);
        if (probe == null) {
            throw new WizardValidationException(null, NbBundle.getMessage(RemotePlatformProbe.class, (String)"MSG_MissingProbe"), null);
        }
        prop.setProperty("probe.file", probe.getAbsolutePath());
        File platformProperties = null;
        ExecutorTask executorTask = null;
        int antResult = -1;
        try {
            Set<String> concealedProps;
            platformProperties = Files.createTempFile("platform", ".properties", new FileAttribute[0]).toFile();
            prop.setProperty("platform.properties.file", platformProperties.getAbsolutePath());
            if (connectionMethod.getAuthentification().getKind() == ConnectionMethod.Authentification.Kind.PASSWORD) {
                antTargets = new String[]{"connect-ssh-password"};
                prop.setProperty("remote.password", ((ConnectionMethod.Authentification.Password)connectionMethod.getAuthentification()).getPassword());
                concealedProps = Collections.singleton("remote.password");
            } else {
                antTargets = new String[]{"connect-ssh-keyfile"};
                prop.setProperty("keystore.file", ((ConnectionMethod.Authentification.Key)connectionMethod.getAuthentification()).getKeyStore().getAbsolutePath());
                prop.setProperty("keystore.passphrase", ((ConnectionMethod.Authentification.Key)connectionMethod.getAuthentification()).getPassPhrase());
                concealedProps = Collections.singleton("keystore.passphrase");
            }
            FileObject antScript = FileUtil.toFileObject((File)(buildScript != null && buildScript.exists() ? buildScript : RemotePlatformProbe.createBuildScript()));
            executorTask = ActionUtils.runTarget((FileObject)antScript, (String[])antTargets, (Properties)prop, concealedProps);
            antResult = executorTask.result();
            if (antResult != 0) {
                throw new WizardValidationException(null, NbBundle.getMessage(RemotePlatformProbe.class, (String)"LBL_ConnectionError"), null);
            }
            Properties props = new Properties();
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(platformProperties));){
                props.load(in);
            }
            Properties properties = props;
            return properties;
        }
        catch (IOException | IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            throw new WizardValidationException(null, ex.getMessage(), ex.getLocalizedMessage());
        }
        finally {
            if (antResult == 0 && executorTask != null) {
                executorTask.getInputOutput().closeInputOutput();
            }
            if (buildScript != null) {
                buildScript.delete();
            }
            if (platformProperties != null) {
                platformProperties.delete();
            }
        }
    }

    @NonNull
    public static Pair<Map<String, String>, Map<String, String>> getSystemProperties(@NonNull Properties p) {
        HashMap<String, String> sysProps = new HashMap<String, String>();
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<Object, Object> e : p.entrySet()) {
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            if (key.startsWith(NB_PROP_PREFIX)) {
                properties.put(String.format("%s%s", PLATFROM_PROP_PREFIX, key.substring(NB_PROP_PREFIX.length())), value);
                continue;
            }
            sysProps.put(key, value);
        }
        return Pair.of(properties, sysProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int uploadJRE(@NonNull String localJreLocation, @NonNull String remoteJreLocation, @NonNull ConnectionMethod connectionMethod, @NullAllowed File buildScript) {
        Set<String> concealedProps;
        String[] antTargets = null;
        Properties prop = new Properties();
        prop.setProperty("remote.host", connectionMethod.getHost());
        prop.setProperty("remote.port", String.valueOf(connectionMethod.getPort()));
        prop.setProperty("remote.username", connectionMethod.getAuthentification().getUserName());
        prop.setProperty("remote.jre.dir", remoteJreLocation);
        prop.setProperty("jre.dir", localJreLocation);
        ExecutorTask executorTask = null;
        if (connectionMethod.getAuthentification().getKind() == ConnectionMethod.Authentification.Kind.PASSWORD) {
            antTargets = new String[]{"upload-JRE-password"};
            prop.setProperty("remote.password", ((ConnectionMethod.Authentification.Password)connectionMethod.getAuthentification()).getPassword());
            concealedProps = Collections.singleton("remote.password");
        } else {
            antTargets = new String[]{"upload-JRE-keyfile"};
            prop.setProperty("keystore.file", ((ConnectionMethod.Authentification.Key)connectionMethod.getAuthentification()).getKeyStore().getAbsolutePath());
            prop.setProperty("keystore.passphrase", ((ConnectionMethod.Authentification.Key)connectionMethod.getAuthentification()).getPassPhrase());
            concealedProps = Collections.singleton("keystore.passphrase");
        }
        FileObject antScript = FileUtil.toFileObject((File)(buildScript != null ? buildScript : RemotePlatformProbe.createBuildScript()));
        try {
            executorTask = ActionUtils.runTarget((FileObject)antScript, (String[])antTargets, (Properties)prop, concealedProps);
        }
        catch (IOException | IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (executorTask != null) {
                executorTask.getInputOutput().closeInputOutput();
            }
        }
        return executorTask != null ? executorTask.result() : -1;
    }
}

