/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute.ui;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.codehaus.plexus.util.StringUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.TextValueCompleter;
import org.netbeans.modules.maven.api.ProjectProfileHandler;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.customizer.ActionMappings;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.runjar.PropertySplitter;
import org.netbeans.modules.maven.spi.grammar.GoalsProvider;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RunGoalsPanel
extends JPanel {
    private static final RequestProcessor RP = new RequestProcessor(RunGoalsPanel.class);
    private final List<NetbeansActionMapping> historyMappings;
    private int historyIndex = 0;
    private TextValueCompleter goalcompleter;
    private final TextValueCompleter profilecompleter;
    private NbMavenProjectImpl project;
    private JButton btnAddProps;
    private JButton btnNext;
    private JButton btnPrev;
    private JCheckBox cbDebug;
    private JCheckBox cbOffline;
    private JCheckBox cbRecursive;
    private JCheckBox cbRemember;
    private JCheckBox cbUpdateSnapshots;
    private JEditorPane epProperties;
    private JLabel jLabel2;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JLabel lblGoals;
    private JLabel lblProfiles;
    private JTextField txtGoals;
    private JTextField txtProfiles;
    private JTextField txtRemember;

    public RunGoalsPanel() {
        this.initComponents();
        this.cbRememberActionPerformed(null);
        this.historyMappings = new ArrayList<NetbeansActionMapping>();
        this.btnPrev.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/back.png", (boolean)false));
        this.btnNext.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/execute/forward.png", (boolean)false));
        this.goalcompleter = new TextValueCompleter(new ArrayList<String>(0), this.txtGoals, " ");
        this.goalcompleter.setLoading(true);
        RP.post(() -> {
            GoalsProvider provider = (GoalsProvider)Lookup.getDefault().lookup(GoalsProvider.class);
            if (provider != null) {
                Set<String> strs = provider.getAvailableGoals();
                try {
                    List phases = EmbedderFactory.getProjectEmbedder().getLifecyclePhases();
                    strs.addAll(phases);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                SwingUtilities.invokeLater(() -> this.goalcompleter.setValueList(strs, false));
            }
        });
        this.profilecompleter = new TextValueCompleter(new ArrayList<String>(0), this.txtProfiles, " ");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.txtGoals.requestFocus();
    }

    private void readProfiles(Project mavenProject) {
        this.profilecompleter.setLoading(true);
        RP.post(() -> {
            ProjectProfileHandler profileHandler = (ProjectProfileHandler)mavenProject.getLookup().lookup(ProjectProfileHandler.class);
            List<String> ret = profileHandler.getAllProfiles();
            SwingUtilities.invokeLater(() -> this.profilecompleter.setValueList(ret, false));
        });
    }

    private static String createSpaceSeparatedList(List<String> list) {
        StringBuilder b = new StringBuilder();
        for (String s : list) {
            if (b.length() > 0) {
                b.append(' ');
            }
            b.append(s);
        }
        return b.toString();
    }

    public void readMapping(NetbeansActionMapping mapp, NbMavenProjectImpl project, ActionToGoalMapping historyMappings) {
        this.historyMappings.clear();
        this.historyMappings.addAll(historyMappings.getActions());
        this.historyMappings.add(mapp);
        this.historyIndex = this.historyMappings.size();
        this.readProfiles(project);
        this.project = project;
        this.moveHistory(-1);
    }

    public void readConfig(RunConfig config) {
        Project prj = config.getProject();
        if (prj != null) {
            this.project = (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class);
        }
        this.historyMappings.clear();
        this.btnNext.setVisible(false);
        this.btnPrev.setVisible(false);
        this.txtGoals.setText(RunGoalsPanel.createSpaceSeparatedList(config.getGoals()));
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<? extends String, ? extends String> entry : config.getProperties().entrySet()) {
            if (buf.length() > 0) {
                buf.append('\n');
            }
            buf.append(entry.getKey()).append('=').append(entry.getValue());
        }
        this.epProperties.setText(ActionMappings.createPropertiesList(config.getProperties()));
        this.epProperties.setCaretPosition(0);
        this.txtProfiles.setText(RunGoalsPanel.createSpaceSeparatedList(config.getActivatedProfiles()));
        this.setUpdateSnapshots(config.isUpdateSnapshots());
        this.setOffline(config.isOffline() != null ? config.isOffline() : false);
        this.setRecursive(config.isRecursive());
        this.setShowDebug(config.isShowDebug());
        if (config.getProject() != null) {
            this.readProfiles(config.getProject());
        }
    }

    private void readMapping(NetbeansActionMapping mapp) {
        this.txtGoals.setText(RunGoalsPanel.createSpaceSeparatedList(mapp.getGoals()));
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> entry : mapp.getProperties().entrySet()) {
            if (buf.length() > 0) {
                buf.append('\n');
            }
            buf.append(entry.getKey()).append('=').append(entry.getValue());
        }
        this.epProperties.setText(buf.toString());
        this.epProperties.setCaretPosition(0);
        this.txtProfiles.setText(RunGoalsPanel.createSpaceSeparatedList(mapp.getActivatedProfiles()));
    }

    public void applyValues(NetbeansActionMapping mapp) {
        StringTokenizer tok = new StringTokenizer(this.txtGoals.getText().trim());
        ArrayList<String> lst = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            lst.add(tok.nextToken());
        }
        mapp.setGoals(!lst.isEmpty() ? lst : null);
        mapp.setProperties(ActionMappings.convertStringToActionProperties(this.epProperties.getText()));
        tok = new StringTokenizer(this.txtProfiles.getText().trim(), " ,");
        lst = new ArrayList();
        while (tok.hasMoreTokens()) {
            lst.add(tok.nextToken());
        }
        mapp.setActivatedProfiles(lst);
        mapp.setRecursive(this.cbRecursive.isSelected());
    }

    public void applyValues(BeanRunConfig rc) {
        StringTokenizer tok = new StringTokenizer(this.txtGoals.getText().trim());
        ArrayList<String> lst = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            lst.add(tok.nextToken());
        }
        rc.setGoals(!lst.isEmpty() ? lst : List.of("install"));
        tok = new StringTokenizer(this.txtProfiles.getText().trim());
        lst = new ArrayList();
        while (tok.hasMoreTokens()) {
            lst.add(tok.nextToken());
        }
        rc.setActivatedProfiles(lst);
        PropertySplitter split = new PropertySplitter(this.epProperties.getText());
        String token = split.nextPair();
        while (token != null) {
            String[] prp = StringUtils.split((String)token, (String)"=", (int)2);
            if (prp.length == 2) {
                rc.setProperty(prp[0], prp[1]);
            }
            token = split.nextPair();
        }
        rc.setRecursive(this.isRecursive());
        rc.setShowDebug(this.isShowDebug());
        rc.setUpdateSnapshots(this.isUpdateSnapshots());
        rc.setOffline(this.isOffline());
    }

    private void initComponents() {
        this.lblGoals = new JLabel();
        this.txtGoals = new JTextField();
        this.lblProfiles = new JLabel();
        this.txtProfiles = new JTextField();
        this.jLabel2 = new JLabel();
        this.cbRecursive = new JCheckBox();
        this.cbOffline = new JCheckBox();
        this.cbDebug = new JCheckBox();
        this.cbUpdateSnapshots = new JCheckBox();
        this.btnNext = new JButton();
        this.btnPrev = new JButton();
        this.cbRemember = new JCheckBox();
        this.txtRemember = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.btnAddProps = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.epProperties = new JEditorPane();
        this.lblGoals.setLabelFor(this.txtGoals);
        Mnemonics.setLocalizedText((JLabel)this.lblGoals, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Goals"));
        this.lblProfiles.setLabelFor(this.txtProfiles);
        Mnemonics.setLocalizedText((JLabel)this.lblProfiles, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Profiles"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Properties"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbRecursive, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Recursive"));
        this.cbRecursive.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbRecursive.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.cbOffline, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Offline"));
        this.cbOffline.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbOffline.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.cbDebug, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Debug"));
        this.cbDebug.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbDebug.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.cbUpdateSnapshots, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Update_Snapshots"));
        this.cbUpdateSnapshots.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbUpdateSnapshots.setMargin(new Insets(0, 0, 0, 0));
        this.btnNext.setToolTipText(NbBundle.getMessage(RunGoalsPanel.class, (String)"TIP_Next"));
        this.btnNext.setMargin(new Insets(2, 2, 2, 2));
        this.btnNext.addActionListener(this::btnNextActionPerformed);
        this.btnPrev.setToolTipText(NbBundle.getMessage(RunGoalsPanel.class, (String)"TIP_Prev"));
        this.btnPrev.setMargin(new Insets(2, 2, 2, 2));
        this.btnPrev.addActionListener(this::btnPrevActionPerformed);
        Mnemonics.setLocalizedText((AbstractButton)this.cbRemember, (String)NbBundle.getMessage(RunGoalsPanel.class, (String)"LBL_Remember"));
        this.cbRemember.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbRemember.setMargin(new Insets(0, 0, 0, 0));
        this.cbRemember.addActionListener(this::cbRememberActionPerformed);
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddProps, (String)"&Add >");
        this.btnAddProps.addActionListener(this::btnAddPropsActionPerformed);
        this.epProperties.setContentType("text/x-properties");
        this.jScrollPane2.setViewportView(this.epProperties);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbRecursive).addComponent(this.cbOffline)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbDebug).addComponent(this.cbUpdateSnapshots))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblGoals).addComponent(this.lblProfiles).addComponent(this.jLabel2)).addGap(13, 13, 13)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnAddProps).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtGoals).addComponent(this.txtProfiles).addComponent(this.jScrollPane2))).addGroup(layout.createSequentialGroup().addComponent(this.btnPrev).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnNext).addGap(52, 52, 52).addComponent(this.cbRemember).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtRemember, -1, 275, Short.MAX_VALUE)).addComponent(this.jSeparator1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblGoals).addComponent(this.txtGoals, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblProfiles).addComponent(this.txtProfiles, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnAddProps)).addComponent(this.jScrollPane2, -1, 110, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbRecursive).addComponent(this.cbUpdateSnapshots)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbOffline).addComponent(this.cbDebug)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnPrev).addComponent(this.btnNext).addComponent(this.cbRemember).addComponent(this.txtRemember, -2, -1, -2)).addContainerGap()));
    }

    private void btnNextActionPerformed(ActionEvent evt) {
        this.moveHistory(1);
    }

    private void moveHistory(int step) {
        this.historyIndex += step;
        this.readMapping(this.historyMappings.get(this.historyIndex));
        this.btnPrev.setEnabled(this.historyIndex != 0);
        this.btnNext.setEnabled(this.historyIndex != this.historyMappings.size() - 1);
    }

    private void btnPrevActionPerformed(ActionEvent evt) {
        this.moveHistory(-1);
    }

    private void btnAddPropsActionPerformed(ActionEvent evt) {
        ActionMappings.showAddPropertyPopupMenu(this.btnAddProps, this.epProperties, this.txtGoals, this.project);
    }

    private void cbRememberActionPerformed(ActionEvent evt) {
        this.txtRemember.setEnabled(this.cbRemember.isSelected());
    }

    public boolean isOffline() {
        return this.cbOffline.isSelected();
    }

    public boolean isShowDebug() {
        return this.cbDebug.isSelected();
    }

    public void setOffline(boolean b) {
        this.cbOffline.setSelected(b);
    }

    public void setShowDebug(boolean b) {
        this.cbDebug.setSelected(b);
    }

    public void setUpdateSnapshots(boolean b) {
        this.cbUpdateSnapshots.setSelected(b);
    }

    public void setRecursive(boolean b) {
        this.cbRecursive.setSelected(b);
    }

    public boolean isRecursive() {
        return this.cbRecursive.isSelected();
    }

    public boolean isUpdateSnapshots() {
        return this.cbUpdateSnapshots.isSelected();
    }

    public String isRememberedAs() {
        String txt;
        if (this.cbRemember.isSelected() && !(txt = this.txtRemember.getText().trim()).isEmpty()) {
            return txt;
        }
        return null;
    }
}

