/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.rest.wizard;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.client.rest.wizard.HtmlPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class HtmlPanelVisual
extends JPanel {
    static final String HTML = ".html";
    private static final String DEFAULT_HTML = "newHtml";
    private JTextField myCreatedFile;
    private JLabel myCreatedFileLbl;
    private JTextField myFolder;
    private JLabel myFolderLbl;
    private JTextField myName;
    private JLabel myNameLbl;
    private HtmlPanel myPanel;

    public HtmlPanelVisual(HtmlPanel panel) {
        this.myPanel = panel;
        this.initComponents();
        DocumentListener listener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                HtmlPanelVisual.this.updateFilePath();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                HtmlPanelVisual.this.updateFilePath();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                HtmlPanelVisual.this.updateFilePath();
            }
        };
        this.initDefaults();
        this.myName.getDocument().addDocumentListener(listener);
        this.myFolder.getDocument().addDocumentListener(listener);
        this.myCreatedFile.setText(this.getCreatedFilePath().getPath());
    }

    void store(WizardDescriptor descriptor) {
        descriptor.putProperty("html-file", (Object)this.getCreatedFilePath());
    }

    void read(WizardDescriptor descriptor) {
        Project project = Templates.getProject((WizardDescriptor)descriptor);
        FileObject projectDirectory = project.getProjectDirectory();
        FileObject documentBase = (FileObject)this.myPanel.getDescriptor().getProperty("document_base");
        if (documentBase != null) {
            this.myFolder.setText(FileUtil.getRelativePath((FileObject)projectDirectory, (FileObject)documentBase));
        } else {
            this.myFolder.setText("public_html");
        }
    }

    boolean valid() {
        this.myPanel.getDescriptor().putProperty("WizardPanel_errorMessage", null);
        File file = this.getCreatedFilePath();
        try {
            file.getCanonicalFile();
        }
        catch (IOException e) {
            this.myPanel.getDescriptor().putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(HtmlPanelVisual.class, (String)"ERR_InvalidPath"));
            return false;
        }
        if (file.exists()) {
            this.myPanel.getDescriptor().putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(HtmlPanelVisual.class, (String)"ERR_FileExists", (Object)file.getPath()));
            return false;
        }
        return true;
    }

    private void updateFilePath() {
        this.myCreatedFile.setText(this.getCreatedFilePath().getPath());
        this.myPanel.fireChangeEvent();
    }

    private File getCreatedFilePath() {
        Project project = Templates.getProject((WizardDescriptor)this.myPanel.getDescriptor());
        FileObject projectDirectory = project.getProjectDirectory();
        String folder = this.myFolder.getText();
        String file = this.myName.getText() + HTML;
        File path = FileUtil.toFile((FileObject)projectDirectory);
        if (folder != null && folder.length() > 0) {
            path = new File(path, folder);
        }
        return new File(path, file);
    }

    private void initDefaults() {
        String nameExt;
        Project project = Templates.getProject((WizardDescriptor)this.myPanel.getDescriptor());
        FileObject projectDirectory = project.getProjectDirectory();
        String name = DEFAULT_HTML;
        int i = 0;
        while (projectDirectory.getFileObject(nameExt = name + HTML) != null) {
            name = DEFAULT_HTML + i;
            ++i;
        }
        this.myName.setText(name);
    }

    private void initComponents() {
        this.myNameLbl = new JLabel();
        this.myName = new JTextField();
        this.myFolderLbl = new JLabel();
        this.myFolder = new JTextField();
        this.myCreatedFile = new JTextField();
        this.myCreatedFileLbl = new JLabel();
        this.setPreferredSize(new Dimension(489, 97));
        this.myNameLbl.setLabelFor(this.myName);
        Mnemonics.setLocalizedText((JLabel)this.myNameLbl, (String)NbBundle.getMessage(HtmlPanelVisual.class, (String)"LBL_HtmlFileName"));
        this.myFolderLbl.setLabelFor(this.myFolder);
        Mnemonics.setLocalizedText((JLabel)this.myFolderLbl, (String)NbBundle.getMessage(HtmlPanelVisual.class, (String)"LBL_Folder"));
        this.myCreatedFile.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.myCreatedFileLbl, (String)NbBundle.getMessage(HtmlPanelVisual.class, (String)"LBL_CreatedFile"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myNameLbl).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.myCreatedFileLbl, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.myFolderLbl, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.myCreatedFile, -1, 391, Short.MAX_VALUE).addComponent(this.myName).addComponent(this.myFolder)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.myNameLbl).addComponent(this.myName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.myFolderLbl).addComponent(this.myFolder, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.myCreatedFile, -2, -1, -2).addComponent(this.myCreatedFileLbl)).addContainerGap(14, Short.MAX_VALUE)));
        this.myNameLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HtmlPanelVisual.class, (String)"ACSN_FileName"));
        this.myNameLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HtmlPanelVisual.class, (String)"ACSD_FileName"));
        this.myName.getAccessibleContext().setAccessibleName(this.myNameLbl.getAccessibleContext().getAccessibleName());
        this.myName.getAccessibleContext().setAccessibleDescription(this.myNameLbl.getAccessibleContext().getAccessibleDescription());
        this.myFolderLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HtmlPanelVisual.class, (String)"ACSN_Folder"));
        this.myFolderLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HtmlPanelVisual.class, (String)"ACSD_Folder"));
        this.myCreatedFileLbl.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HtmlPanelVisual.class, (String)"ACSN_CreatedFile"));
        this.myCreatedFileLbl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HtmlPanelVisual.class, (String)"ACSD_CreatedFile"));
        this.getAccessibleContext().setAccessibleName(this.myFolderLbl.getAccessibleContext().getAccessibleName());
        this.getAccessibleContext().setAccessibleDescription(this.myFolderLbl.getAccessibleContext().getAccessibleDescription());
    }
}

