/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.embedding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.spi.embedding.JsEmbeddingProviderPlugin;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class JsEPPluginQuery {
    private static JsEPPluginQuery DEFAULT;
    private Lookup.Result<JsEmbeddingProviderPlugin> lookupResult;
    private Collection<? extends JsEmbeddingProviderPlugin> plugins;

    public static synchronized JsEPPluginQuery getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new JsEPPluginQuery();
        }
        return DEFAULT;
    }

    private JsEPPluginQuery() {
        Lookup lookup = MimeLookup.getLookup((String)"text/html");
        this.lookupResult = lookup.lookupResult(JsEmbeddingProviderPlugin.class);
        this.lookupResult.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                JsEPPluginQuery.this.refresh();
            }
        });
        this.refresh();
    }

    private void refresh() {
        Collection allInstances;
        this.plugins = allInstances = this.lookupResult.allInstances();
    }

    public Session createSession() {
        return new Session();
    }

    public class Session {
        private Collection<JsEmbeddingProviderPlugin> activePlugins = new ArrayList<JsEmbeddingProviderPlugin>();

        public void startProcessing(HtmlParserResult parserResult, Snapshot snapshot, TokenSequence<HTMLTokenId> ts, List<Embedding> embeddings) {
            for (JsEmbeddingProviderPlugin jsep : JsEPPluginQuery.this.plugins) {
                if (!jsep.startProcessing(parserResult, snapshot, ts, embeddings)) continue;
                this.activePlugins.add(jsep);
            }
        }

        public boolean processToken() {
            for (JsEmbeddingProviderPlugin jsep : this.activePlugins) {
                if (!jsep.processToken()) continue;
                return true;
            }
            return false;
        }

        public void endProcessing() {
            for (JsEmbeddingProviderPlugin jsep : this.activePlugins) {
                jsep.endProcessing();
            }
        }
    }
}

