/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.Collections;
import java.util.Set;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.html.editor.lib.api.elements.TreePath;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;

public class HtmlElementHandle
implements ElementHandle {
    private final FileObject fo;
    private final String name;
    private final String elementPath;
    private final int attributesHash;

    public HtmlElementHandle(OpenTag node, FileObject fo) {
        this.fo = fo;
        this.name = node.id().toString();
        this.elementPath = ElementUtils.encodeToString((TreePath)new TreePath((Element)node));
        this.attributesHash = this.computeAttributesHash(node);
    }

    private int computeAttributesHash(OpenTag node) {
        int hash = 11;
        for (Attribute a : node.attributes()) {
            hash = 37 * hash + a.name().hashCode();
            CharSequence value = a.value();
            hash = 37 * hash + (value != null ? value.hashCode() : 0);
        }
        return hash;
    }

    public FileObject getFileObject() {
        return this.fo;
    }

    public String getMimeType() {
        return "text/html";
    }

    public String getName() {
        return this.name;
    }

    public String getIn() {
        return null;
    }

    public ElementKind getKind() {
        return ElementKind.TAG;
    }

    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    public boolean signatureEquals(ElementHandle handle) {
        if (!(handle instanceof HtmlElementHandle)) {
            return false;
        }
        HtmlElementHandle htmlHandle = (HtmlElementHandle)handle;
        return htmlHandle.elementPath.equals(this.elementPath);
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + (this.elementPath != null ? this.elementPath.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HtmlElementHandle other = (HtmlElementHandle)obj;
        if (this.elementPath == null ? other.elementPath != null : !this.elementPath.equals(other.elementPath)) {
            return false;
        }
        return this.attributesHash == other.attributesHash;
    }

    public String toString() {
        return this.elementPath;
    }

    public OpenTag resolve(ParserResult result) {
        if (!(result instanceof HtmlParserResult)) {
            return null;
        }
        HtmlParserResult htmlParserResult = (HtmlParserResult)result;
        Node root = htmlParserResult.root();
        return ElementUtils.query((Node)root, (String)this.elementPath);
    }

    public OffsetRange getOffsetRange(ParserResult result) {
        OpenTag node = this.resolve(result);
        if (node == null) {
            return OffsetRange.NONE;
        }
        Snapshot snapshot = result.getSnapshot();
        int dfrom = snapshot.getOriginalOffset(node.from());
        int dto = snapshot.getOriginalOffset(node.semanticEnd());
        return dfrom != -1 && dto != -1 ? new OffsetRange(dfrom, dto) : OffsetRange.NONE;
    }
}

