/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.custom;

import java.awt.Color;
import java.util.Iterator;
import org.netbeans.modules.html.custom.conf.Attribute;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;

public class CustomAttributeCompletionItem
extends HtmlCompletionItem {
    private final Attribute attr;
    private final boolean autocompleteQuotes;

    public CustomAttributeCompletionItem(Attribute attr, int substituteOffset) {
        super(attr.getName(), substituteOffset);
        this.attr = attr;
        this.autocompleteQuotes = !"boolean".equals(attr.getType());
    }

    protected Color getAttributeColor() {
        return Color.green.darker();
    }

    protected String getSubstituteText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getItemText());
        if (this.autocompleteQuotes) {
            sb.append("=\"\"");
        }
        return sb.toString();
    }

    protected int getMoveBackLength() {
        return this.autocompleteQuotes ? 1 : 0;
    }

    public int getSortPriority() {
        return super.getSortPriority() - (this.attr.isRequired() ? 1 : 0) - (this.attr.getParent() != null ? 1 : 0);
    }

    protected String getLeftHtmlText() {
        StringBuilder sb = new StringBuilder();
        if (this.attr.isRequired()) {
            sb.append("<b>");
        }
        sb.append("<font color=#");
        sb.append(CustomAttributeCompletionItem.hexColorCode((Color)this.getAttributeColor()));
        sb.append(">");
        sb.append(this.getItemText());
        sb.append("</font>");
        if (this.attr.isRequired()) {
            sb.append("</b>");
        }
        return sb.toString();
    }

    public String getHelp() {
        String documentation;
        StringBuilder sb = new StringBuilder();
        sb.append("<h1>");
        sb.append(this.attr.getName());
        sb.append("</h1>");
        sb.append("<h2>Custom HTML attribute</h2>");
        String description = this.attr.getDescription();
        if (description != null) {
            sb.append("<p>");
            sb.append(description);
            sb.append("</p>");
        }
        if ((documentation = this.attr.getDocumentation()) != null) {
            sb.append("<p>");
            sb.append(documentation);
            sb.append("</p>");
        }
        if (description != null || documentation != null) {
            sb.append("<hr/>");
        }
        sb.append("<p><b>");
        sb.append(this.attr.isRequired() ? "Required" : "Optional");
        sb.append("</b></p>");
        sb.append("<p><b>Type: </b>");
        sb.append(this.attr.getType() != null ? this.attr.getType() : "undefined");
        sb.append("<p>");
        if (this.attr.getContexts().isEmpty()) {
            sb.append("<b>Allowed in all contexts.</b>");
        } else {
            sb.append("<b>Allowed in context(s): </b>");
            Iterator<String> i = this.attr.getContexts().iterator();
            while (i.hasNext()) {
                String ctx = i.next();
                sb.append(ctx);
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append("</p>");
        return sb.toString();
    }

    public boolean hasHelp() {
        return true;
    }
}

