/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.wsdl.parser;

import com.sun.xml.rpc.wsdl.document.Binding;
import com.sun.xml.rpc.wsdl.document.BindingFault;
import com.sun.xml.rpc.wsdl.document.BindingInput;
import com.sun.xml.rpc.wsdl.document.BindingOperation;
import com.sun.xml.rpc.wsdl.document.BindingOutput;
import com.sun.xml.rpc.wsdl.document.Definitions;
import com.sun.xml.rpc.wsdl.document.Documentation;
import com.sun.xml.rpc.wsdl.document.Fault;
import com.sun.xml.rpc.wsdl.document.Import;
import com.sun.xml.rpc.wsdl.document.Input;
import com.sun.xml.rpc.wsdl.document.Message;
import com.sun.xml.rpc.wsdl.document.MessagePart;
import com.sun.xml.rpc.wsdl.document.Operation;
import com.sun.xml.rpc.wsdl.document.Output;
import com.sun.xml.rpc.wsdl.document.Port;
import com.sun.xml.rpc.wsdl.document.PortType;
import com.sun.xml.rpc.wsdl.document.Service;
import com.sun.xml.rpc.wsdl.document.Types;
import com.sun.xml.rpc.wsdl.document.WSDLConstants;
import com.sun.xml.rpc.wsdl.document.WSDLDocument;
import com.sun.xml.rpc.wsdl.document.WSDLDocumentVisitor;
import com.sun.xml.rpc.wsdl.document.schema.SchemaKinds;
import com.sun.xml.rpc.wsdl.framework.Extension;
import com.sun.xml.rpc.wsdl.framework.Kind;
import com.sun.xml.rpc.wsdl.framework.WriterContext;
import com.sun.xml.rpc.wsdl.parser.ExtensionHandler;
import com.sun.xml.rpc.wsdl.parser.HTTPExtensionHandler;
import com.sun.xml.rpc.wsdl.parser.MIMEExtensionHandler;
import com.sun.xml.rpc.wsdl.parser.SOAPExtensionHandler;
import com.sun.xml.rpc.wsdl.parser.SchemaExtensionHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class WSDLWriter {
    private Map _extensionHandlers = new HashMap();
    private static Map _commonPrefixes = new HashMap();
    private static final String TARGET_NAMESPACE_PREFIX = "tns";
    private static final String NEW_NAMESPACE_PREFIX_BASE = "ns";

    public WSDLWriter() throws IOException {
        this.register(new SOAPExtensionHandler());
        this.register(new HTTPExtensionHandler());
        this.register(new MIMEExtensionHandler());
        this.register(new SchemaExtensionHandler());
    }

    public void register(ExtensionHandler h) {
        this._extensionHandlers.put(h.getNamespaceURI(), h);
        h.setExtensionHandlers(this._extensionHandlers);
    }

    public void unregister(ExtensionHandler h) {
        this._extensionHandlers.put(h.getNamespaceURI(), null);
        h.setExtensionHandlers(null);
    }

    public void unregister(String uri) {
        this._extensionHandlers.put(uri, null);
    }

    public void write(final WSDLDocument document, OutputStream os) throws IOException {
        final WriterContext context = new WriterContext(os);
        try {
            document.accept(new WSDLDocumentVisitor(){

                @Override
                public void preVisit(Definitions definitions) throws Exception {
                    context.push();
                    WSDLWriter.this.initializePrefixes(context, document);
                    context.writeStartTag(definitions.getElementName());
                    context.writeAttribute("name", definitions.getName());
                    context.writeAttribute("targetNamespace", definitions.getTargetNamespaceURI());
                    context.writeAllPendingNamespaceDeclarations();
                }

                @Override
                public void postVisit(Definitions definitions) throws Exception {
                    context.writeEndTag(definitions.getElementName());
                    context.pop();
                }

                @Override
                public void visit(Import i) throws Exception {
                    context.writeStartTag(i.getElementName());
                    context.writeAttribute("namespace", i.getNamespace());
                    context.writeAttribute("location", i.getLocation());
                    context.writeEndTag(i.getElementName());
                }

                @Override
                public void preVisit(Types types) throws Exception {
                    context.writeStartTag(types.getElementName());
                }

                @Override
                public void postVisit(Types types) throws Exception {
                    context.writeEndTag(types.getElementName());
                }

                @Override
                public void preVisit(Message message) throws Exception {
                    context.writeStartTag(message.getElementName());
                    context.writeAttribute("name", message.getName());
                }

                @Override
                public void postVisit(Message message) throws Exception {
                    context.writeEndTag(message.getElementName());
                }

                @Override
                public void visit(MessagePart part) throws Exception {
                    context.writeStartTag(part.getElementName());
                    context.writeAttribute("name", part.getName());
                    QName dname = part.getDescriptor();
                    Kind dkind = part.getDescriptorKind();
                    if (dname != null && dkind != null) {
                        if (dkind.equals(SchemaKinds.XSD_ELEMENT)) {
                            context.writeAttribute("element", dname);
                        } else if (dkind.equals(SchemaKinds.XSD_TYPE)) {
                            context.writeAttribute("type", dname);
                        }
                    }
                    context.writeEndTag(part.getElementName());
                }

                @Override
                public void preVisit(PortType portType) throws Exception {
                    context.writeStartTag(portType.getElementName());
                    context.writeAttribute("name", portType.getName());
                }

                @Override
                public void postVisit(PortType portType) throws Exception {
                    context.writeEndTag(portType.getElementName());
                }

                @Override
                public void preVisit(Operation operation) throws Exception {
                    context.writeStartTag(operation.getElementName());
                    context.writeAttribute("name", operation.getName());
                    if (operation.getParameterOrder() != null && operation.getParameterOrder().length() > 0) {
                        context.writeAttribute("parameterOrder", operation.getParameterOrder());
                    }
                }

                @Override
                public void postVisit(Operation operation) throws Exception {
                    context.writeEndTag(operation.getElementName());
                }

                @Override
                public void preVisit(Input input) throws Exception {
                    context.writeStartTag(input.getElementName());
                    context.writeAttribute("name", input.getName());
                    context.writeAttribute("message", input.getMessage());
                }

                @Override
                public void postVisit(Input input) throws Exception {
                    context.writeEndTag(input.getElementName());
                }

                @Override
                public void preVisit(Output output) throws Exception {
                    context.writeStartTag(output.getElementName());
                    context.writeAttribute("name", output.getName());
                    context.writeAttribute("message", output.getMessage());
                }

                @Override
                public void postVisit(Output output) throws Exception {
                    context.writeEndTag(output.getElementName());
                }

                @Override
                public void preVisit(Fault fault) throws Exception {
                    context.writeStartTag(fault.getElementName());
                    context.writeAttribute("name", fault.getName());
                    context.writeAttribute("message", fault.getMessage());
                }

                @Override
                public void postVisit(Fault fault) throws Exception {
                    context.writeEndTag(fault.getElementName());
                }

                @Override
                public void preVisit(Binding binding) throws Exception {
                    context.writeStartTag(binding.getElementName());
                    context.writeAttribute("name", binding.getName());
                    context.writeAttribute("type", binding.getPortType());
                }

                @Override
                public void postVisit(Binding binding) throws Exception {
                    context.writeEndTag(binding.getElementName());
                }

                @Override
                public void preVisit(BindingOperation operation) throws Exception {
                    context.writeStartTag(operation.getElementName());
                    context.writeAttribute("name", operation.getName());
                }

                @Override
                public void postVisit(BindingOperation operation) throws Exception {
                    context.writeEndTag(operation.getElementName());
                }

                @Override
                public void preVisit(BindingInput input) throws Exception {
                    context.writeStartTag(input.getElementName());
                    context.writeAttribute("name", input.getName());
                }

                @Override
                public void postVisit(BindingInput input) throws Exception {
                    context.writeEndTag(input.getElementName());
                }

                @Override
                public void preVisit(BindingOutput output) throws Exception {
                    context.writeStartTag(output.getElementName());
                    context.writeAttribute("name", output.getName());
                }

                @Override
                public void postVisit(BindingOutput output) throws Exception {
                    context.writeEndTag(output.getElementName());
                }

                @Override
                public void preVisit(BindingFault fault) throws Exception {
                    context.writeStartTag(fault.getElementName());
                    context.writeAttribute("name", fault.getName());
                }

                @Override
                public void postVisit(BindingFault fault) throws Exception {
                    context.writeEndTag(fault.getElementName());
                }

                @Override
                public void preVisit(Service service) throws Exception {
                    context.writeStartTag(service.getElementName());
                    context.writeAttribute("name", service.getName());
                }

                @Override
                public void postVisit(Service service) throws Exception {
                    context.writeEndTag(service.getElementName());
                }

                @Override
                public void preVisit(Port port) throws Exception {
                    context.writeStartTag(port.getElementName());
                    context.writeAttribute("name", port.getName());
                    context.writeAttribute("binding", port.getBinding());
                }

                @Override
                public void postVisit(Port port) throws Exception {
                    context.writeEndTag(port.getElementName());
                }

                @Override
                public void preVisit(Extension extension) throws Exception {
                    ExtensionHandler h = (ExtensionHandler)WSDLWriter.this._extensionHandlers.get(extension.getElementName().getNamespaceURI());
                    h.doHandleExtension(context, extension);
                }

                @Override
                public void postVisit(Extension extension) throws Exception {
                }

                @Override
                public void visit(Documentation documentation) throws Exception {
                    context.writeTag(WSDLConstants.QNAME_DOCUMENTATION, null);
                }
            });
            context.flush();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException();
        }
    }

    private void initializePrefixes(WriterContext context, WSDLDocument document) throws IOException {
        String tnsURI = document.getDefinitions().getTargetNamespaceURI();
        if (tnsURI != null) {
            context.setTargetNamespaceURI(tnsURI);
            context.declarePrefix(TARGET_NAMESPACE_PREFIX, tnsURI);
        }
        context.declarePrefix("", "http://schemas.xmlsoap.org/wsdl/");
        Set namespaces = document.collectAllNamespaces();
        for (String nsURI : namespaces) {
            if (context.getPrefixFor(nsURI) != null) continue;
            String prefix = (String)_commonPrefixes.get(nsURI);
            if (prefix == null) {
                prefix = context.findNewPrefix(NEW_NAMESPACE_PREFIX_BASE);
            }
            context.declarePrefix(prefix, nsURI);
        }
    }

    static {
        _commonPrefixes.put("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        _commonPrefixes.put("http://schemas.xmlsoap.org/wsdl/soap/", "soap");
        _commonPrefixes.put("http://schemas.xmlsoap.org/wsdl/http/", "http");
        _commonPrefixes.put("http://schemas.xmlsoap.org/wsdl/mime/", "mime");
        _commonPrefixes.put("http://www.w3.org/2001/XMLSchema", "xsd");
        _commonPrefixes.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
    }
}

