/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.dependency;

import java.util.Collections;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;

public final class ProjectOperationException
extends IllegalStateException {
    private final Project project;
    private final State state;
    private Set<FileObject> files;

    public ProjectOperationException(Project project, State state, String s) {
        this(project, state, s, Collections.emptySet());
    }

    public ProjectOperationException(Project project, State state, String s, Set<FileObject> files) {
        super(s);
        this.files = files;
        this.project = project;
        this.state = state;
    }

    public ProjectOperationException(Project project, State state, String message, Throwable cause) {
        super(message, cause);
        this.state = state;
        this.project = project;
        this.files = Collections.emptySet();
    }

    public Project getProject() {
        return this.project;
    }

    public State getState() {
        return this.state;
    }

    public Set<FileObject> getFiles() {
        return Collections.unmodifiableSet(this.files);
    }

    public static enum State {
        ERROR,
        UNINITIALIZED,
        BROKEN,
        OFFLINE,
        OK,
        OUT_OF_SYNC,
        UNSUPPORTED,
        CANCELLED;

    }
}

