untrusted comment: verify with openbsd-77-base.pub
RWSbCCUoGpcxVVh0EdsF8bGSXV+0eLghgHOhWS0JByLNKTN8gL15rmtMde5FrQ56E93qNGNyEXovD4vX9hJ96wz47AjwbH4OywE=

OpenBSD 7.7 errata 015, December 3, 2025:

Fix drm(4) to avoid spurious sleep errors leading to crashes.

Apply by doing:
    signify -Vep /etc/signify/openbsd-77-base.pub -x 015_drm.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/dev/pci/drm/drm_linux.c
===================================================================
RCS file: /cvs/src/sys/dev/pci/drm/drm_linux.c,v
diff -u -p -r1.122 drm_linux.c
--- sys/dev/pci/drm/drm_linux.c	10 Mar 2025 09:28:56 -0000	1.122
+++ sys/dev/pci/drm/drm_linux.c	25 Nov 2025 20:56:59 -0000
@@ -122,7 +122,7 @@ __set_current_state(int state)
 	SCHED_LOCK();
 	unsleep(p);
 	p->p_stat = SONPROC;
-	atomic_clearbits_int(&p->p_flag, P_INSCHED);
+	atomic_clearbits_int(&p->p_flag, P_INSCHED|P_SINTR);
 	SCHED_UNLOCK();
 }
 
