<?

$form_name = "file_import";

if (!$individual) $pageLoad="permShow()";
$page_name="import";

include("modules/common/function.inc.php");
include("modules/common/file_process.inc.php");


//can we view this page
$error = "Import Files";

bitset_compare(BITSET,INSERT_FILES,ADMIN,$error);

if (!session_is_registered("file_path")) session_register("file_path");

if ($_POST["file_path"]) $file_path = $_POST["file_path"];

//this takes care of processing as the user sets values for the inidividual files they've selected
if ($individual) {

	//display the files we're setting individually. 
	//the first is an array of file names.  The second is a name of ids assigned at the
	//first import.
	$indivArray = explode(";",$individual);

	//get rid of the empty last field
	array_pop($indivArray);

	//get rid of any files in the file_path array that are in this indiv array
	$file_path = array_values(array_diff($file_path,$indivArray));


	//if we haven't selected a file to edit, pick the first one
	if ($curFileId == null) {

		$curFileId = "0";

		//register our default session variables
		session_register("default_pic_convert");
		session_register("default_index_question");
		session_register("default_delete_files");
		session_register("default_category");

		//store our default values in the session
		$default_pic_convert 	= 	$pic_convert;
		$default_index_question 	= 	$index_question;
		$default_delete_files 	= 	$delete_files;
		$default_category 		= 	$cat_grouping;

		//create our field name suffix for this id
		$permSuffix = "_".$curFileId;

	}
	else {

		/*********************************************************************************
	
			This section handles data for the indiv file id we just submitted

		*********************************************************************************/

		//create our field name suffix for this id
		$permSuffix = "_".$curFileId;

		//register the session for this file.  We'll store all import options in here.
		$pic_session = "pic_convert".$permSuffix;
		$index_session = "index_question".$permSuffix;
		$delete_session = "delete_files".$permSuffix; 
		$category_session = "category".$permSuffix;

		if (!session_is_registered("$pic_session")) 		session_register("$pic_session");
		if (!session_is_registered("$index_session")) 	session_register("$index_session");
		if (!session_is_registered("$delete_session")) 	session_register("$delete_session");
		if (!session_is_registered("$category_session")) 	session_register("$category_session");

		//set the values from the form we just submitted
		$$pic_session = $pic_convert;
		$$index_session = $index_question;
		$$delete_session = $delete_files;
		$$category_session = $cat_grouping;


		//if we're switching to another file, get that file id
		if ($curFileAction) {

			$max = count($indivArray)-1;

			if ($curFileAction=="next") {
					if ($curFileId == $max) $curFileId="0";
					else $curFileId++;
			}
			elseif ($curFileAction=="back") {
					if ($curFileId == "0") $curFileId=$max;
					else $curFileId--;
			}

			$permSuffix = "_".$curFileId;

			//register the var names for the fileId we're switching to.
			$pic_session = "pic_convert".$permSuffix;
			$index_session = "index_question".$permSuffix;
			$delete_session = "delete_files".$permSuffix; 
			$category_session = "category".$permSuffix;

		}


		//set our question values for the current id, if they exist, otherwise default
		//values are used
		$pic_convert_value = $$pic_session;
		$index_question_value = $$index_session;
		$delete_files_value = $$delete_session;
		$view_object_value = $$category_session;

	}

	//set our default radio button and category values
	if (!$pic_convert_value) 	$pic_convert_value 		= 	$default_pic_convert;
	if (!$index_question_value) 	$index_question_value 	= 	$default_index_question;
	if (!$delete_files_value) 	$delete_files_value 	= 	$default_delete_files;
	if (!$view_object_value) 	$view_object_value 		= 	$default_category;


}
else {

	//set our default import option values.  Here we're not doing indiv imports
	$default_pic_convert 	= 	$pic_convert;
	$default_index_question 	= 	$index_question;
	$default_delete_files 	= 	$delete_files;
	$default_category 		= 	$cat_grouping;

}

//reset the page to the default settings
if (!$first_load) {

	for ($row=0;$row<20;$row++) {

		$suffix = "_".$row;

		$pic_session = "pic_convert".$suffix;
		$index_session = "index_question".$suffix;
		$delete_session = "delete_files".$suffix; 
		$category_session = "category".$suffix;

		$$pic_session = null;
		$$index_session = null;
		$$delete_session = null;
		$$category_session = null;

	}

	$pic_convert = null;
	$index_question = null;
	$delete_files = null;
	$cat_grouping = null;

}

if ($import_files) {

	//we're only worried about individual import, since file_path is an array, and can't
	//be passed from the url

	//call our import file if we're not doing a indiv selection, or if we are done and are done setting
	//the indiv options
	if (!$individual || ($individual && $individual_import)) include("modules/common/import_include.inc.php");
	
	//$individual = null;
	$individual_import = null;
	$import_files = null;

}


?>

<script language=javascript>

function delete_check() {
	
	if (!confirm("Are you sure you wish to remove this file?")) {
		return false;
	}

}


function colorChange(source) {

	var individual = document.file_import.individual.value;
	var working = document.getElementById(source).name;

	//num is the pos of the first char of the string
	//end of the pos of the last char of the string
	var num = individual.indexOf(working);
	var end = num + working.length + 1;  		//the +1 includes the semicolon
	var strEnd = individual.length;

	var imagesrc = "showimage"+source;

	//check to see if our string is already in the box.  If it is, remove it.
	if (num!="-1") {
		document.getElementById(source).style.color="blue";

		//split our string into two parts, minus the old thing we're yanking
		var temp1 = individual.substr(0,num);
		var temp2 = individual.substr(end,strEnd);
		document.file_import.individual.value = temp1 + temp2;
		
	}
	else {
		document.getElementById(source).style.color="green";
		document.file_import.individual.value = individual + working + ";";
	}

}

function changeFile(action,suffix) {

	document.getElementById("curFileAction").value = action;
	permissionSubmit();

	deleteName = "delete_files" + suffix;

	if (document.file_import.delete_files[0].checked == true) {
		document.getElementById(deleteName).value = "yes";
	}
	else {
		document.getElementById(deleteName).value = "";
	}

	document.file_import.submit();

}

function formSubmit(action) {

	permissionSubmit();

	if (action=="indiv_final") {
		document.getElementById("individual_import").value = "1";
	}
	
	document.getElementById("import_files").value="1";

	document.file_import.submit();
	
}


</script>

<?


function list_dir($dirname)
{
	static $result_array=array();
	$handle=opendir($dirname);
	while ($file = readdir($handle))
	{
		if($file=='.'||$file=='..')	{
			continue;
		}
		else	{
			if (!stristr($file,"~") && !is_dir($dirname."/".$file)) {
				$result_array[]=$dirname."/".$file;
			}
		}
	}
closedir($handle);
return $result_array;

}
function dir_array($dirname) {

	static $dir_array=array();
	$handle=opendir($dirname);
	while ($file = readdir($handle))
	{
		if($file=='.'||$file=='..')	{
			continue;
		}
		else	{
			if (!stristr($file,"~")) {
				if (is_dir($dirname."/".$file)) $dir_array[]=$dirname."/".$file;
			}
		}
	}
closedir($handle);
return $dir_array;

}

//change the form submit if we have individual files to process

if ($individual) $submitFunction = "formSubmit('indiv_final');";
else $submitFunction = "formSubmit('');";


$functionBar = "<a href=\"#\" onClick=\"".$submitFunction."\" class=functionBarLink>Import Files</a>&nbsp;&nbsp;&nbsp;&nbsp;";
