VERSION 5.00
Begin VB.Form frmPrivileges 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Privileges"
   ClientHeight    =   5415
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   5070
   Icon            =   "frmPrivileges.frx":0000
   LinkTopic       =   "Form1"
   MDIChild        =   -1  'True
   ScaleHeight     =   5415
   ScaleWidth      =   5070
   Begin VB.ListBox lstGroups 
      Height          =   960
      Left            =   1170
      Style           =   1  'Checkbox
      TabIndex        =   18
      ToolTipText     =   "Select individual users to grant privileges to"
      Top             =   3150
      Width           =   3825
   End
   Begin VB.PictureBox Picture1 
      BorderStyle     =   0  'None
      Height          =   540
      Left            =   1035
      ScaleHeight     =   540
      ScaleWidth      =   2655
      TabIndex        =   15
      Top             =   4860
      Width           =   2655
      Begin VB.OptionButton optAction 
         Alignment       =   1  'Right Justify
         Caption         =   "Revoke"
         Height          =   225
         Index           =   1
         Left            =   150
         TabIndex        =   17
         ToolTipText     =   "Select to Revoke the specified privileges"
         Top             =   315
         Width           =   1275
      End
      Begin VB.OptionButton optAction 
         Alignment       =   1  'Right Justify
         Caption         =   "Grant"
         Height          =   225
         Index           =   0
         Left            =   150
         TabIndex        =   16
         ToolTipText     =   "Select to Grant the specified privileges"
         Top             =   105
         Value           =   -1  'True
         Width           =   1275
      End
   End
   Begin VB.OptionButton optPrivilege 
      Alignment       =   1  'Right Justify
      Caption         =   "All"
      Height          =   225
      Index           =   0
      Left            =   1155
      TabIndex        =   4
      ToolTipText     =   "Specify ALL privileges"
      Top             =   4185
      Value           =   -1  'True
      Width           =   1500
   End
   Begin VB.OptionButton optPrivilege 
      Alignment       =   1  'Right Justify
      Caption         =   "Select"
      Height          =   225
      Index           =   1
      Left            =   1155
      TabIndex        =   6
      ToolTipText     =   "Specify SELECT privilege"
      Top             =   4395
      Width           =   1485
   End
   Begin VB.CheckBox chkAll 
      Caption         =   "All"
      Height          =   225
      Left            =   1155
      TabIndex        =   0
      ToolTipText     =   "Select to apply privileges to all classes"
      Top             =   105
      Width           =   1380
   End
   Begin VB.ListBox lstClass 
      Height          =   1410
      Left            =   1155
      Sorted          =   -1  'True
      Style           =   1  'Checkbox
      TabIndex        =   1
      ToolTipText     =   "Select individual classes to apply privileges to"
      Top             =   420
      Width           =   3825
   End
   Begin VB.CheckBox chkPublic 
      Caption         =   "Public"
      Height          =   225
      Left            =   1170
      TabIndex        =   2
      ToolTipText     =   "Select to grant privileges to all users"
      Top             =   1845
      Width           =   3060
   End
   Begin VB.CommandButton cmdApply 
      Caption         =   "&Apply Privileges"
      Height          =   330
      Left            =   3735
      TabIndex        =   10
      ToolTipText     =   "Apply the selected privileges to the selected classes"
      Top             =   5040
      Width           =   1275
   End
   Begin VB.OptionButton optPrivilege 
      Alignment       =   1  'Right Justify
      Caption         =   "Rule"
      Height          =   225
      Index           =   5
      Left            =   3465
      TabIndex        =   9
      ToolTipText     =   "Specify RULE privilege"
      Top             =   4635
      Width           =   1500
   End
   Begin VB.OptionButton optPrivilege 
      Alignment       =   1  'Right Justify
      Caption         =   "Delete"
      Height          =   225
      Index           =   4
      Left            =   3465
      TabIndex        =   7
      ToolTipText     =   "Specify DELETE privilege"
      Top             =   4410
      Width           =   1500
   End
   Begin VB.OptionButton optPrivilege 
      Alignment       =   1  'Right Justify
      Caption         =   "Update"
      Height          =   225
      Index           =   3
      Left            =   3465
      TabIndex        =   5
      ToolTipText     =   "Specify UPDATE privilege"
      Top             =   4185
      Width           =   1500
   End
   Begin VB.OptionButton optPrivilege 
      Alignment       =   1  'Right Justify
      Caption         =   "Insert"
      Height          =   225
      Index           =   2
      Left            =   1155
      TabIndex        =   8
      ToolTipText     =   "Specify INSERT privilege"
      Top             =   4605
      Width           =   1485
   End
   Begin VB.ListBox lstUsers 
      Height          =   960
      Left            =   1170
      Style           =   1  'Checkbox
      TabIndex        =   3
      ToolTipText     =   "Select individual users to grant privileges to"
      Top             =   2115
      Width           =   3825
   End
   Begin VB.Label Label1 
      Caption         =   "Group Names:"
      Height          =   225
      Index           =   4
      Left            =   90
      TabIndex        =   19
      Top             =   3150
      Width           =   1065
   End
   Begin VB.Label Label1 
      Caption         =   "Action:"
      Height          =   225
      Index           =   3
      Left            =   135
      TabIndex        =   14
      Top             =   4950
      Width           =   1065
   End
   Begin VB.Label Label1 
      Caption         =   "Privilege:"
      Height          =   225
      Index           =   2
      Left            =   105
      TabIndex        =   13
      Top             =   4185
      Width           =   1065
   End
   Begin VB.Label Label1 
      Caption         =   "User Names:"
      Height          =   225
      Index           =   1
      Left            =   135
      TabIndex        =   12
      Top             =   1845
      Width           =   1065
   End
   Begin VB.Label Label1 
      Caption         =   "Class Names:"
      Height          =   225
      Index           =   0
      Left            =   105
      TabIndex        =   11
      Top             =   105
      Width           =   1065
   End
End
Attribute VB_Name = "frmPrivileges"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' pgAdmin - PostgreSQL db Administration/Management for Win32
' Copyright (C) 1998 - 2000, Dave Page

' This program is free software; you can redistribute it and/or
' modify it under the terms of the GNU General Public License
' as published by the Free Software Foundation; either version 2
' of the License, or (at your option) any later version.

' This program is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.

' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Option Explicit
Dim Privilege As String

Private Sub chkAll_Click()
On Error GoTo Err_Handler
Dim X As Integer
  If chkAll.Value = 1 Then
    For X = 0 To lstClass.ListCount - 1
      lstClass.Selected(X) = True
    Next
    lstClass.Enabled = False
  Else
    lstClass.Enabled = True
  End If
  Gen_SQL
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmPrivileges, chkAll_Click"
End Sub

Private Sub chkPublic_Click()
On Error GoTo Err_Handler
Dim X As Integer
  If chkPublic.Value = 1 Then
    For X = 0 To lstUsers.ListCount - 1
      lstUsers.Selected(X) = True
    Next
    lstUsers.Enabled = False
    lstGroups.Enabled = False
  Else
    lstUsers.Enabled = True
    lstGroups.Enabled = True
  End If
  Gen_SQL
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmPrivileges, chkPublic_Click"
End Sub

Private Sub Gen_SQL()
On Error GoTo Err_Handler
Dim SecString As String
Dim ClassList As String
Dim X As Integer
  fMainForm.txtSQLPane.Text = ""
  If optAction(0).Value = True Then
    SecString = "GRANT " & Privilege & " ON "
  Else
    SecString = "REVOKE " & Privilege & " ON "
  End If
  For X = 0 To lstClass.ListCount - 1
    If lstClass.Selected(X) = True Then ClassList = ClassList & QUOTE & Mid(lstClass.List(X), 1, InStr(1, lstClass.List(X), vbTab) - 1) & QUOTE & ", "
  Next
  If ClassList <> "" Then
    ClassList = Mid(ClassList, 1, Len(ClassList) - 2)   'Remove last ", "
  End If
  If optAction(0).Value = True Then
    SecString = SecString & ClassList & " TO "
  Else
    SecString = SecString & ClassList & " FROM "
  End If
  If chkPublic.Value = 1 Then
    fMainForm.txtSQLPane.Text = SecString & "public"
  Else
    For X = 0 To lstUsers.ListCount - 1
      If lstUsers.Selected(X) = True Then
        fMainForm.txtSQLPane.Text = fMainForm.txtSQLPane.Text & SecString & QUOTE & lstUsers.List(X) & QUOTE & vbCrLf
      End If
    Next
    For X = 0 To lstGroups.ListCount - 1
      If lstGroups.Selected(X) = True Then
        fMainForm.txtSQLPane.Text = fMainForm.txtSQLPane.Text & SecString & "GROUP " & QUOTE & lstGroups.List(X) & QUOTE & vbCrLf
      End If
    Next
    If fMainForm.txtSQLPane.Text = "" Then fMainForm.txtSQLPane.Text = SecString
  End If
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmPrivileges, cmdApply_Click"
End Sub

Private Sub cmdApply_Click()
On Error GoTo Err_Handler
Dim SecString As String
Dim ClassList As String
Dim X As Integer
Dim Flag As Boolean
Dim rsClass As New Recordset
  Flag = False
  If Privilege = "" Then
    MsgBox "You must select a privilege to apply!", vbExclamation, "Error"
    Exit Sub
  End If
  If optAction(0).Value = True Then
    SecString = "GRANT " & Privilege & " ON "
  Else
    SecString = "REVOKE " & Privilege & " ON "
  End If
  For X = 0 To lstClass.ListCount - 1
    If lstClass.Selected(X) = True Then ClassList = ClassList & QUOTE & Mid(lstClass.List(X), 1, InStr(1, lstClass.List(X), vbTab) - 1) & QUOTE & ", "
  Next
  If ClassList = "" Then
    MsgBox "You must select at least one class to apply security to!", vbExclamation, "Error"
    Exit Sub
  End If
  ClassList = Mid(ClassList, 1, Len(ClassList) - 2)   'Remove last ", "
  If optAction(0).Value = True Then
    SecString = SecString & ClassList & " TO "
  Else
    SecString = SecString & ClassList & " FROM "
  End If
  StartMsg "Applying Security..."
  If chkPublic.Value = 1 Then
    LogMsg "Executing: " & SecString & "public"
    gConnection.Execute SecString & "public"
    LogQuery SecString & "public"
  Else
    gConnection.BeginTrans
    For X = 0 To lstUsers.ListCount - 1
      If lstUsers.Selected(X) = True Then
        LogMsg "Executing: " & SecString & QUOTE & lstUsers.List(X) & QUOTE
        gConnection.Execute SecString & QUOTE & lstUsers.List(X) & QUOTE
        LogQuery SecString & QUOTE & lstUsers.List(X) & QUOTE
        Flag = True
      End If
    Next
    For X = 0 To lstGroups.ListCount - 1
      If lstGroups.Selected(X) = True Then
        LogMsg "Executing: " & SecString & "GROUP " & QUOTE & lstGroups.List(X) & QUOTE
        gConnection.Execute SecString & "GROUP " & QUOTE & lstGroups.List(X) & QUOTE
        LogQuery SecString & "GROUP " & QUOTE & lstGroups.List(X) & QUOTE
        Flag = True
      End If
    Next
    If Flag = False Then
      EndMsg
      MsgBox "You must select at least one user or group to grant privileges to!", vbExclamation, "Error"
      Exit Sub
    End If
    gConnection.CommitTrans
  End If
  Refresh_Lists
  Exit Sub
Err_Handler:
  Set rsClass = Nothing
  EndMsg
  If Err.Number <> 0 Then LogError Err, "frmPrivileges, cmdApply_Click"
End Sub

Private Sub Form_Resize()
On Error GoTo Err_Handler
  If Me.WindowState = 0 Then
    If Me.Width < 5160 Then Me.Width = 5160
    If Me.Height < 5790 Then Me.Height = 5790
  End If
  Exit Sub
Err_Handler: If Err.Number <> 0 Then fMainForm.vsErr.LogError Err, "frmPrinter, Form_Load"
End Sub

Private Sub Form_Load()
On Error GoTo Err_Handler
  LogMsg "Loading Form: " & Me.Name
  Me.Width = 5160
  Me.Height = 5790
  Privilege = "ALL"
  Refresh_Lists
  Gen_SQL
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmPrivileges, Form_Load"
End Sub

Private Sub Refresh_Lists()
On Error GoTo Err_Handler
Dim rs As New Recordset
  lstClass.Clear
  lstUsers.Clear
  StartMsg "Retrieving Class User & Group Names..."
  LogMsg "Executing: SELECT DISTINCT ON (table_name) table_name, table_acl FROM pgadmin_tables WHERE table_name NOT LIKE 'pgadmin_%' AND table_oid > " & LAST_SYSTEM_OID & " ORDER BY table_name"
  rs.Open "SELECT DISTINCT ON (table_name) table_name, table_acl FROM pgadmin_tables WHERE table_name NOT LIKE 'pgadmin_%' AND table_oid > " & LAST_SYSTEM_OID & " ORDER BY table_name", gConnection, adOpenForwardOnly
  While Not rs.EOF
      lstClass.AddItem rs!table_name & vbTab & rs!table_acl
    rs.MoveNext
  Wend
  If rs.State <> adStateClosed Then rs.Close
  LogMsg "Executing: SELECT user_name FROM pgadmin_users ORDER BY user_name"
  rs.Open "SELECT user_name FROM pgadmin_users ORDER BY user_name", gConnection, adOpenForwardOnly
  While Not rs.EOF
    lstUsers.AddItem rs!user_name
    rs.MoveNext
  Wend
  If rs.State <> adStateClosed Then rs.Close
  LogMsg "Executing: SELECT group_name FROM pgadmin_groups ORDER BY group_name"
  rs.Open "SELECT group_name FROM pgadmin_groups ORDER BY group_name", gConnection, adOpenForwardOnly
  While Not rs.EOF
    lstGroups.AddItem rs.Fields(0).Value
    rs.MoveNext
  Wend
  Set rs = Nothing
  EndMsg
  Exit Sub
Err_Handler:
  Set rs = Nothing
  EndMsg
  If Err.Number <> 0 Then LogError Err, "frmPrivileges, Refresh_Lists"
End Sub
Private Sub lstClass_Click()
On Error GoTo Err_Handler
  Gen_SQL
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmPrivileges, lstClass_Click"
End Sub

Private Sub lstGroups_Click()
On Error GoTo Err_Handler
  Gen_SQL
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmPrivileges, lstGroups_Click"
End Sub

Private Sub lstUsers_Click()
On Error GoTo Err_Handler
  Gen_SQL
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmPrivileges, lstUsers_Click"
End Sub

Private Sub optAction_Click(Index As Integer)
On Error GoTo Err_Handler
  Gen_SQL
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmPrivileges, optAction_Click"
End Sub

Private Sub optPrivilege_Click(Index As Integer)
On Error GoTo Err_Handler
  Select Case Index
    Case 0
      Privilege = "ALL"
    Case 1
      Privilege = "SELECT"
    Case 2
      Privilege = "INSERT"
    Case 3
      Privilege = "UPDATE"
    Case 4
      Privilege = "DELETE"
    Case 5
      Privilege = "RULE"
  End Select
  Gen_SQL
  Exit Sub
Err_Handler: If Err.Number <> 0 Then LogError Err, "frmPrivileges, optPrivilege_Click"
End Sub
