<?php

/**************************************************
Program name:	get_array_references.inc.php

Author:		Joe Mitchell (jwm@basecoach.com)
		Dan Wilson (phpPgAdmin@acucore.com)

Description:	Get array of all table(column) combinations where 
		column has UNIQUE attribute.
			
Create Date:	6/29/01 

Modified Date(s):	
**************************************************/

// SQL string to get all table(column) combinations
// Where UNIQUE is TRUE

$sql_get = "
		SELECT 
			ic.relname AS index_name, 
			bc.relname AS table_name, 
			ta.attname AS field,
			i.indisunique AS unique_key,
			i.indisprimary AS primary_key,
			obj_description(ic.oid) as description 
		FROM 
			pg_class bc,
			pg_class ic,
			pg_index i,
			pg_attribute ta,
			pg_attribute ia
		WHERE 
			bc.oid = i.indrelid
			AND ic.relname NOT LIKE 'pg%'
			AND ic.oid = i.indexrelid
			AND ia.attrelid = i.indexrelid
			AND ta.attrelid = bc.oid
			AND ta.attrelid = i.indrelid
			AND ta.attnum = i.indkey[ia.attnum-1]
			AND i.indisunique = 't' 
		ORDER BY 
			field
";



// Connect and Execute the SQL statement ($sql_get)
include($PATH_INCLUDE."connect_exec.inc.php");


// Result array and add --none-- value to array
unset($aryREFERENCES);
$aryREFERENCES[$num_rows] = "--none--";

// Build aryREFERENCES
for ($i = 0; $i < $num_rows; $i++) {
	$aryREFERENCES[$i] = dq($sql_array[$i][1])."(".dq($sql_array[$i][2]).")";
	#add addslashes
}

?>

