/* Module:          SQLRowCount.c
 *
 * Description:     Returns the number of rows affected by an UPDATE, 
 *					INSERT, or DELETE statement
 *
 * Classes:         
 *
 * API functions:   SQLRowCount
 *
 * Comments:        See "notice.txt" for copyright and license information.
 *
 */

#include "driver.h"

SQLRETURN SQL_API SQLRowCount(
							  SQLHSTMT		hDrvStmt,
							  SQLINTEGER	*pnRowCount
							  )
{
static char *func="SQLRowCount";
StatementClass *stmt = (StatementClass *) hDrvStmt;
QResultClass *res;
char *msg, *ptr;

	if ( ! stmt) {
		SC_log_error(func, "", NULL);
		return SQL_INVALID_HANDLE;
	}
	if (stmt->manual_result) {
		if (pnRowCount)
			*pnRowCount = -1;
		return SQL_SUCCESS;
	}

	if(stmt->statement_type == STMT_TYPE_SELECT) {
		if (stmt->status == STMT_FINISHED) {
			res = SC_get_Result(stmt);

			if(res && pnRowCount) {
				*pnRowCount = globals.use_declarefetch ? -1 : QR_get_num_tuples(res);
				return SQL_SUCCESS;
			}
		}
	} else {

		res = SC_get_Result(stmt);
		if (res && pnRowCount) {
			msg = QR_get_command(res);
			mylog("*** msg = '%s'\n", msg);
			trim(msg);	/*	get rid of trailing spaces */
			ptr = strrchr(msg, ' ');
			if (ptr) {
				*pnRowCount = atoi(ptr+1);
				mylog("**** SQLRowCount(): THE ROWS: *pnRowCount = %d\n", *pnRowCount);
			}
			else {
				*pnRowCount = -1;

				mylog("**** SQLRowCount(): NO ROWS: *pnRowCount = %d\n", *pnRowCount);
			}

		return SQL_SUCCESS;
		}
	}

	SC_log_error(func, "Bad return value", stmt);
	return SQL_ERROR;     
}
