/**********************************************
 * driverextras.h
 *
 */

#ifndef DRIVEREXTRAS_H
#define DRIVEREXTRAS_H



#ifndef WIN32
	#define Int4 long int
	typedef float SFLOAT;
	typedef double SDOUBLE;
	#define NEAR
	#define closesocket(xxx) close(xxx)
	#define SOCKETFD int
	
	#ifndef       INADDR_NONE
		#define INADDR_NONE ((in_addr_t)-1)
	#endif

	#ifndef _IN_ADDR_T
		#define _IN_ADDR_T
		typedef unsigned int    in_addr_t;
	#endif

	# define SQLGetPrivateProfileString(a,b,c,d,e,f) GetPrivateProfileString(a,b,c,d,e,f)
	# define SQLWritePrivateProfileString(a,b,c,d) WritePrivateProfileString(a,b,c,d)

	#ifndef HAVE_STRICMP
		#define stricmp(s1,s2) 		strcasecmp(s1,s2)
		#define strnicmp(s1,s2,n)	strncasecmp(s1,s2,n)
	#endif
#else
	#define Int4 int
	#define SOCKETFD SOCKET
#endif

#define UInt4 unsigned int
#define Int2 short
#define UInt2 unsigned short
typedef UInt4 Oid;

#define CI_get_num_fields(self)			(self->num_fields)
#define CI_get_oid(self, col)			(self->adtid[col])
#define CI_get_fieldname(self, col)		(self->name[col])
#define CI_get_fieldsize(self, col)		(self->adtsize[col])
#define CI_get_display_size(self, col)	(self->display_size[col])
#define CI_get_atttypmod(self, col)		(self->atttypmod[col])

#define COPY_OK                      0
#define COPY_UNSUPPORTED_TYPE        1
#define COPY_UNSUPPORTED_CONVERSION  2
#define COPY_RESULT_TRUNCATED        3
#define COPY_GENERAL_ERROR           4
#define COPY_NO_DATA_FOUND           5

#define QR_get_fields(self)				(self->fields)
/*	These functions are for retrieving data from the qresult */
#define QR_get_value_manual(self, tupleno, fieldno)	(TL_get_fieldval(self->manual_tuples, tupleno, fieldno))
#define QR_get_value_backend(self, fieldno)			(self->tupleField[fieldno].value) 
#define QR_get_value_backend_row(self, tupleno, fieldno) ((self->backend_tuples + (tupleno * self->num_fields))[fieldno].value)
/*	These functions are used by both manual and backend results */
#define QR_NumResultCols(self)				(CI_get_num_fields(self->fields))
#define QR_get_fieldname(self, fieldno_)	(CI_get_fieldname(self->fields, fieldno_))
#define QR_get_fieldsize(self, fieldno_)	(CI_get_fieldsize(self->fields, fieldno_))    
#define QR_get_display_size(self, fieldno_)	(CI_get_display_size(self->fields, fieldno_))    
#define QR_get_atttypmod(self, fieldno_)	(CI_get_atttypmod(self->fields, fieldno_))    
#define QR_get_field_type(self, fieldno_)   (CI_get_oid(self->fields, fieldno_))
/*	These functions are used only for manual result sets */
#define QR_get_num_tuples(self)				(self->manual_tuples ? TL_get_num_tuples(self->manual_tuples) : self->fcount)
#define QR_add_tuple(self, new_tuple)		(TL_add_tuple(self->manual_tuples, new_tuple))
#define QR_set_field_info(self, field_num, name, adtid, adtsize)  (CI_set_field_info(self->fields, field_num, name, adtid, adtsize, -1))
/* status macros */
#define QR_command_successful(self)		( !(self->status == PGRES_BAD_RESPONSE || self->status == PGRES_NONFATAL_ERROR || self->status == PGRES_FATAL_ERROR))
#define QR_command_nonfatal(self)		( self->status == PGRES_NONFATAL_ERROR)
#define QR_end_tuples(self)				( self->status == PGRES_END_TUPLES)
#define QR_set_status(self, condition)	( self->status = condition )
#define QR_set_message(self, message_)	( self->message = message_)
#define QR_set_aborted(self, aborted_)	( self->aborted = aborted_)
#define QR_get_message(self)			(self->message)
#define QR_get_command(self)			(self->command)
#define QR_get_notice(self)				(self->notice)
#define QR_get_status(self)				(self->status)
#define QR_get_aborted(self)				(self->aborted)
#define QR_aborted(self)		(!self || self->aborted)

#if 0
#define PG_TYPE_LO			???? 	/* waiting for permanent type */
#endif

#define PG_TYPE_BOOL         16
#define PG_TYPE_BYTEA        17
#define PG_TYPE_CHAR         18
#define PG_TYPE_NAME         19
#define PG_TYPE_INT8         20
#define PG_TYPE_INT2         21
#define PG_TYPE_INT2VECTOR   22
#define PG_TYPE_INT4         23
#define PG_TYPE_REGPROC      24
#define PG_TYPE_TEXT         25
#define PG_TYPE_OID          26
#define PG_TYPE_TID          27
#define PG_TYPE_XID          28
#define PG_TYPE_CID          29
#define PG_TYPE_OIDVECTOR    30
#define PG_TYPE_SET          32
#define PG_TYPE_CHAR2       409
#define PG_TYPE_CHAR4       410
#define PG_TYPE_CHAR8       411
#define PG_TYPE_POINT       600
#define PG_TYPE_LSEG        601
#define PG_TYPE_PATH        602
#define PG_TYPE_BOX         603
#define PG_TYPE_POLYGON     604
#define PG_TYPE_FILENAME    605
#define PG_TYPE_FLOAT4      700
#define PG_TYPE_FLOAT8      701
#define PG_TYPE_ABSTIME     702
#define PG_TYPE_RELTIME     703
#define PG_TYPE_TINTERVAL   704
#define PG_TYPE_UNKNOWN     705
#define PG_TYPE_MONEY		790
#define PG_TYPE_OIDINT2     810
#define PG_TYPE_OIDINT4     910
#define PG_TYPE_OIDNAME     911
#define PG_TYPE_BPCHAR     1042
#define PG_TYPE_VARCHAR    1043
#define PG_TYPE_DATE       1082
#define PG_TYPE_TIME       1083
#define PG_TYPE_DATETIME   1184
#define PG_TYPE_TIMESTAMP  1296
#define PG_TYPE_NUMERIC    1700

/* extern Int4 pgtypes_defined[]; */
extern Int2 sqlTypes[];

/*	Defines for pgtype_precision */
#define PG_STATIC		-1	

#define LO_CREAT		957
#define LO_OPEN			952
#define LO_CLOSE		953
#define LO_READ			954
#define LO_WRITE		955
#define LO_LSEEK		956
#define LO_TELL			958
#define LO_UNLINK		964

#define INV_WRITE		0x00020000
#define INV_READ		0x00040000

#define TL_get_num_tuples(x)	(x->num_tuples)

#define set_nullfield_string(FLD, VAL)		((VAL) ? set_tuplefield_string(FLD, (VAL)) : set_tuplefield_null(FLD))
#define set_nullfield_int2(FLD, VAL)		((VAL) != -1 ? set_tuplefield_int2(FLD, (VAL)) : set_tuplefield_null(FLD))
#define set_nullfield_int4(FLD, VAL)		((VAL) != -1 ? set_tuplefield_int4(FLD, (VAL)) : set_tuplefield_null(FLD))

/*	Unknown data type sizes */
#define UNKNOWNS_AS_MAX				0
#define UNKNOWNS_AS_DONTKNOW		1
#define UNKNOWNS_AS_LONGEST			2

/* INI File Stuff */
#ifndef WIN32
# define ODBC_INI        ".odbc.ini"
# ifdef ODBCINSTDIR
#  define ODBCINST_INI    ODBCINSTDIR "/odbcinst.ini"
# else
#  define ODBCINST_INI    "/etc/odbcinst.ini"
# endif
#else /* WIN32 */
# define ODBC_INI        "ODBC.INI"         /* ODBC initialization file */
# define ODBCINST_INI    "ODBCINST.INI"     /* ODBC Installation file */
#endif /* WIN32 */


#define INI_DSN           DBMS_NAME         /* Name of default Datasource in ini file (not used?) */
#define INI_KDESC         "Description"     /* Data source description */
#define INI_SERVER        "Servername"      /* Name of Server running the Postgres service */
#define INI_PORT          "Port"            /* Port on which the Postmaster is listening */ 
#define INI_DATABASE      "Database"        /* Database Name */
#define INI_USER          "Username"        /* Default User Name */
#define INI_PASSWORD      "Password"		/* Default Password */
#define INI_DEBUG         "Debug"			/* Debug flag */
#define INI_FETCH         "Fetch"			/* Fetch Max Count */
#define INI_SOCKET        "Socket"			/* Socket buffer size */
#define INI_READONLY      "ReadOnly"		/* Database is read only */
#define INI_COMMLOG       "CommLog"			/* Communication to backend logging */
#define INI_PROTOCOL      "Protocol"		/* What protocol (6.2) */
#define INI_OPTIMIZER     "Optimizer"		/* Use backend genetic optimizer */
#define INI_KSQO          "Ksqo"            /* Keyset query optimization */
#define INI_CONNSETTINGS  "ConnSettings"	/* Anything to send to backend on successful connection */
#define INI_UNIQUEINDEX   "UniqueIndex"		/* Recognize unique indexes */
#define INI_UNKNOWNSIZES  "UnknownSizes"	/* How to handle unknown result set sizes */
#define INI_CANCELASFREESTMT  "CancelAsFreeStmt"
#define INI_USEDECLAREFETCH "UseDeclareFetch"		/* Use Declare/Fetch cursors */

/*	More ini stuff */
#define INI_TEXTASLONGVARCHAR		"TextAsLongVarchar"
#define INI_UNKNOWNSASLONGVARCHAR	"UnknownsAsLongVarchar"
#define INI_BOOLSASCHAR				"BoolsAsChar"
#define INI_MAXVARCHARSIZE			"MaxVarcharSize"
#define INI_MAXLONGVARCHARSIZE		"MaxLongVarcharSize"
#define INI_FAKEOIDINDEX			"FakeOidIndex"
#define INI_SHOWOIDCOLUMN			"ShowOidColumn"
#define INI_ROWVERSIONING			"RowVersioning"
#define INI_SHOWSYSTEMTABLES		"ShowSystemTables"
#define INI_LIE						"Lie"
#define INI_PARSE					"Parse"
#define INI_EXTRASYSTABLEPREFIXES	"ExtraSysTablePrefixes"
#define INI_TRANSLATIONNAME       "TranslationName"
#define INI_TRANSLATIONDLL        "TranslationDLL"
#define INI_TRANSLATIONOPTION     "TranslationOption"

/*	Connection Defaults */
#define DEFAULT_PORT					"5432"
#define DEFAULT_READONLY				1
#define DEFAULT_PROTOCOL				"6.4"		/* the latest protocol is the default */
#define DEFAULT_USEDECLAREFETCH			0
#define DEFAULT_TEXTASLONGVARCHAR		1
#define DEFAULT_UNKNOWNSASLONGVARCHAR	0
#define DEFAULT_BOOLSASCHAR				1
#define DEFAULT_OPTIMIZER				1		/* disable */
#define DEFAULT_KSQO					1		/* on */
#define DEFAULT_UNIQUEINDEX				0		/* dont recognize */
#define DEFAULT_COMMLOG					0		/* dont log */
#define DEFAULT_DEBUG					0
#define DEFAULT_UNKNOWNSIZES			UNKNOWNS_AS_MAX
#define DEFAULT_FAKEOIDINDEX			0
#define DEFAULT_SHOWOIDCOLUMN			0
#define DEFAULT_ROWVERSIONING			0
#define DEFAULT_SHOWSYSTEMTABLES		0		/* dont show system tables */
#define DEFAULT_LIE						0
#define DEFAULT_PARSE					0
#define DEFAULT_CANCELASFREESTMT		0
#define DEFAULT_EXTRASYSTABLEPREFIXES	"dd_;"

#ifndef BOOL
#define BOOL	int
#endif
#ifndef FALSE
#define FALSE	(BOOL)0
#endif
#ifndef TRUE
#define TRUE	(BOOL)1
#endif

#define ENV_ALLOC_ERROR 1
#define PRN_NULLCHECK
#define STMT_INCREMENT 16  /* how many statement holders to allocate at a time */
#define TRIGGER_SHIFT 3
#define TRIGGER_MASK   0x03
#define TRIGGER_DELETE 0x01
#define TRIGGER_UPDATE 0x02
#define FLD_INCR	32
#define TAB_INCR	8
#define COL_INCR	16
/***************************/
// psqlodbc.h
#define MAX_MESSAGE_LEN				(BLCKSZ*2)   
#define MAX_CONNECT_STRING			4096
#define ERROR_MSG_LENGTH			4096
#define FETCH_MAX					100		/* default number of rows to cache for declare/fetch */
#define TUPLE_MALLOC_INC			100
#define SOCK_BUFFER_SIZE			4096	/* default socket buffer size */
#define MAX_CONNECTIONS				128		/* conns per environment (arbitrary)  */
#define MAX_FIELDS					512
#define BYTELEN						8
#define VARHDRSZ					sizeof(Int4)
#define MAX_TABLE_LEN				32
#define MAX_COLUMN_LEN				32
#define MAX_CURSOR_LEN				32
/*	Registry length limits */
#define LARGE_REGISTRY_LEN			4096	/* used for special cases */
#define MEDIUM_REGISTRY_LEN			256		/* normal size for user,database,etc. */
#define SMALL_REGISTRY_LEN			10		/* for 1/0 settings */
/*	These prefixes denote system tables */
#define POSTGRES_SYS_PREFIX	"pg_"
#define KEYS_TABLE			"dd_fkey"
/*	Info limits */
#define MAX_INFO_STRING		128
#define MAX_KEYPARTS		20
#define MAX_KEYLEN			512			/*	max key of the form "date+outlet+invoice" */
#define MAX_ROW_SIZE		0 /* Unlimited rowsize with the Tuple Toaster */
#define MAX_STATEMENT_LEN	0 /* Unlimited statement size with 7.0 */
/* Previously, numerous query strings were defined of length MAX_STATEMENT_LEN */
/* Now that's 0, lets use this instead. DJP 24-1-2001 */
#define STD_STATEMENT_LEN	MAX_MESSAGE_LEN
#define PG62	"6.2"		/* "Protocol" key setting to force Postgres 6.2 */
#define PG63	"6.3"		/* "Protocol" key setting to force postgres 6.3 */
#define PG64	"6.4"
#define PG_TYPE_LO				-999	/* hack until permanent type available */
#define PG_TYPE_LO_NAME			"lo"
#define OID_ATTNUM				-2		/* the attnum in pg_index of the oid */
/* sizes */
#define TEXT_FIELD_SIZE			8190	/* size of text fields (not including null term) */
#define NAME_FIELD_SIZE			32		/* size of name fields */
#define MAX_VARCHAR_SIZE		254		/* maximum size of a varchar (not including null term) */
#define PG_NUMERIC_MAX_PRECISION	1000
#define PG_NUMERIC_MAX_SCALE		1000
/* defines for return value of my_strcpy */
#define STRCPY_SUCCESS		1
#define STRCPY_FAIL			0
#define STRCPY_TRUNCATED	-1
#define STRCPY_NULL			-2

/*	Uncomment MY_LOG define to compile in the mylog() statements.
	Then, debug logging will occur if 'Debug' is set to 1 in the ODBCINST.INI
	portion of the registry.  You may have to manually add this key.
	This logfile is intended for development use, not for an end user!
*/
#define MY_LOG

/*	Uncomment Q_LOG to compile in the qlog() statements (Communications log, i.e. CommLog).
	This logfile contains serious log statements that are intended for an
	end user to be able to read and understand.  It is controlled by the
	'CommLog' flag in the ODBCINST.INI portion of the registry (see above),
	which is manipulated on the setup/connection dialog boxes.
*/
#define Q_LOG


#ifdef MY_LOG
  #define MYLOGFILE	"mylog_"
  #ifndef WIN32
    #define MYLOGDIR	"/tmp"
  #else
    #define MYLOGDIR	"c:"
  #endif
  extern void mylog(char * fmt, ...);
#else
  #ifndef WIN32
    #define mylog(args...)	/* GNU convention for variable arguments */
  #else
    #define mylog    /* mylog */
  #endif
#endif

#ifdef Q_LOG
  #define QLOGFILE	"psqlodbc_"
  #ifndef WIN32
    #define QLOGDIR		"/tmp"
  #else
    #define QLOGDIR		"c:"
  #endif
  extern void qlog(char * fmt, ...);
#else
  #ifndef WIN32
    #define qlog(args...)	/* GNU convention for variable arguments */
  #else
    #define qlog    /* qlog */
  #endif
#endif

#ifndef WIN32
#define DIRSEPARATOR	"/"
#else
#define DIRSEPARATOR	"\\"
#endif

#ifdef WIN32
#define PG_BINARY	O_BINARY
#define	PG_BINARY_R	"rb"
#define	PG_BINARY_W	"wb"
#else
#define	PG_BINARY	0
#define	PG_BINARY_R	"r"
#define	PG_BINARY_W	"w"
#endif

#define SOCKET_ALREADY_CONNECTED 1
#define SOCKET_HOST_NOT_FOUND 2
#define SOCKET_COULD_NOT_CREATE_SOCKET 3
#define SOCKET_COULD_NOT_CONNECT 4
#define SOCKET_READ_ERROR 5
#define SOCKET_WRITE_ERROR 6
#define SOCKET_NULLPOINTER_PARAMETER 7
#define SOCKET_PUT_INT_WRONG_LENGTH 8
#define SOCKET_GET_INT_WRONG_LENGTH 9
#define SOCKET_CLOSED 10
#define SOCK_get_char(self)		(SOCK_get_next_byte(self))
#define SOCK_put_char(self, c)	(SOCK_put_next_byte(self, c))

/* error functions */
#define SOCK_get_errcode(self)		(self->errornumber)
#define SOCK_get_errmsg(self)		(self->errormsg)

/*	These errors have general sql error state */
#define CONNECTION_SERVER_NOT_REACHED 101
#define CONNECTION_MSG_TOO_LONG 103
#define CONNECTION_COULD_NOT_SEND 104
#define CONNECTION_NO_SUCH_DATABASE 105
#define CONNECTION_BACKEND_CRAZY 106
#define CONNECTION_NO_RESPONSE 107
#define CONNECTION_SERVER_REPORTED_ERROR 108
#define CONNECTION_COULD_NOT_RECEIVE 109
#define CONNECTION_SERVER_REPORTED_WARNING 110
#define CONNECTION_NEED_PASSWORD 112

/*	These errors correspond to specific SQL states */
#define CONN_INIREAD_ERROR 201
#define CONN_OPENDB_ERROR 202
#define CONN_STMT_ALLOC_ERROR 203
#define CONN_IN_USE 204 
#define CONN_UNSUPPORTED_OPTION 205
/* Used by SetConnectoption to indicate unsupported options */
#define CONN_INVALID_ARGUMENT_NO 206
/* SetConnectOption: corresponds to ODBC--"S1009" */
#define CONN_TRANSACT_IN_PROGRES 207
#define CONN_NO_MEMORY_ERROR 208
#define CONN_NOT_IMPLEMENTED_ERROR 209
#define CONN_INVALID_AUTHENTICATION 210
#define CONN_AUTH_TYPE_UNSUPPORTED 211
#define CONN_UNABLE_TO_LOAD_DLL 212
#define CONN_OPTION_VALUE_CHANGED 213
#define CONN_VALUE_OUT_OF_RANGE 214
#define CONN_TRUNCATED 215

/* Conn_status defines */
#define CONN_IN_AUTOCOMMIT 0x01
#define CONN_IN_TRANSACTION 0x02

/* AutoCommit functions */
#define CC_set_autocommit_off(x)	(x->transact_status &= ~CONN_IN_AUTOCOMMIT)
#define CC_set_autocommit_on(x)		(x->transact_status |= CONN_IN_AUTOCOMMIT)
#define CC_is_in_autocommit(x)		(x->transact_status & CONN_IN_AUTOCOMMIT)

/* Transaction in/not functions */
#define CC_set_in_trans(x)	(x->transact_status |= CONN_IN_TRANSACTION)
#define CC_set_no_trans(x)	(x->transact_status &= ~CONN_IN_TRANSACTION)
#define CC_is_in_trans(x)	(x->transact_status & CONN_IN_TRANSACTION)

/* Authentication types */
#define AUTH_REQ_OK			0
#define AUTH_REQ_KRB4		1
#define AUTH_REQ_KRB5		2
#define AUTH_REQ_PASSWORD	3
#define AUTH_REQ_CRYPT		4

/*	Startup Packet sizes */
#define SM_DATABASE		64
#define SM_USER			32
#define SM_OPTIONS		64
#define SM_UNUSED		64
#define SM_TTY			64

/*	Old 6.2 protocol defines */
#define NO_AUTHENTICATION	7
#define PATH_SIZE			64
#define ARGV_SIZE			64
#define NAMEDATALEN			16

typedef unsigned int ProtocolVersion;

#define PG_PROTOCOL(major, minor)	(((major) << 16) | (minor))
#define PG_PROTOCOL_LATEST		PG_PROTOCOL(2, 0)
#define PG_PROTOCOL_63			PG_PROTOCOL(1, 0)
#define PG_PROTOCOL_62			PG_PROTOCOL(0, 0)

/*	Macro to determine is the connection using 6.2 protocol? */
#define PROTOCOL_62(conninfo_)		(strncmp((conninfo_)->protocol, PG62, strlen(PG62)) == 0)

/*	Macro to determine is the connection using 6.3 protocol? */
#define PROTOCOL_63(conninfo_)		(strncmp((conninfo_)->protocol, PG63, strlen(PG63)) == 0)

/*
 *	Macros to compare the server's version with a specified version
 *		1st parameter: pointer to a ConnectionClass object
 *		2nd parameter: major version number
 *		3rd parameter: minor version number
 */
#define SERVER_VERSION_GT(conn, major, minor) \
	((conn)->pg_version_major > major || \
	((conn)->pg_version_major == major && (conn)->pg_version_minor > minor))
#define SERVER_VERSION_GE(conn, major, minor) \
	((conn)->pg_version_major > major || \
	((conn)->pg_version_major == major && (conn)->pg_version_minor >= minor))
#define SERVER_VERSION_EQ(conn, major, minor) \
	((conn)->pg_version_major == major && (conn)->pg_version_minor == minor)
#define SERVER_VERSION_LE(conn, major, minor) (! SERVER_VERSION_GT(conn, major, minor))
#define SERVER_VERSION_LT(conn, major, minor) (! SERVER_VERSION_GE(conn, major, minor))
/*#if ! defined(HAVE_CONFIG_H) || defined(HAVE_STRINGIZE)*/
#define	STRING_AFTER_DOT(string)	(strchr(#string, '.') + 1)
/*#else
#define	STRING_AFTER_DOT(str)	(strchr("str", '.') + 1)
#endif*/
/*
 *	Simplified macros to compare the server's version with a
 *		specified version
 *	Note: Never pass a variable as the second parameter.
 *	      It must be a decimal constant of the form %d.%d . 
 */
#define PG_VERSION_GT(conn, ver) \
 (SERVER_VERSION_GT(conn, (int) ver, atoi(STRING_AFTER_DOT(ver))))
#define PG_VERSION_GE(conn, ver) \
 (SERVER_VERSION_GE(conn, (int) ver, atoi(STRING_AFTER_DOT(ver))))
#define PG_VERSION_EQ(conn, ver) \
 (SERVER_VERSION_EQ(conn, (int) ver, atoi(STRING_AFTER_DOT(ver))))
#define PG_VERSION_LE(conn, ver) (! PG_VERSION_GT(conn, ver))
#define PG_VERSION_LT(conn, ver) (! PG_VERSION_GE(conn, ver))

 /* Translation DLL entry points */
#ifdef WIN32
#define DLLHANDLE HINSTANCE
#else
#define WINAPI CALLBACK
#define DLLHANDLE void *
#define HINSTANCE void *
#endif

/* Accessor functions */
#define CC_get_socket(x)	(x->sock)
#define CC_get_database(x)	(x->connInfo.database)
#define CC_get_server(x)	(x->connInfo.server)
#define CC_get_DSN(x)		(x->connInfo.dsn)
#define CC_get_username(x)	(x->connInfo.username)
#define CC_is_onlyread(x)	(x->connInfo.onlyread[0] == '1')

/*  for CC_DSN_info */
#define CONN_DONT_OVERWRITE		0
#define CONN_OVERWRITE			1 

#define STMT_TRUNCATED -2
#define STMT_INFO_ONLY -1 /* not an error message, just a notification to be returned by SQLError */
#define STMT_OK 0 /* will be interpreted as "no error pending" */
#define STMT_EXEC_ERROR 1
#define STMT_STATUS_ERROR 2
#define STMT_SEQUENCE_ERROR 3
#define STMT_NO_MEMORY_ERROR 4
#define STMT_COLNUM_ERROR 5
#define STMT_NO_STMTSTRING 6
#define STMT_ERROR_TAKEN_FROM_BACKEND 7
#define STMT_INTERNAL_ERROR 8
#define STMT_STILL_EXECUTING 9
#define STMT_NOT_IMPLEMENTED_ERROR 10
#define STMT_BAD_PARAMETER_NUMBER_ERROR 11
#define STMT_OPTION_OUT_OF_RANGE_ERROR 12
#define STMT_INVALID_COLUMN_NUMBER_ERROR 13
#define STMT_RESTRICTED_DATA_TYPE_ERROR 14
#define STMT_INVALID_CURSOR_STATE_ERROR 15
#define STMT_OPTION_VALUE_CHANGED 16
#define STMT_CREATE_TABLE_ERROR 17
#define STMT_NO_CURSOR_NAME 18
#define STMT_INVALID_CURSOR_NAME 19
#define STMT_INVALID_ARGUMENT_NO 20
#define STMT_ROW_OUT_OF_RANGE 21
#define STMT_OPERATION_CANCELLED 22
#define STMT_INVALID_CURSOR_POSITION 23
#define STMT_VALUE_OUT_OF_RANGE 24
#define STMT_OPERATION_INVALID 25
#define STMT_PROGRAM_TYPE_OUT_OF_RANGE 26
#define STMT_BAD_ERROR 27
#define STMT_UPDATE(stmt)	(stmt->statement_type > STMT_TYPE_SELECT)
#define SC_get_conn(a)    (a->hdbc)
#define SC_get_Result(a)  (a->result);

/*	options for SC_free_params() */
#define STMT_FREE_PARAMS_ALL				0
#define STMT_FREE_PARAMS_DATA_AT_EXEC_ONLY	1

#endif


