/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.common.junit4;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.maven.surefire.NonAbstractClassFilter;
import org.apache.maven.surefire.common.junit3.JUnit3TestChecker;
import org.apache.maven.surefire.util.ReflectionUtils;
import org.apache.maven.surefire.util.ScannerFilter;
import org.junit.Test;
import org.junit.runner.RunWith;

public class JUnit4TestChecker
implements ScannerFilter {
    private final NonAbstractClassFilter nonAbstractClassFilter;
    private final Class runWith;
    private final JUnit3TestChecker jUnit3TestChecker;

    public JUnit4TestChecker(ClassLoader testClassLoader) {
        this.jUnit3TestChecker = new JUnit3TestChecker(testClassLoader);
        this.runWith = ReflectionUtils.tryLoadClass((ClassLoader)testClassLoader, (String)RunWith.class.getName());
        this.nonAbstractClassFilter = new NonAbstractClassFilter();
    }

    public boolean accept(Class testClass) {
        return this.jUnit3TestChecker.accept(testClass) || this.isValidJUnit4Test(testClass);
    }

    private boolean isValidJUnit4Test(Class testClass) {
        Object runWithAnnotation;
        if (!this.nonAbstractClassFilter.accept(testClass)) {
            return false;
        }
        if (this.isRunWithPresentInClassLoader() && (runWithAnnotation = testClass.getAnnotation(this.runWith)) != null) {
            return true;
        }
        return this.lookForTestAnnotatedMethods(testClass);
    }

    private boolean lookForTestAnnotatedMethods(Class testClass) {
        for (Class classToCheck = testClass; classToCheck != null; classToCheck = classToCheck.getSuperclass()) {
            if (!this.checkforTestAnnotatedMethod(classToCheck)) continue;
            return true;
        }
        return false;
    }

    public boolean checkforTestAnnotatedMethod(Class testClass) {
        for (Method lMethod : testClass.getDeclaredMethods()) {
            for (Annotation lAnnotation : lMethod.getAnnotations()) {
                if (!Test.class.isAssignableFrom(lAnnotation.annotationType())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRunWithPresentInClassLoader() {
        return this.runWith != null;
    }
}

