/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit.examples;

import org.custommonkey.xmlunit.NodeTest;
import org.custommonkey.xmlunit.NodeTestException;
import org.custommonkey.xmlunit.NodeTester;
import org.w3c.dom.Node;

public class CountingNodeTester
implements NodeTester {
    private final int expectedNumNodes;
    private int actualNumNodes;

    public CountingNodeTester(int expectedNumNodes) {
        this.expectedNumNodes = expectedNumNodes;
    }

    public void testNode(Node aNode, NodeTest forTest) {
        ++this.actualNumNodes;
    }

    public void noMoreNodes(NodeTest forTest) throws NodeTestException {
        int testedNodes = this.actualNumNodes;
        this.resetCounter();
        if (testedNodes != this.expectedNumNodes) {
            throw new NodeTestException("Counted " + testedNodes + " node(s) but expected " + this.expectedNumNodes);
        }
    }

    public void resetCounter() {
        this.actualNumNodes = 0;
    }
}

