/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.maven.surefire.booter.AbstractPathConfiguration;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.ModularClasspath;
import org.apache.maven.surefire.booter.SurefireExecutionException;

public class ModularClasspathConfiguration
extends AbstractPathConfiguration {
    private final ModularClasspath modularClasspath;
    private final Classpath testClasspathUrls;
    private final Classpath inprocClasspath;

    public ModularClasspathConfiguration(@Nonnull ModularClasspath modularClasspath, @Nonnull Classpath testClasspathUrls, @Nonnull Classpath surefireClasspathUrls, @Nonnull Classpath inprocClasspath, boolean enableAssertions, boolean childDelegation) {
        super(surefireClasspathUrls, enableAssertions, childDelegation);
        this.modularClasspath = modularClasspath;
        this.testClasspathUrls = testClasspathUrls;
        this.inprocClasspath = inprocClasspath;
    }

    @Override
    public Classpath getTestClasspath() {
        return this.testClasspathUrls;
    }

    @Override
    public final boolean isModularPathConfig() {
        return true;
    }

    @Override
    public final boolean isClassPathConfig() {
        return !this.isModularPathConfig();
    }

    public ModularClasspath getModularClasspath() {
        return this.modularClasspath;
    }

    @Override
    public ClassLoader createMergedClassLoader() throws SurefireExecutionException {
        List<String> modulePath = this.getModularClasspath().getModulePath();
        return this.createMergedClassLoader(Classpath.join(this.getInprocTestClasspath(), new Classpath(modulePath)));
    }

    @Override
    protected Classpath getInprocClasspath() {
        return this.inprocClasspath;
    }
}

