/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.resources;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.codehaus.plexus.components.io.attributes.Java7FileAttributes;
import org.codehaus.plexus.components.io.attributes.Java7Reflector;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributeUtils;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.attributes.SimpleResourceAttributes;
import org.codehaus.plexus.components.io.functions.PlexusIoResourceConsumer;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResourceCollectionWithAttributes;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.ResourceFactory;
import org.codehaus.plexus.components.io.resources.Stream;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlexusIoFileResourceCollection
extends AbstractPlexusIoResourceCollectionWithAttributes {
    public static final String ROLE_HINT = "files";
    private File baseDir;
    private boolean isFollowingSymLinks = true;

    @Override
    public PlexusIoResource resolve(PlexusIoResource resource) throws IOException {
        return resource;
    }

    @Override
    public InputStream getInputStream(PlexusIoResource resource) throws IOException {
        return resource.getContents();
    }

    @Override
    public String getName(PlexusIoResource resource) {
        return resource.getName();
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public boolean isFollowingSymLinks() {
        return this.isFollowingSymLinks;
    }

    public void setFollowingSymLinks(boolean pIsFollowingSymLinks) {
        this.isFollowingSymLinks = pIsFollowingSymLinks;
    }

    public void setDefaultAttributes(int uid, String userName, int gid, String groupName, int fileMode, int dirMode) {
        this.setDefaultFileAttributes(PlexusIoFileResourceCollection.createDefaults(uid, userName, gid, groupName, fileMode));
        this.setDefaultDirAttributes(PlexusIoFileResourceCollection.createDefaults(uid, userName, gid, groupName, dirMode));
    }

    public void setOverrideAttributes(int uid, String userName, int gid, String groupName, int fileMode, int dirMode) {
        this.setOverrideFileAttributes(PlexusIoFileResourceCollection.createDefaults(uid, userName, gid, groupName, fileMode));
        this.setOverrideDirAttributes(PlexusIoFileResourceCollection.createDefaults(uid, userName, gid, groupName, dirMode));
    }

    private static PlexusIoResourceAttributes createDefaults(int uid, String userName, int gid, String groupName, int mode) {
        return new SimpleResourceAttributes(uid, userName, gid, groupName, mode >= 0 ? mode : -1);
    }

    @Override
    public void setPrefix(String prefix) {
        char nonSeparator = File.separatorChar == '/' ? (char)'\\' : '/';
        super.setPrefix(StringUtils.replace((String)prefix, (char)nonSeparator, (char)File.separatorChar));
    }

    private void addResources(List<PlexusIoResource> result, String[] resources, Map<String, PlexusIoResourceAttributes> attributesByPath) throws IOException {
        File dir = this.getBaseDir();
        for (String name : resources) {
            String sourceDir = name.replace('\\', '/');
            File f = new File(dir, sourceDir);
            PlexusIoResourceAttributes attrs = attributesByPath.get(name.length() > 0 ? name : ".");
            if (attrs == null) {
                attrs = attributesByPath.get(f.getAbsolutePath());
            }
            if (attrs == null) {
                attrs = SimpleResourceAttributes.lastResortDummyAttributesForBrokenOS();
            }
            attrs = this.mergeAttributes(attrs, f.isDirectory());
            String remappedName = this.getName(name);
            PlexusIoResource resource = ResourceFactory.createResource(f, remappedName, null, this.getStreamTransformer(), attrs);
            if (!this.isSelected(resource)) continue;
            result.add(this.resolve(resource));
        }
    }

    private void addResourcesJava7(List<PlexusIoResource> result, String[] resources) throws IOException {
        File dir = this.getBaseDir();
        HashMap<Integer, String> cache1 = new HashMap<Integer, String>();
        HashMap<Integer, String> cache2 = new HashMap<Integer, String>();
        for (String name : resources) {
            String sourceDir = name.replace('\\', '/');
            File f = new File(dir, sourceDir);
            PlexusIoResourceAttributes attrs = new Java7FileAttributes(f, cache1, cache2);
            attrs = this.mergeAttributes(attrs, f.isDirectory());
            String remappedName = this.getName(name);
            PlexusIoResource resource = ResourceFactory.createResource(f, remappedName, null, this.getStreamTransformer(), attrs);
            if (!this.isSelected(resource)) continue;
            result.add(resource);
        }
    }

    @Override
    public Stream stream() {
        return new Stream(){

            public void forEach(PlexusIoResourceConsumer resourceConsumer) throws IOException {
                Iterator<PlexusIoResource> resources = PlexusIoFileResourceCollection.this.getResources();
                while (resources.hasNext()) {
                    PlexusIoResource next = resources.next();
                    if (!PlexusIoFileResourceCollection.this.isSelected(next)) continue;
                    resourceConsumer.accept(next);
                }
                if (resources instanceof Closeable) {
                    ((Closeable)((Object)resources)).close();
                }
            }

            public void forEach(ExecutorService es, final PlexusIoResourceConsumer resourceConsumer) throws IOException {
                Iterator<PlexusIoResource> resources = PlexusIoFileResourceCollection.this.getResources();
                while (resources.hasNext()) {
                    final PlexusIoResource next = resources.next();
                    Callable future = new Callable(){

                        public Object call() throws Exception {
                            resourceConsumer.accept(next);
                            return this;
                        }
                    };
                    es.submit(future);
                }
                if (resources instanceof Closeable) {
                    ((Closeable)((Object)resources)).close();
                }
            }
        };
    }

    @Override
    public Iterator<PlexusIoResource> getResources() throws IOException {
        String[] exc;
        DirectoryScanner ds = new DirectoryScanner();
        File dir = this.getBaseDir();
        ds.setBasedir(dir);
        String[] inc = this.getIncludes();
        if (inc != null && inc.length > 0) {
            ds.setIncludes(inc);
        }
        if ((exc = this.getExcludes()) != null && exc.length > 0) {
            ds.setExcludes(exc);
        }
        if (this.isUsingDefaultExcludes()) {
            ds.addDefaultExcludes();
        }
        ds.setCaseSensitive(this.isCaseSensitive());
        ds.setFollowSymlinks(this.isFollowingSymLinks());
        ds.scan();
        if (Java7Reflector.isAtLeastJava7()) {
            ArrayList<PlexusIoResource> result = new ArrayList<PlexusIoResource>();
            if (this.isIncludingEmptyDirectories()) {
                String[] dirs = ds.getIncludedDirectories();
                this.addResourcesJava7(result, dirs);
            }
            String[] files = ds.getIncludedFiles();
            this.addResourcesJava7(result, files);
            return result.iterator();
        }
        Map<String, PlexusIoResourceAttributes> attributesByPath = PlexusIoResourceAttributeUtils.getFileAttributesByPath(this.getBaseDir());
        ArrayList<PlexusIoResource> result = new ArrayList<PlexusIoResource>();
        if (this.isIncludingEmptyDirectories()) {
            String[] dirs = ds.getIncludedDirectories();
            this.addResources(result, dirs, attributesByPath);
        }
        String[] files = ds.getIncludedFiles();
        this.addResources(result, files, attributesByPath);
        return result.iterator();
    }

    @Override
    public boolean isConcurrentAccessSupported() {
        return true;
    }
}

