# IBM Makefile for Persistence of Vision Raytracer for Watcom C++ for Windows
# Version 10.5
# For use with the Watcom C++ protected mode compiler on the IBM-PC.
#
# Builds the POVWAT.LIB library containing all the POV-Ray non-Windows
# specific code (excluding PNG/ZLIB etc).

# Use Watcom suggested "performance" options.
# Use /5r in place of /4r for a Pentium optimized compile.
# Use /fp5 to optimize for Pentium FPU 
#
# /zq turns on quiet mode (easier on the eyes ;-)
# /fh /fhq turns on pre-compiled headers with PCH warnings turned off
# /s turns of stack frame checking (faster)
# /bt=nt compiled for Win32

#directory macros
S=..\..\
M=..\
P=..\..\libpng\
Z=..\..\zlib\

# Ucomment the following to turn on debug information
#
# CFLAGS_DBG=/d2
# LIBFLAGS_DBG=/d128

#CFLAGS=-c-zq-bt=nt-fpi87-fp5-zp4-5r-w5-s-oneatx -i=$(S) -i=$(M) -i=$(P) -i=$(Z)
#CFLAGS=-c-zq-bt=nt-fpi87-fp3-zp4-4r-w5-s-oneatx -i=$(S) -i=$(M) -i=$(P) -i=$(Z)

CFLAGS=-c-zq-bt=nt-fpi87-fp5-zp4-5r-w4-oneatx -i=$(S) -i=$(M) -i=$(P) -i=$(Z)

C=wcl386 $(CFLAGS) $(CFLAGS_DBG)
LIB=wlib /q $(LIBFLAGS_DBG)

F1 = atmosph.obj bbox.obj bcyl.obj bezier.obj blob.obj boxes.obj bsphere.obj
F2 = camera.obj chi2.obj colour.obj cones.obj csg.obj discs.obj express.obj
F3 = gif.obj gifdecod.obj halos.obj hfield.obj iff.obj image.obj quatern.obj lathe.obj
F4 = lbuffer.obj lighting.obj matrices.obj mem.obj mesh.obj normal.obj
F5 = objects.obj octree.obj optin.obj optout.obj parse.obj parstxtr.obj
F6 = pattern.obj pgm.obj pigment.obj planes.obj png_pov.obj point.obj poly.obj
F7 = polygon.obj polysolv.obj povray.obj ppm.obj prism.obj quadrics.obj
F8 = radiosit.obj rad_data.obj ray.obj render.obj sor.obj spheres.obj super.obj
F9 = targa.obj texture.obj tokenize.obj torus.obj triangle.obj truetype.obj
F10 = txttest.obj userio.obj vbuffer.obj vlbuffer.obj warps.obj povray.obj
F11 = fractal.obj hcmplx.obj

PVOBJS = $(F1) $(F2) $(F3) $(F4) $(F5) $(F6) $(F7) $(F8) $(F9) $(F10) $(F11)

# Build the POVWAT.LIB library
#
povwat.lib : $(PVOBJS)
    $(LIB) povwat.lib @povwat.rsp

#
# Specific module/header dependencies for POV-Ray:
#

atmosph.obj : $(S)atmosph.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(S)colour.h &
  $(M)config.h $(S)frame.h $(S)lighting.h $(S)objects.h $(S)pattern.h &
  $(S)pigment.h $(S)point.h $(S)povproto.h $(S)povray.h $(S)render.h &
  $(S)texture.h $(S)vector.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)atmosph.c 

bbox.obj : $(S)bbox.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)matrices.h $(S)objects.h $(S)point.h $(S)povproto.h &
  $(S)povray.h $(S)render.h $(S)vector.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)bbox.c 

bcyl.obj : $(S)bcyl.c $(S)bcyl.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)matrices.h $(S)objects.h $(S)point.h $(S)povproto.h &
  $(S)povray.h $(S)render.h $(S)vector.h $(S)vlbuffer.h $(S)warps.h 
        $(C) $(S)bcyl.c

bezier.obj : $(S)bezier.c $(S)atmosph.h $(S)bbox.h $(S)bezier.h $(S)camera.h &
  $(M)config.h $(S)frame.h $(S)matrices.h $(S)objects.h $(S)point.h &
  $(S)povproto.h $(S)povray.h $(S)render.h $(S)vector.h $(S)vlbuffer.h &
  $(S)warps.h 
	$(C) $(S)bezier.c 

blob.obj : $(S)blob.c $(S)atmosph.h $(S)bbox.h $(S)blob.h $(S)bsphere.h &
  $(S)camera.h $(M)config.h $(S)frame.h $(S)lighting.h $(S)matrices.h &
  $(S)objects.h $(S)pattern.h $(S)point.h $(S)polysolv.h $(S)povproto.h &
  $(S)povray.h $(S)render.h $(S)texture.h $(S)vector.h $(S)vlbuffer.h &
  $(S)warps.h 
	$(C) $(S)blob.c 

boxes.obj : $(S)boxes.c $(S)atmosph.h $(S)bbox.h $(S)boxes.h $(S)camera.h &
  $(M)config.h $(S)frame.h $(S)matrices.h $(S)objects.h $(S)point.h &
  $(S)povproto.h $(S)povray.h $(S)render.h $(S)vector.h $(S)vlbuffer.h &
  $(S)warps.h 
	$(C) $(S)boxes.c 

bsphere.obj : $(S)bsphere.c $(S)bsphere.h $(M)config.h $(S)frame.h &
  $(S)povproto.h $(S)vector.h 
	$(C) $(S)bsphere.c 

camera.obj : $(S)camera.c $(S)camera.h $(M)config.h $(S)frame.h $(S)matrices.h &
  $(S)normal.h $(S)povproto.h $(S)vector.h 
	$(C) $(S)camera.c 

chi2.obj : $(S)chi2.c $(S)chi2.h $(M)config.h $(S)frame.h $(S)povproto.h 
	$(C) $(S)chi2.c 

colour.obj : $(S)colour.c $(S)colour.h $(M)config.h $(S)frame.h $(S)normal.h &
  $(S)pattern.h $(S)pigment.h $(S)povproto.h $(S)texture.h $(S)vector.h &
  $(S)warps.h 
	$(C) $(S)colour.c 

cones.obj : $(S)cones.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(S)cones.h &
  $(M)config.h $(S)frame.h $(S)matrices.h $(S)objects.h $(S)point.h &
  $(S)povproto.h $(S)povray.h $(S)render.h $(S)vector.h $(S)vlbuffer.h &
  $(S)warps.h 
	$(C) $(S)cones.c 

csg.obj : $(S)csg.c $(S)atmosph.h $(S)bbox.h $(S)boxes.h $(S)camera.h &
  $(M)config.h $(S)csg.h $(S)frame.h $(S)hfield.h $(S)matrices.h &
  $(S)objects.h $(S)planes.h $(S)point.h $(S)povproto.h $(S)povray.h &
  $(S)quadrics.h $(S)render.h $(S)vector.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)csg.c 

discs.obj : $(S)discs.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)discs.h $(S)frame.h $(S)matrices.h $(S)objects.h $(S)point.h &
  $(S)povproto.h $(S)povray.h $(S)render.h $(S)vector.h $(S)vlbuffer.h &
  $(S)warps.h 
	$(C) $(S)discs.c 

express.obj : $(S)express.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(S)colour.h &
  $(M)config.h $(S)express.h $(S)frame.h $(S)matrices.h $(S)normal.h &
  $(S)parse.h $(S)parstxtr.h $(S)pattern.h $(S)pigment.h $(S)point.h &
  $(S)povproto.h $(S)povray.h $(S)render.h $(S)texture.h $(S)tokenize.h &
  $(S)vector.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)express.c 

fractal.obj : $(S)fractal.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)fractal.h $(S)frame.h $(S)hcmplx.h $(S)quatern.h $(S)matrices.h &
  $(S)objects.h $(S)point.h $(S)povproto.h $(S)povray.h $(S)render.h &
  $(S)spheres.h $(S)vector.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)fractal.c 

gif.obj : $(S)gif.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)gif.h $(S)gifdecod.h $(S)point.h $(S)povproto.h &
  $(S)povray.h $(S)render.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)gif.c 

gifdecod.obj : $(S)gifdecod.c $(M)config.h $(S)frame.h $(S)gif.h $(S)gifdecod.h &
  $(S)povproto.h 
	$(C) $(S)gifdecod.c 

halos.obj : $(S)halos.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(S)colour.h &
  $(M)config.h $(S)frame.h $(S)halos.h $(S)lighting.h $(S)matrices.h &
  $(S)objects.h $(S)pattern.h $(S)point.h $(S)povproto.h $(S)povray.h &
  $(S)render.h $(S)texture.h $(S)vector.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)halos.c 

hcmplx.obj : $(S)hcmplx.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)fractal.h $(S)frame.h $(S)hcmplx.h $(S)point.h $(S)povproto.h &
  $(S)povray.h $(S)render.h $(S)spheres.h $(S)vector.h $(S)vlbuffer.h &
  $(S)warps.h 
	$(C) $(S)hcmplx.c 

hfield.obj : $(S)hfield.c $(S)atmosph.h $(S)bbox.h $(S)boxes.h $(S)camera.h &
  $(M)config.h $(S)frame.h $(S)hfield.h $(S)matrices.h $(S)objects.h &
  $(S)point.h $(S)povproto.h $(S)povray.h $(S)render.h $(S)vector.h &
  $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)hfield.c 

iff.obj : $(S)iff.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)iff.h $(S)point.h $(S)povproto.h $(S)povray.h $(S)render.h &
  $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)iff.c 

image.obj : $(S)image.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)image.h $(S)matrices.h $(S)pattern.h $(S)point.h &
  $(S)povproto.h $(S)povray.h $(S)render.h $(S)texture.h $(S)vector.h &
  $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)image.c 

quatern.obj : $(S)quatern.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)fractal.h $(S)frame.h $(S)quatern.h $(S)point.h $(S)povproto.h &
  $(S)povray.h $(S)render.h $(S)spheres.h $(S)vector.h $(S)vlbuffer.h &
  $(S)warps.h 
	$(C) $(S)quatern.c 

lathe.obj : $(S)lathe.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)lathe.h $(S)matrices.h $(S)objects.h $(S)point.h &
  $(S)polysolv.h $(S)povproto.h $(S)povray.h $(S)render.h $(S)torus.h &
  $(S)vector.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)lathe.c 

lbuffer.obj : $(S)lbuffer.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)lbuffer.h $(S)objects.h $(S)point.h $(S)povproto.h &
  $(S)povray.h $(S)render.h $(S)triangle.h $(S)vector.h $(S)vlbuffer.h &
  $(S)warps.h 
	$(C) $(S)lbuffer.c 

lighting.obj : $(S)lighting.c $(S)atmosph.h $(S)bbox.h $(S)blob.h &
  $(S)bsphere.h $(S)camera.h $(S)colour.h $(M)config.h $(S)frame.h &
  $(S)halos.h $(S)image.h $(S)lbuffer.h $(S)lighting.h $(S)mesh.h &
  $(S)normal.h $(S)objects.h $(S)octree.h $(S)pattern.h $(S)pigment.h &
  $(S)point.h $(S)povproto.h $(S)povray.h $(S)radiosit.h $(S)ray.h &
  $(S)render.h $(S)texture.h $(S)vector.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)lighting.c 

matrices.obj : $(S)matrices.c $(M)config.h $(S)frame.h $(S)matrices.h &
  $(S)povproto.h $(S)vector.h 
	$(C) $(S)matrices.c 

mem.obj : $(S)mem.c $(M)config.h $(S)frame.h $(S)mem.h $(S)parse.h &
  $(S)povproto.h 
	$(C) $(S)mem.c 

mesh.obj : $(S)mesh.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)matrices.h $(S)mesh.h $(S)objects.h $(S)pattern.h &
  $(S)point.h $(S)povproto.h $(S)povray.h $(S)render.h $(S)texture.h &
  $(S)vector.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)mesh.c 

normal.obj : $(S)normal.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)image.h $(S)matrices.h $(S)normal.h $(S)pattern.h &
  $(S)pigment.h $(S)point.h $(S)povproto.h $(S)povray.h $(S)render.h &
  $(S)texture.h $(S)txttest.h $(S)vector.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)normal.c 

objects.obj : $(S)objects.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)objects.h $(S)pattern.h $(S)point.h $(S)povproto.h &
  $(S)povray.h $(S)render.h $(S)texture.h $(S)vector.h $(S)vlbuffer.h &
  $(S)warps.h 
	$(C) $(S)objects.c 

octree.obj : $(S)octree.c $(M)config.h $(S)frame.h $(S)octree.h $(S)povproto.h &
  $(S)radiosit.h $(S)vector.h 
	$(C) $(S)octree.c 

optin.obj : $(S)optin.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)lighting.h $(S)mem.h $(S)octree.h $(S)optin.h $(S)optout.h &
  $(S)parse.h $(S)point.h $(S)povproto.h $(S)povray.h $(S)ppm.h &
  $(S)radiosit.h $(S)render.h $(S)targa.h $(S)tokenize.h $(S)userio.h &
  $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)optin.c 

optout.obj : $(S)optout.c $(S)atmosph.h $(S)bbox.h $(S)bezier.h $(S)blob.h &
  $(S)boxes.h $(S)bsphere.h $(S)camera.h $(S)cones.h $(M)config.h $(S)csg.h &
  $(S)discs.h $(S)fractal.h $(S)frame.h $(S)hfield.h $(S)lathe.h &
  $(S)lbuffer.h $(S)lighting.h $(S)mesh.h $(S)objects.h $(S)octree.h &
  $(S)optin.h $(S)optout.h $(S)parse.h $(S)pattern.h $(S)pgm.h $(S)planes.h &
  $(S)point.h $(S)poly.h $(S)polygon.h $(S)polysolv.h $(S)povproto.h &
  $(S)povray.h $(S)ppm.h $(S)prism.h $(S)quadrics.h $(S)radiosit.h &
  $(S)render.h $(S)sor.h $(S)spheres.h $(S)super.h $(S)targa.h $(S)texture.h &
  $(S)torus.h $(S)triangle.h $(S)truetype.h $(S)userio.h $(S)vbuffer.h &
  $(S)vector.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)optout.c 

parse.obj : $(S)parse.c $(S)atmosph.h $(S)bbox.h $(S)bezier.h $(S)blob.h &
  $(S)boxes.h $(S)bsphere.h $(S)camera.h $(S)colour.h $(S)cones.h &
  $(M)config.h $(S)csg.h $(S)discs.h $(S)express.h $(S)fractal.h $(S)frame.h &
  $(S)gif.h $(S)halos.h $(S)hfield.h $(S)iff.h $(S)image.h $(S)lathe.h &
  $(S)matrices.h $(S)mesh.h $(S)normal.h $(S)objects.h $(S)octree.h &
  $(S)parse.h $(S)parstxtr.h $(S)pattern.h $(S)pgm.h $(S)pigment.h &
  $(S)planes.h $(S)point.h $(S)poly.h $(S)polygon.h $(S)polysolv.h &
  $(S)povproto.h $(S)povray.h $(S)ppm.h $(S)prism.h $(S)quadrics.h &
  $(S)radiosit.h $(S)render.h $(S)sor.h $(S)spheres.h $(S)super.h &
  $(S)targa.h $(S)texture.h $(S)tokenize.h $(S)torus.h $(S)triangle.h &
  $(S)truetype.h $(S)vector.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)parse.c 

parstxtr.obj : $(S)parstxtr.c $(S)atmosph.h $(S)bbox.h $(S)camera.h &
  $(S)colour.h $(M)config.h $(S)express.h $(S)frame.h $(S)gif.h $(S)halos.h &
  $(S)iff.h $(S)image.h $(S)matrices.h $(S)normal.h $(S)parse.h &
  $(S)parstxtr.h $(S)pattern.h $(S)pgm.h $(S)pigment.h $(S)point.h &
  $(S)povproto.h $(S)povray.h $(S)ppm.h $(S)render.h $(S)targa.h &
  $(S)texture.h $(S)tokenize.h $(S)vector.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)parstxtr.c 

pattern.obj : $(S)pattern.c $(S)colour.h $(M)config.h $(S)frame.h $(S)image.h &
  $(S)matrices.h $(S)pattern.h $(S)povproto.h $(S)texture.h $(S)txttest.h &
  $(S)vector.h $(S)warps.h 
	$(C) $(S)pattern.c 

pgm.obj : $(S)pgm.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)pgm.h $(S)point.h $(S)povproto.h $(S)povray.h $(S)ppm.h &
  $(S)render.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)pgm.c 

pigment.obj : $(S)pigment.c $(S)colour.h $(M)config.h $(S)frame.h $(S)image.h &
  $(S)matrices.h $(S)pattern.h $(S)pigment.h $(S)povproto.h $(S)texture.h &
  $(S)txttest.h $(S)vector.h $(S)warps.h 
	$(C) $(S)pigment.c 

planes.obj : $(S)planes.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)matrices.h $(S)objects.h $(S)planes.h $(S)point.h &
  $(S)povproto.h $(S)povray.h $(S)render.h $(S)vector.h $(S)vlbuffer.h &
  $(S)warps.h 
	$(C) $(S)planes.c 

png_pov.obj : $(S)png_pov.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)optout.h $(P)png.h $(S)png_pov.h $(S)point.h &
  $(S)povproto.h $(S)povray.h $(S)render.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)png_pov.c 

point.obj : $(S)point.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)matrices.h $(S)objects.h $(S)point.h $(S)povproto.h &
  $(S)povray.h $(S)render.h $(S)vector.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)point.c 

poly.obj : $(S)poly.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)matrices.h $(S)objects.h $(S)point.h $(S)poly.h &
  $(S)polysolv.h $(S)povproto.h $(S)povray.h $(S)render.h $(S)vector.h &
  $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)poly.c 

polygon.obj : $(S)polygon.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)matrices.h $(S)objects.h $(S)point.h $(S)polygon.h &
  $(S)povproto.h $(S)povray.h $(S)render.h $(S)vector.h $(S)vlbuffer.h &
  $(S)warps.h 
	$(C) $(S)polygon.c 

polysolv.obj : $(S)polysolv.c $(S)atmosph.h $(S)bbox.h $(S)camera.h &
  $(M)config.h $(S)frame.h $(S)point.h $(S)polysolv.h $(S)povproto.h &
  $(S)povray.h $(S)render.h $(S)vector.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)polysolv.c 

povray.obj : $(S)povray.c $(S)atmosph.h $(S)bbox.h $(S)bcyl.h $(S)bezier.h $(S)blob.h &
  $(S)boxes.h $(S)bsphere.h $(S)camera.h $(S)cones.h $(M)config.h $(S)csg.h &
  $(S)discs.h $(S)fractal.h $(S)frame.h $(S)hfield.h $(S)lathe.h &
  $(S)lbuffer.h $(S)lighting.h $(S)mem.h $(S)mesh.h $(S)objects.h &
  $(S)octree.h $(S)optin.h $(S)optout.h $(S)parse.h $(S)pattern.h $(S)pgm.h &
  $(S)planes.h $(S)png_pov.h $(S)point.h $(S)poly.h $(S)polygon.h &
  $(S)polysolv.h $(S)povproto.h $(S)povray.h $(S)ppm.h $(S)prism.h &
  $(S)quadrics.h $(S)radiosit.h $(S)render.h $(S)sor.h $(S)spheres.h &
  $(S)super.h $(S)targa.h $(S)texture.h $(S)tokenize.h $(S)torus.h &
  $(S)triangle.h $(S)truetype.h $(S)userio.h $(S)vbuffer.h $(S)vlbuffer.h &
  $(S)warps.h 
	$(C) $(S)povray.c 

ppm.obj : $(S)ppm.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)pgm.h $(S)point.h $(S)povproto.h $(S)povray.h $(S)ppm.h &
  $(S)render.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)ppm.c 

prism.obj : $(S)prism.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)matrices.h $(S)objects.h $(S)point.h $(S)polysolv.h &
  $(S)povproto.h $(S)povray.h $(S)prism.h $(S)render.h $(S)vector.h &
  $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)prism.c 

quadrics.obj : $(S)quadrics.c $(S)atmosph.h $(S)bbox.h $(S)camera.h &
  $(M)config.h $(S)frame.h $(S)matrices.h $(S)objects.h $(S)planes.h &
  $(S)point.h $(S)povproto.h $(S)povray.h $(S)quadrics.h $(S)render.h &
  $(S)vector.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)quadrics.c 

radiosit.obj : $(S)radiosit.c $(S)atmosph.h $(S)bbox.h $(S)camera.h &
  $(M)config.h $(S)frame.h $(S)octree.h $(S)optin.h $(S)pattern.h $(S)point.h &
  $(S)povproto.h $(S)povray.h $(S)radiosit.h $(S)render.h $(S)texture.h &
  $(S)vector.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)radiosit.c 

rad_data.obj : $(S)rad_data.c $(M)config.h $(S)frame.h $(S)octree.h &
  $(S)povproto.h $(S)radiosit.h 
	$(C) $(S)rad_data.c 

ray.obj : $(S)ray.c $(M)config.h $(S)frame.h $(S)povproto.h $(S)ray.h &
  $(S)vector.h 
	$(C) $(S)ray.c 

render.obj : $(S)render.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(S)chi2.h &
  $(S)colour.h $(M)config.h $(S)frame.h $(S)lighting.h $(S)normal.h &
  $(S)objects.h $(S)octree.h $(S)optout.h $(S)pattern.h $(S)point.h &
  $(S)povproto.h $(S)povray.h $(S)radiosit.h $(S)ray.h $(S)render.h &
  $(S)targa.h $(S)texture.h $(S)userio.h $(S)vbuffer.h $(S)vector.h &
  $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)render.c 

sor.obj : $(S)sor.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)matrices.h $(S)objects.h $(S)point.h $(S)polysolv.h &
  $(S)povproto.h $(S)povray.h $(S)render.h $(S)sor.h $(S)vector.h &
  $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)sor.c 

spheres.obj : $(S)spheres.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)matrices.h $(S)objects.h $(S)point.h $(S)povproto.h &
  $(S)povray.h $(S)render.h $(S)spheres.h $(S)vector.h $(S)vlbuffer.h &
  $(S)warps.h 
	$(C) $(S)spheres.c 

super.obj : $(S)super.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)matrices.h $(S)objects.h $(S)point.h $(S)povproto.h &
  $(S)povray.h $(S)render.h $(S)super.h $(S)vector.h $(S)vlbuffer.h &
  $(S)warps.h 
	$(C) $(S)super.c 

targa.obj : $(S)targa.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)point.h $(S)povproto.h $(S)povray.h $(S)render.h &
  $(S)targa.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)targa.c 

texture.obj : $(S)texture.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)halos.h $(S)image.h $(S)matrices.h $(S)normal.h &
  $(S)pattern.h $(S)pigment.h $(S)point.h $(S)povproto.h $(S)povray.h &
  $(S)render.h $(S)texture.h $(S)vector.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)texture.c 

tokenize.obj : $(S)tokenize.c $(S)atmosph.h $(S)bbox.h $(S)camera.h &
  $(M)config.h $(S)express.h $(S)frame.h $(S)parse.h $(S)point.h &
  $(S)povproto.h $(S)povray.h $(S)render.h $(S)tokenize.h $(S)vlbuffer.h &
  $(S)warps.h 
	$(C) $(S)tokenize.c 

torus.obj : $(S)torus.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)matrices.h $(S)objects.h $(S)point.h $(S)polysolv.h &
  $(S)povproto.h $(S)povray.h $(S)render.h $(S)torus.h $(S)vector.h &
  $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)torus.c 

triangle.obj : $(S)triangle.c $(S)atmosph.h $(S)bbox.h $(S)camera.h &
  $(M)config.h $(S)frame.h $(S)matrices.h $(S)objects.h $(S)point.h &
  $(S)povproto.h $(S)povray.h $(S)render.h $(S)triangle.h $(S)vector.h &
  $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)triangle.c 

truetype.obj : $(S)truetype.c $(S)atmosph.h $(S)bbox.h $(S)camera.h &
  $(M)config.h $(S)csg.h $(S)frame.h $(S)matrices.h $(S)objects.h &
  $(S)point.h $(S)povproto.h $(S)povray.h $(S)render.h $(S)truetype.h &
  $(S)vector.h $(S)vlbuffer.h $(S)warps.h 
	$(C) $(S)truetype.c 

txttest.obj : $(S)txttest.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)pattern.h $(S)point.h $(S)povproto.h $(S)povray.h &
  $(S)render.h $(S)texture.h $(S)txttest.h $(S)vector.h $(S)vlbuffer.h &
  $(S)warps.h 
	$(C) $(S)txttest.c 

userio.obj : $(S)userio.c $(S)atmosph.h $(S)bbox.h $(S)camera.h $(M)config.h &
  $(S)frame.h $(S)parse.h $(S)point.h $(S)povproto.h $(S)povray.h &
  $(S)render.h $(S)tokenize.h $(S)userio.h $(S)vector.h $(S)vlbuffer.h &
  $(S)warps.h 
	$(C) $(S)userio.c 

vbuffer.obj : $(S)vbuffer.c $(S)atmosph.h $(S)bbox.h $(S)boxes.h $(S)camera.h &
  $(M)config.h $(S)frame.h $(S)hfield.h $(S)lighting.h $(S)matrices.h &
  $(S)objects.h $(S)point.h $(S)povproto.h $(S)povray.h $(S)render.h &
  $(S)triangle.h $(S)userio.h $(S)vbuffer.h $(S)vector.h $(S)vlbuffer.h &
  $(S)warps.h 
	$(C) $(S)vbuffer.c 

vlbuffer.obj : $(S)vlbuffer.c $(S)bbox.h $(M)config.h $(S)frame.h &
  $(S)povproto.h $(S)vector.h $(S)vlbuffer.h 
	$(C) $(S)vlbuffer.c 

warps.obj : $(S)warps.c $(M)config.h $(S)frame.h $(S)matrices.h $(S)pattern.h &
  $(S)povproto.h $(S)texture.h $(S)vector.h $(S)warps.h 
	$(C) $(S)warps.c 
