/****************************************************************************
*
*  POVLangDef.h
*
*  This file is part of the CodeMax editor support code.
*
*  Copyright  POV-Team(tm) 1996-1998. All Rights Reserved.
*  This windows version of POV-Ray is Copyright 1996-1998 Christopher J. Cason.
*  Author : Christopher J. Cason.
*
*  NOTE : As this is Windows code, it was edited using a wide Windows-hosted
*         editor. Accordingly, expect text to exceed 80 columns regularly.
*
*  from Persistence of Vision Raytracer(tm)
*  Copyright 1996-1998 Persistence of Vision Team
*
* The terms POV-Ray, POV, and Persistence of Vision Raytracer are trademarks
* of the Persistence of Vision Team.
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray(tm) and to port the software to platforms other
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file. If
*  POVLEGAL.DOC is not available or for more info please contact the POV-Ray(tm)
*  Team Coordinator by leaving a message in CompuServe's POVRAY forum. The
*  The latest version of POV-Ray may be found there as well. POVRAY files can
*  also be found on the world wide web at http://www.povray.org/.
*
*  In the case of this particular program, POVLEGAL.DOC is also embedded
*  in the source code. See the file ../PVLEGAL.H.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
* Thanks to the makers of PERFORCE (http://www.perforce.com/) for donating the
* copy of their Perforce revision control system that is now used to maintain
* the POVWIN source. Thanks also to WinMain Software (http://www.winmain.com/)
* for providing the CodeMax edit control which the POVWIN 3.1 editor is based
* upon.
*
* $Id: //depot/windows/codemax/POVLangDef.h#1 $
*
*****************************************************************************/

CM_LANGUAGE LangPOVRay =
{
  true,                 // case-sensitive flag
  "abs\n"               // keywords
  "absorption\n"
  "acos\n"
  "acosh\n"
  "adaptive\n"
  "adc_bailout\n"
  "agate\n"
  "agate_turb\n"
  "all\n"
  "alpha\n"
  "ambient\n"
  "ambient_light\n"
  "angle\n"
  "aperture\n"
  "append\n"
  "arc_angle\n"
  "area_light\n"
  "array\n"
  "asc\n"
  "asin\n"
  "asinh\n"
  "assumed_gamma\n"
  "atan\n"
  "atan2\n"
  "atanh\n"
  "average\n"
  "background\n"
  "bezier_spline\n"
  "bicubic_patch\n"
  "black_hole\n"
  "blob\n"
  "blue\n"
  "blur_samples\n"
  "bounded_by\n"
  "box\n"
  "boxed\n"
  "bozo\n"
  "break\n"
  "brick\n"
  "brick_size\n"
  "brightness\n"
  "brilliance\n"
  "bumps\n"
  "bump_map\n"
  "bump_size\n"
  "camera\n"
  "case\n"
  "caustics\n"
  "ceil\n"
  "checker\n"
  "chr\n"
  "clipped_by\n"
  "clock\n"
  "clock_delta\n"
  "color\n"
  "color_map\n"
  "colour\n"
  "colour_map\n"
  "component\n"
  "composite\n"
  "concat\n"
  "cone\n"
  "confidence\n"
  "conic_sweep\n"
  "control0\n"
  "control1\n"
  "cos\n"
  "cosh\n"
  "count\n"
  "crackle\n"
  "crand\n"
  "cube\n"
  "cubic\n"
  "cubic_spline\n"
  "cubic_wave\n"
  "cylinder\n"
  "cylindrical\n"
  "debug\n"
  "declare\n"
  "default\n"
  "defined\n"
  "degrees\n"
  "density\n"
  "density_file\n"
  "density_map\n"
  "dents\n"
  "difference\n"
  "diffuse\n"
  "dimensions\n"
  "dimension_size\n"
  "direction\n"
  "disc\n"
  "distance\n"
  "distance_maximum\n"
  "div\n"
  "eccentricity\n"
  "else\n"
  "emission\n"
  "end\n"
  "error\n"
  "error_bound\n"
  "exp\n"
  "extinction\n"
  "fade_distance\n"
  "fade_power\n"
  "falloff\n"
  "falloff_angle\n"
  "false\n"
  "fclose\n"
  "file_exists\n"
  "filter\n"
  "finish\n"
  "fisheye\n"
  "flatness\n"
  "flip\n"
  "floor\n"
  "focal_point\n"
  "fog\n"
  "fog_alt\n"
  "fog_offset\n"
  "fog_type\n"
  "fopen\n"
  "frequency\n"
  "gif\n"
  "global_settings\n"
  "gradient\n"
  "granite\n"
  "gray_threshold\n"
  "green\n"
  "height_field\n"
  "hexagon\n"
  "hf_gray_16\n"
  "hierarchy\n"
  "hollow\n"
  "hypercomplex\n"
  "if\n"
  "ifdef\n"
  "iff\n"
  "ifndef\n"
  "image_map\n"
  "include\n"
  "int\n"
  "interior\n"
  "interpolate\n"
  "intersection\n"
  "intervals\n"
  "inverse\n"
  "ior\n"
  "irid\n"
  "irid_wavelength\n"
  "jitter\n"
  "julia_fractal\n"
  "lambda\n"
  "lathe\n"
  "leopard\n"
  "light_source\n"
  "linear_spline\n"
  "linear_sweep\n"
  "local\n"
  "location\n"
  "log\n"
  "looks_like\n"
  "look_at\n"
  "low_error_factor\n"
  "macro\n"
  "mandel\n"
  "map_type\n"
  "marble\n"
  "material\n"
  "material_map\n"
  "matrix\n"
  "max\n"
  "max_intersections\n"
  "max_iteration\n"
  "max_trace_level\n"
  "media\n"
  "media_attenuation\n"
  "media_interaction\n"
  "merge\n"
  "mesh\n"
  "metallic\n"
  "min\n"
  "minimum_reuse\n"
  "mod\n"
  "mortar\n"
  "nearest_count\n"
  "no\n"
  "normal\n"
  "normal_map\n"
  "no_shadow\n"
  "number_of_waves\n"
  "object\n"
  "octaves\n"
  "off\n"
  "offset\n"
  "omega\n"
  "omnimax\n"
  "on\n"
  "once\n"
  "onion\n"
  "open\n"
  "orthographic\n"
  "panoramic\n"
  "perspective\n"
  "pgm\n"
  "phase\n"
  "phong\n"
  "phong_size\n"
  "pi\n"
  "pigment\n"
  "pigment_map\n"
  "planar\n"
  "plane\n"
  "png\n"
  "point_at\n"
  "poly\n"
  "polygon\n"
  "poly_wave\n"
  "pot\n"
  "pow\n"
  "ppm\n"
  "precision\n"
  "prism\n"
  "pwr\n"
  "quadratic_spline\n"
  "quadric\n"
  "quartic\n"
  "quaternion\n"
  "quick_color\n"
  "quick_colour\n"
  "quilted\n"
  "radial\n"
  "radians\n"
  "radiosity\n"
  "radius\n"
  "rainbow\n"
  "ramp_wave\n"
  "rand\n"
  "range\n"
  "ratio\n"
  "read\n"
  "reciprocal\n"
  "recursion_limit\n"
  "red\n"
  "reflection\n"
  "reflection_exponent\n"
  "refraction\n"
  "render\n"
  "repeat\n"
  "rgb\n"
  "rgbf\n"
  "rgbft\n"
  "rgbt\n"
  "right\n"
  "ripples\n"
  "rotate\n"
  "roughness\n"
  "samples\n"
  "scale\n"
  "scallop_wave\n"
  "scattering\n"
  "seed\n"
  "shadowless\n"
  "sin\n"
  "sine_wave\n"
  "sinh\n"
  "sky\n"
  "sky_sphere\n"
  "slice\n"
  "slope_map\n"
  "smooth\n"
  "smooth_triangle\n"
  "sor\n"
  "specular\n"
  "sphere\n"
  "spherical\n"
  "spiral1\n"
  "spiral2\n"
  "spotlight\n"
  "spotted\n"
  "sqr\n"
  "sqrt\n"
  "statistics\n"
  "str\n"
  "strcmp\n"
  "strength\n"
  "strlen\n"
  "strlwr\n"
  "strupr\n"
  "sturm\n"
  "substr\n"
  "superellipsoid\n"
  "switch\n"
  "sys\n"
  "t\n"
  "tan\n"
  "tanh\n"
  "text\n"
  "texture\n"
  "texture_map\n"
  "tga\n"
  "thickness\n"
  "threshold\n"
  "tightness\n"
  "tile2\n"
  "tiles\n"
  "torus\n"
  "track\n"
  "transform\n"
  "translate\n"
  "transmit\n"
  "triangle\n"
  "triangle_wave\n"
  "true\n"
  "ttf\n"
  "turbulence\n"
  "turb_depth\n"
  "type\n"
  "u\n"
  "ultra_wide_angle\n"
  "undef\n"
  "union\n"
  "up\n"
  "use_color\n"
  "use_colour\n"
  "use_index\n"
  "u_steps\n"
  "v\n"
  "val\n"
  "variance\n"
  "vaxis_rotate\n"
  "vcross\n"
  "vdot\n"
  "version\n"
  "vlength\n"
  "vnormalize\n"
  "vrotate\n"
  "v_steps\n"
  "warning\n"
  "warp\n"
  "water_level\n"
  "waves\n"
  "while\n"
  "width\n"
  "wood\n"
  "wrinkles\n"
  "write\n"
  "x\n"
  "y\n"
  "yes\n"
  "z\n"
  "#",
  "+\n-\n*\n/\n=\n"     // operators
  "<\n>\n<=\n>=\n"
  "!=\n&\n|\n!\n"
  "?\n:\n",
  "//",                 // single line comment
  "/*",                 // multiline comment 1
  "*/",                 // multiline comment 2
  "{",                  // scope keywords 1
  "}",                  // scope keywords 2
  "\"",                 // string delimiters
  '\\',                 // escape character
  ';'                   // statement terminator
} ;


