//	Persistence of Vision Ray Tracer Sample File
//	File: bounds_text.pov
//	Date: 20/09/99
// Demo showing the use of the bound patch and text alignment.
 
#version unofficial MegaPov 0.4;

#default { texture { pigment { color rgb < 1, 0, 0 > } finish { ambient 0.4 } } }

global_settings { assumed_gamma 1.8 }

//********** declared object ******************
#declare Text =
	text { ttf "crystal.ttf", "EXTENT", 4, 0.1*x
		position 0			//change postion to align text. 0=left, 1=centered, 2=right
		pigment { color rgb <1, 0.2, 0.2> }
		finish { phong 0.6 phong_size 400
		}
		scale <1, 3, 0.4>
	}
	
object { Text }

//************ axis ************************
cylinder {
	<0.0, -10, 0.3>, < 0.0,10, 0.3 >, 0.05
	pigment { rgb <0.0, 0.0, 1.0> }
}
cylinder {
	< -10, 0.0, 0.3>, <10.0, 0.0, 0.3 >, 0.05
	pigment { rgb <0.0, 0.0, 1.0> }
}

//************** text holder *****************
box {
	min_extent (Text)+<0, 0, 0.1>, max_extent(Text)
	pigment { rgb <1.0, 1.0, 0.0> }
}


background { color rgb 0.7 }

light_source {<20, 30, -100> rgb <1.0, 1.0, 1.0> }

camera {
	location  <(min_extent (Text).x+max_extent(Text).x)/2, (min_extent (Text).y+max_extent(Text).y)/2,-8>
	up  image_height *y
	right  image_width *x
	look_at   <(min_extent (Text).x+max_extent(Text).x)/2, (min_extent (Text).y+max_extent(Text).y)/2, 0>
	angle 30
}

