//	Persistence of Vision Ray Tracer Scene Description File
#version unofficial MegaPov 0.4;

/*******************************************************************

Splash.pov

Splash screen demonstrating the features of the MegaPatch.

*******************************************************************/

/***************************** 
This scene can take a long time
to render.  Change some of these
options to speed things up.
******************************/
                    
// set this to true to use diffuse only textures
#declare fast=false;

// control reflection blur
#declare refl_blur=true;

// control dispersion
#declare disp=true;

// control photons
// (photons are only shot at the clear isosurface,
// not the reflective sphere
#declare phot=true;
#declare phd=.8;  // photon spacing multiplier
#declare refl=true;  // do photons get reflected?  

// control radiosity
#declare rad=true;
#declare high_quality=yes;  // if not high-quality, uses medium quality

// turn on/off motion blur for top sphere
#declare mot_blur=true;

/***************************** 
******************************/

#include "colors.inc"

/***************************** 
Color spectrum macro for photon
dispersion.
******************************/

#macro create_spectrum(nelems,bright)

#local elem=1;

color_map{

#while(elem<=nelems)

  /* h goes from 0 at red end to 1.0 at blue end */
  #local h = (elem-1)/(nelems-1);

  /* co-h goes from 1.0 at red end to 0.0 at blue end */
  #local coh = 1.0 - h; 
  
  #local Huered = 0.9 - (h/0.5);
  #local Hueblue = 1.0 - (coh/0.6);
  
  #if (Huered < 0.0) #local Huered = 0.0; #end
  #if (Hueblue < 0.0)  #local Hueblue = 0.0; #end

  #local Huered=1.0 - (1.0-Huered)*(1.0-Huered);  
  #local Hueblue=1.0 - (1.0-Hueblue)*(1.0-Hueblue);

  #local Huegreen = 1.0 - Huered - Hueblue;

/*
  #if (h>0.85)
    #local Huered = 4*(h-0.85);
  #end
*/
  
  #local ybulge =  -4.0*(h-0.1)*(h-0.6);
  #if (ybulge<0) #local ybulge=0; #end
  
  #local Huered = Huered+ybulge;// * 0.5; // added * 0.5
  #local Huegreen = Huegreen+ybulge;
  
  [bright, color rgb<Huered,Huegreen,Hueblue>]
  //#debug concat("<",str(Huered,0,3),",",str(Huegreen,0,3),",",str(Hueblue,0,3),">\n")
  
  
  #local elem=elem+1;
#end // while
}
#end // macro

/***************************** 
global settings
******************************/

global_settings
{
  assumed_gamma 1.0
#if(rad)
#if(high_quality)        
  // High Quality - slow rendering
  ini_option "+QR"
  ini_option "Preview_Start_Size=8"  // no reason to waste time at 16
  ini_option "Preview_End_Size=8"
  
  radiosity{
    count 50             // CHANGE range from 20 to 150 (higher is usually pointless)
    nearest_count 5      // CHANGE range from 3 to 10   (higher is usually pointless)
    error_bound 1        // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
                         //   1 : preview_end_size = 4
                         //   3 : preview_end_size = 8
                         //   use preview_start_size = 16
                         // you can go lower than 1, but then you probably will want to set
                         // preview_end_size to 2, which is really slow
    recursion_limit 4    // CHANGE
    
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 1.25         // exaggerated
    
    max_sample 2         // CHANGE - this should be the same as the brightest object
    adc_bailout 0.01/2   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
  }
#else
  // Medium Quality - works for most scenes
  ini_option "+QR"
  ini_option "Preview_Start_Size=8"
  ini_option "Preview_End_Size=8"
  
  radiosity{
    count 35             // CHANGE range from 20 to 150 (higher is usually pointless)
    nearest_count 5      // CHANGE range from 3 to 10   (higher is usually pointless)
    error_bound 2.0     // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
                         //   1 : preview_end_size = 4
                         //   3 : preview_end_size = 8
                         //   use preview_start_size = 16
                         // you can go lower than 1, but then you probably will want to set
                         // preview_end_size to 2, which is really slow
    recursion_limit 2    // CHANGE
    
    low_error_factor .5  // leave this
    gray_threshold 0.0   // leave this
    minimum_reuse 0.015  // leave this
    brightness 2         // exaggerated
    
    max_sample 2         // CHANGE - this should be the same as the brightest object
    adc_bailout 0.01/2   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
  }
#end
#end

#if(phot)
  photons {
    count 20000
    gather 20, 100
//#if(disp)
//    radius .05*phd*sqrt(20), 2
//    $phd=phd*2 // adjust phd for dispersion
//#else
//    radius .05*phd*sqrt(20), 2
//#end
    autostop 0
    jitter .9
    //range_divider 2000
    //save_file "splash.ph"
  }
#end  

  motion_blur 8,.1
}

#default{finish{ ambient 0 }}


// ----------------------------------------
camera
{
  location  <0.0, 0.5, -4.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source
{
  0*x // light's position (translated below)
  color rgb<1,1,1>*6
  translate <1.8,1.3,-0.1>
  fade_power 2
  fade_distance .3
#if(disp)
  create_spectrum(8,6)
#end
}

/*
sphere{
  0,.15
  pigment{rgb<1,1,1>}
  finish{ambient 1}
  translate <1.8,1.4,-0.1>
  no_shadow
}
*/

#declare wall_tex =
  texture
  {
    pigment {checker color rgb 1 color blue 1 scale 0.5}
    finish {
      diffuse .8
      ambient 0
      phong 0
      specular 0
    }
  }
#declare wall_tex2 =
  texture
  {
    pigment {color red 1 scale 0.5}
    finish {
      diffuse .8
      ambient 0
      phong 0
      specular 0
    }
  }
#declare wall_tex3 =
  texture
  {
    pigment {color green 1 scale 0.5}
    finish {
      diffuse .8
      ambient 0
      phong 0
      specular 0
    }
  }

// ----------------------------------------
plane
{
  y, -1
  texture{wall_tex}
}
// ----------------------------------------
plane
{
  -y, -1.5
  texture{wall_tex}
}
// ----------------------------------------
plane
{
  x, -2
  texture{wall_tex2}
}
// ----------------------------------------
plane
{
  -x, -2
  texture{wall_tex3}
}
// ----------------------------------------
plane
{
  -z, -2
  texture{wall_tex}
}

sphere { 
  0.0, 1 
#if(fast)  
  texture{
    pigment{rgb<0,0,1>}
    finish{diffuse .9 ambient 0}
  }
#else
  material{
    texture{
      pigment{ rgb<1,1,1> }
      finish{ 
        diffuse .05
        ambient 0
        reflection .9 reflection_type 1
        #if(refl_blur)
        reflection_blur .04
        reflection_samples 5
        #end
        }
    }
    
    interior{
      ior 5
    }
  }
#end
  scale .5
  translate <-1,-.5,0>
}

//sphere { 
//  0.0, 1 
isosurface{
  function{x*x+y*y+z*z+noise3d(4*x,.1*y,.1*z)*.3}
  threshold 1
  contained_by {sphere {0,1.3} }

#if(fast)  
  texture{
    pigment{rgb<1,0,0>}
    finish{diffuse .9 ambient 0}
  }
#else
  material{
    texture{
      pigment{ rgbf<1,1,1,.9> }
      finish{
        diffuse 0 
        ambient 0
        reflection .1 
        reflection_type 1
        }
    }
    
    interior{
      ior 1.5
      fade_power 1000
      fade_distance 1
      fade_color <.5,.5,.5>
      #if(disp)
      dispersion 1.1
      disp_nelems 5
      #end
    }
  }
#end
  scale .5
  translate <1,-.5,0>
#if(phot)
  photons {
	target 1.0
    refraction on
#if(refl)
    reflection on
#end
    ignore_photons
  }
#end
}


#declare moving_sph=
sphere { 
  0.0, 1 
  texture{
    pigment{rgb<1,1,1>}
    finish{diffuse .9 ambient 0
      phong 1
      }
  }
  scale .3
  translate .5*y
}

#if(mot_blur)
motion_blur{
  object{moving_sph}
  translate clock*x
}
#else
object{moving_sph}
#end
