//	Persistence of Vision Ray Tracer Scene Description File
//	File: triangular_pattern.pov
//	Date: 15/11/99
//	Demo showing the triangular pattern
	
#version unofficial MegaPov 0.4;


#include "colors.inc"
#include "woods.inc"
#include "stones.inc"

camera { location <1, 6, -4> look_at 0 }

plane {
	y,0
	pigment { triangular }
//	finish { ambient 1 }
}

light_source { <0,100,-100> rgb <1, 1, 1> }

sphere {
	<0, 2, 0>, 1
	uv_mapping
	texture{
		triangular
		#declare Temp_Vers = version;
		#version 3.1;

		texture{ T_Wood1 }
		texture{ T_Wood2 }
		texture{ T_Wood4 }
		texture{ T_Wood8 }
		texture{ T_Wood16 }
		texture{ T_Wood10 }
		#version Temp_Vers;
		rotate<90,0,0>
		scale 0.25
	}
}

cone { <0,1,-2>,1,<0,3,-2>,0
 pigment{ triangular
  pigment { Aquamarine }
  pigment { Turquoise }
  pigment { Sienna }
  pigment { Aquamarine }
  pigment { Turquoise }
  pigment { SkyBlue }
  //rotate <45,0,0>
  scale 0.1
}
}

cylinder { <3,1,0>,<3,3,0>,1
 texture { triangular
  texture {   T_Stone16 }
  texture {   T_Stone1 }
  texture {  pigment {  Aquamarine } }
  texture {    T_Stone21 }
  texture {    T_Stone24 }
  texture {    T_Stone27 }
  rotate <120,30,10>
  scale 1/3
}
}

box {
<-3,1,-1>,<-2,2,1>
uv_mapping
 texture { pigment { triangular 
    pigment { Red }
    pigment { Green }
    pigment { Blue }
    pigment { Red }
    pigment { Green }
    pigment { Blue }
   rotate <60,30,70>
  scale 1/4
 }
}
}
