//	Persistence of Vision Ray Tracer Scene Description File
#version unofficial MegaPov 0.4;
 
 camera {
    //location <2, 8, -19>
    //look_at <2, 5, 0>
    location <-10, 8, -19>
    look_at <0, 5, 0>
    angle 75
  }

  background { color rgb <0.2, 0.4, 0.8> }

  light_source { <0, 19, 0> color rgb 0.5 media_interaction off 
    media_attenuation off
    }

  light_source {
    <40, 25, 0> color rgb <1, 1, 1>
    spotlight
    point_at <0, 5, 0>
    radius 20
    falloff 20
    media_interaction on
    media_attenuation on
  }

  union {
    difference {
      box { <-21, -1, -21>, <21, 21, 21> }
      box { <-20, 0, -20>, <20, 20, 20> }
      box { <19.9, 5, -3>, <21.1, 15, 3> }
    }
    box { <20, 5, -0.25>, <21, 15, 0.25> }
    box { <20, 9.775, -3>, <21, 10.25, 3> }
    pigment { color red 1 green 1 blue 1 }
    finish { ambient 0.2 diffuse 0.5 }

 
  }

box {
  <-21, -1, -21>, <21, 21, 21>
  pigment { rgbf<1,1,1,1> }
  finish { ambient 0 diffuse 0 }
    
  interior{
    media {
      scattering{1, .2 extinction .17}

#declare Method=3;      

#if(Method=1)      
      method 1
      //samples 40,40
      samples 4,10
      intervals 10
      variance 1/256
      confidence 0.95
#else
#if(Method=2)
      method 2
      //samples 50,50
      samples 40,40
      intervals 1
      jitter 0.5
#else
      method 3
      samples 20, 20
      //samples 19,19
      intervals 5
      aa_level 4
      aa_threshold .1
      jitter 0.3
#end
#end

    }
  }
  hollow
} 
