//	Persistence of Vision Ray Tracer Scene Description File
#version unofficial MegaPov 0.4;

#declare S=10; // data sample sizes
#declare MyDataArray=array[S][S][S]

// A routine to fill the array with data 
#local xi=0; #while(xi<S) #local yi=0; #while(yi<S) #local zi=0; #while(zi<S) 
   #declare xx=2*pi*xi/S; #declare yy=2*pi*yi/S; #declare zz=2*pi*zi/S; 
   #declare MyDataArray[xi][yi][zi]=-(sin(xx)*cos(yy)+sin(yy)*cos(zz)+sin(zz)*cos(xx));
#local zi=zi+1; #end #local yi=yi+1; #end #local xi=xi+1; #end

// Define the function as "odd_sphere"
#declare MyDataFunction =
function{ "odd_sphere", <1,-.2,.1> library "i_dat3d", MyDataArray, <S,S,S>}

// Use the function as a color map
#declare IsoColors=
pigment {
	function {MyDataFunction}
	color_map {
		[0.0, 0.2 color <1.4, 1.0, 0.8> color <1.4, 1.4,0.6>]
		[0.2, 0.4 color <1.4, 1.4, 0.6> color <0.4, 1.4,1.4>]
		[0.4, 0.5 color <0.4, 1.4, 1.4> color <0.6, 0.6,0.7>]
		[0.5, 0.7 color <0.6, 0.6, 0.7> color <1.1, 0.4,1.3>]
		[0.7, 0.9 color <1.1, 0.4, 1.3> color <1.4, 0.8,0.8>] 
		[0.9, 1.02 color <1.4, 0.8, 0.8> color <1.4, 1.0,0.8>] 
	}
	frequency 3
}

isosurface {
	function {MyDataFunction} 
	contained_by { sphere {0, S*1.3}}
	threshold 0
	max_gradient 1.2
	texture {pigment {IsoColors} finish {phong 0.5 ambient .2} }
	scale 10/S
}

camera { location <26, 14, 15> look_at <0,0,0>}

light_source {<240, 180, 150> color 1}

background {color .3}