// Persistence Of Vision raytracer version 3.1e (isosurface patch)
// sample file by R.Suzuki   <rsuzuki@etl.go.jp>  Apr.'99
#version unofficial MegaPov 0.4;

#include "isocom.inc"
camera {
	location <30, 25, -45>
	angle 25
	look_at <0, 0, 0>
}


#declare L0=1;
#declare L1=0.08;

#declare Count=5;
#while (Count>0)  
  isosurface
  {
     function {"mesh1",<1/Count,1/Count,1,0,1>}
     contained_by{ box {<-L0,-L1, -L0>,<L0,L1,L0>}}
     threshold 0.05 
     eval 
     texture {ComYw}
     translate <-1.25-2.5,Count*1.2-3.6,0> 
     no_shadow      
     scale 2.4
  }
  #declare Count=Count-1;
#end

#declare Count=5;
#while (Count>0)  
  isosurface
  {
     function {"mesh1",<0.25,0.25,1,(Count-1)*0.025,1>}
     contained_by{ box {<-L0,-L1, -L0>,<L0,L1,L0>}}
     threshold 0.05 
     eval 
     texture {ComYw}
     translate <-1.25,Count*1.2-3.6,0> 
     no_shadow      
     scale 2.4
  }
  #declare Count=Count-1;
#end


#declare Count=5;
#while (Count>0)  
  isosurface
  {
     function {"mesh1",<0.5,0.5,Count*0.3,0.025,1>}
     contained_by{ box {<-L0,-L1, -L0>,<L0,L1,L0>}}
     threshold 0.05 
     eval 
     texture {ComYw}
     translate <1.25,Count*1.2-3.6,0> 
     no_shadow      
     scale 2.4
  }
  #declare Count=Count-1;
#end

#declare Count=5;
#while (Count>0)  
  isosurface
  {
     function {"mesh1",<0.5,0.5,1,0.025,Count*0.3>}
     contained_by{ box {<-L0,-L1*3, -L0>,<L0,L1*3,L0>}}
     threshold 0.05 
     eval 
     texture {ComYw}
     translate <1.25+2.5,Count*1.2-3.6,0> 
     no_shadow      
     scale 2.4
  }
  #declare Count=Count-1;
#end



