//	Persistence of Vision Ray Tracer Scene Description File
// Needs Isoblob patch.
//	File: isoblob_mace.pov
//	Date: 14/11/99
//	Isoblob example scene
#version unofficial MegaPov 0.4;

#include "colors.inc"
#include "textures.inc"
global_settings {
	assumed_gamma 1.8
	ini_option concat("Height=",str(image_width,0,0)) //force ratio to 1/1
}

camera {
	perspective 
	location <0.0, 0.0, -8>
	up y*image_height right x*image_width
	angle 55
	look_at <0.0, 0.0, 0.0>
}

light_source { <-5, 6, -10> rgb <1.0, 1.0, 1.0>*1.2 }

isoblob {
	threshold 0.2*0.2
	accuracy 0.00001
	max_trace 15
	//normal
	
	function {sqr(max(1-sqrt(sqr(x)+sqr(y)+sqr(z)),0))}
	function {sqr(max(1-(z+3*(sqrt(sqr(x)+sqr(y)))),0))}
	
	sphere {<0,0,0>, 0.9 strength 1 function 1}

	#declare Spread = 0.4;
	#declare mintheta = 0;
	#declare maxtheta = pi;
	#declare theta=mintheta;
	#declare dtheta = atan2(Spread,1);
	#while(theta<maxtheta)
		#if(theta=0)
			#declare dphi=2*pi;
		#else
			#declare dphi=dtheta/sin(theta);
		#end
		#declare minphi= -pi;
		#declare maxphi= pi - dphi/2 + (minphi+pi);
		#declare phi=minphi;
		#while(phi<maxphi)
			cylinder {
				z,0,0.5
				strength 1 function 2
				scale 1/3
				translate -1.125*z
				rotate x*degrees(theta)
				rotate z*degrees(phi)
			}
			#declare phi=phi+dphi;
		#end
		#declare theta=theta+dtheta;
	#end
	
	texture { Chrome_Texture }
	scale 3
}

sky_sphere {
	pigment {
		gradient y
		color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
	}
}
