//	Persistence of Vision Ray Tracer Scene Description File
//	File: obj_pigm.pov
//	Date: 26-09-2000
//	Author: Smellenbergh Ren
//	Demo: possible uses of the object_texture and object_pigment

#version unofficial MegaPov 0.4;

#include "golds.inc"

camera {
	location <0.0, 0.0, -14>
	up y*image_height right x*image_width
	look_at <0.0, -0.5, -4>
	angle 45
	rotate x*20
}

light_source { <20, 60, -30> rgb 1.0 }
light_source { <0, 0, -14> rgb 0.7 	rotate x*10 	shadowless } //fill light


//*************** Declare some objects **********************
#declare Star =
	prism {
		linear_spline
		linear_sweep
		0,  //Base height
		2.1,  //Top height
		13,
		<0.25419, 0.00000>,
		<0.86603, 0.50000>,
		<0.14121, 0.24459>,
		<-0.00000, 1.00000>,
		<-0.14121, 0.24459>,
		<-0.86603, 0.50000>,
		<-0.28243, -0.00000>,
		<-0.86603, -0.50000>,
		<-0.14121, -0.24459>,
		<0.00000, -1.00000>,
		<0.14121, -0.24459>,
		<0.86603, -0.50000>,
		<0.25419, 0.00000>
		sturm
	} //prism

#declare TextObj =
union {
	#declare C = 0;
	#declare Copies = 15;
	#declare S2 = -1;
	#while ( C < Copies)
		text {
			ttf "arial", "POV" 0.4, 0.0
			align_center
			scale < 0.6, 1.6, 1 >
			#if (((C/(25)) - floor (C/(25))) = 0)		#declare SubC2 = 0;	#declare S2 = S2*-1;#end  //reverse
			scale < 1, (0.4 #if (S2<0) + ((0.8 -(0.4))/(25) * (25)) #end + (((SubC2*(0.8 -(0.4))/(25 -1)))*S2 )), 1 >
			rotate z*-13
			translate z*-1.1
			rotate y*(C*(360*3.25)/(Copies -1))
			translate y*(-2.7 + (C*(2 - (-2.7))/(Copies -1)))
		} //object-text
		#declare SubC2 = SubC2+1;
		#declare C = C +1;
	#end  //while (C < Copies)
}

#declare Border =
// Point connector macro
#macro P_C_P ( Center, Radius,  Center2,  Radius2)
	#local dx = Center2.x - Center.x ;		#if (dx=0) #declare dx= 0.000001; #end
	#local dy = Center2.y - Center.y ;
	#local dz = Center2.z - Center.z ;
	#local len = sqrt (dx*dx+dy*dy+dz*dz);
	#local xylen = sqrt (dx*dx+dy*dy);
	#local D = acos( (Radius-Radius2)/len);
		< cos(D)*Radius, 0, 0>, sin(D)*Radius ,
		< len + (cos(D)*Radius2), 0, 0>, sin(D)*Radius2
	rotate <0,  degrees(-atan2(dz, xylen)), degrees(atan2 (dy, dx))>
	translate <Center.x, Center.y, Center.z>
#end

#declare C = 0;
#declare Copies = 600;
union {
	#while ( C < Copies)
		#declare Center = <0, 0, 0>;   #declare Radius = 1.0;
		#declare Center2 = <0, 0, 0>;   #declare Radius2 = 1.0;
		sphere {
			#declare Radius = Radius*0.07;
			#declare Radius2 = Radius2*0.07;
			#declare Tx = (0.15);
			#declare Center = Center + <Tx, 0, 0>;
			#declare Tx2 = (0.15);
			#declare Center2 = Center2 + <Tx2, 0, 0>;
			#declare Roty = (0.0 + (C * (360*14 - (0.0))/(Copies -1)));
			#declare Center = vaxis_rotate (Center, y, Roty);
			#declare Roty2 = (0.0 + ((C+1) * (360*14 -(0.0))/(Copies -1)));
			#declare Center2 = vaxis_rotate (Center2, y, Roty2);
			#declare Tx = (4.6);
			#declare Center = Center + <Tx, 0, 0>;
			#declare Tx2 = (4.6);
			#declare Center2 = Center2 + <Tx2, 0, 0>;
			#declare Roty = (0.0 + (C * (360)/(Copies -1)));
			#declare Center = vaxis_rotate (Center, y, Roty);
			#declare Roty2 = (0.0 + ((C+1) * (360)/(Copies -1)));
			#declare Center2 = vaxis_rotate (Center2, y, Roty2);
			Center, Radius
		}
		#if ((C+1) < Copies)
			cone { P_C_P ( Center, Radius, Center2,  Radius2) }
		#end  //#if ((C+1) < Copies)
		#declare C = C +1;
	#end  //while (C < Copies)
	texture { pigment { rgb <1.0, 0.0, 0.0> } }
	scale <1/5, 5, 1/5>
	translate y*0.3
}

//************ Make a union of different objects ********************
#declare StarObj =
union {
	#declare C = 0;
	#declare Copies =12;
		#while ( C < Copies)
		object {
			Star
			scale <0.4, 1, 0.4>
			rotate <-89.5, C*360/(Copies -1), 0>
		} //Star-object
		#declare C = C +1;
	#end  //while (C < Copies)
	object {
		Star
		scale <1.35, 2, 1.35>
		translate y*0.6
	} //Star-object
	cylinder {
		<0, -0.05, 0>, <0, 0.05, 0>, 2.0
		translate y*0.5
	}
	cylinder {
		<0, -0.05, 0>, <0, 0.05, 0>, 2.0
		translate y*-0.5
	}
} //union
	
//********* Sphere with a union of stars and cylinders for object texture ********
sphere {
	<0.0, 0.0, 0.0>, 2
	texture {
		object { 
			StarObj  
			texture {
				pigment { rgb <0.658824, 0.658824, 0.658824> }
			    finish {
			        ambient 0.25
			        diffuse 0.45
			        reflection 0.05
			        brilliance 0.9
			        phong 0.9 phong_size 450
					metallic
			    }
				normal {
					crackle 0.1 //amount
					metric 2
					slope_map {
						[ 0.0,  < 0.0,  0.31041 > ]
						[ 0.50227,  < 0.09977,  0.00000 > ]
						[ 0.99773,  < -0.00227,  -0.34805 > ]
					}
					scale <0.04, 0.04, 0.8	>
				}
			},
			texture { pigment { rgb <0.1, 0.7, 0.8>*1.4 } finish { phong 1.0 phong_size 500 } }
		}
		scale 1.3
	}
	rotate <-25, 0, 20>
	translate x*-0.6
}

//********* Cylinder with a text object for object pigment ********
cylinder {
	<0, -3, 0>, <0, 3, 0>, 1
	texture {
		pigment { object { TextObj pigment { rgb <0.36, 0.20, 0.09> }, pigment { rgb <1, 1, 0>} } }
		finish { reflection 0.15 phong 1.0 phong_size 400 }
	}
	scale 0.6
	rotate z*-90
	rotate y*-45
	translate <1.3, -1.0, -2.4>
}

//********* Lathe with a connected spheres object for object texture ********
lathe {
	bezier_spline
	20, 
	<0.00000, 0.00000>,
	<0.10526, 0.00250>,
	<0.67419, -0.00750>,
	<0.75940, 0.00250>,
	<0.75940, 0.00250>,
	<0.81955, 0.10000>,
	<0.91980, 0.16750>,
	<1.00000, 0.17100>,
	<1.00000, 0.17100>,
	<1.03008, 0.17100>,
	<1.02196, 0.20929>,
	<0.99499, 0.20850>,
	<0.99499, 0.20850>,
	<0.86717, 0.18750>,
	<0.79950, 0.12000>,
	<0.73684, 0.03000>,
	<0.73684, 0.03000>,
	<0.61905, 0.02500>,
	<0.10777, 0.02650>,
	<0.00501, 0.02650>
	sturm
	texture {
		object { 
			Border
			texture { pigment { rgb 1.0 } finish { phong 1.0 phong_size 500 }},
			texture { T_Gold_3E }
		}
	}
	scale <5, 2.0, 5>
	translate y*-1.7
}


//*************** Sky ****************************
sky_sphere {
    pigment {
        gradient y
        pigment_map {
            [0.01 rgb <0.847, 0.749, 0.847> ] // horizon
			[0.25 
			    wrinkles
			    turbulence 0.65
			    octaves 6	omega 0.7	lambda 2
			    color_map {
			        [0.0, 0.1 color rgb 1.05 color rgb 0.95]
			        [0.1, 0.5 color rgb 0.95 color rgb <0.458, 0.458, 0.635>]
			        [0.5, 1.001 color rgb <0.458, 0.458, 0.635> color rgb <0.458, 0.458, 0.635>]
			    }
				scale <1.5, 0.25, 1.5>
				rotate z*5
			]
            [0.60
			    bozo
			    color_map {
			        [0.0, 0.1 color rgb 1.05 color rgb <0.75, 0.80, 0.85>]
			        [0.1, 0.5 color rgb <0.75, 0.80, 0.85> color rgb <0.384, 0.384, 0.509>]
			        [0.5, 1.001 color rgb <0.384, 0.384, 0.509> color rgb <0.3, 0.3, 0.4>]
			    }
			    turbulence 0.65
			    octaves 6	omega 0.707	lambda 2
			    scale <1.5, 0.6, 1.5>
				rotate z*10
			]
        }
    }
	translate y*-0.28
}
