//	Persistence of Vision Ray Tracer Scene Description File
#version unofficial MegaPov 0.4;
#include "colors.inc"
camera {
	location < 0.0, 0.0, -12 >
	angle 15
	look_at < 0, 0, 0 >
//	rotate x*5
}

#declare StarObj =
prism {
	linear_spline
	linear_sweep
	0.0, 	//Base height
	0.35, 	//Top height
	26,
	<0.61992, 0.00000>,
	<0.84880, 0.49005>,
	<0.34439, 0.59650>,
	<-0.00000, 0.98010>,
	<-0.34439, 0.59650>,
	<-0.84880, 0.49005>,
	<-0.68880, -0.00000>,
	<-0.84880, -0.49005>,
	<-0.34439, -0.59650>,
	<0.00000, -0.98010>,
	<0.34439, -0.59650>,
	<0.84880, -0.49005>,
	<0.61992, 0.00000>,
	<0.22877, 0.00000>,
	<0.77943, 0.45000>,
	<0.12709, 0.22013>,
	<-0.00000, 0.90000>,
	<-0.12709, 0.22013>,
	<-0.77943, 0.45000>,
	<-0.25419, -0.00000>,
	<-0.77943, -0.45000>,
	<-0.12709, -0.22013>,
	<0.00000, -0.90000>,
	<0.12709, -0.22013>,
	<0.77943, -0.45000>,
	<0.22877, 0.00000>
	sturm
	scale <0.9, 1, 0.9>
	rotate x*90
}

box {<-1.2, -1.2, -0.2>, < 1.2, 1.2, 0.2>
	pigment {
		proximity {StarObj, 0.2//0.25
			samples 40	
			sample_bailout 600	//If it still hasn't gotten the samples after 600 attempts, give up
			method 0
			max_density 1.0 
			type 1//Use minimum distance
			sides 2//Calculate on both sides of object
		}
		color_map {
			[0 color rgbt <0, 0, 0, 1.0>]
			[0.0001 color rgbt <0, 1, 0, 0.4> ]
			[1 color rgbt <0, 0, 0, 0.5>]
		}
	}
	finish {ambient 3 diffuse 0}
}
