#################################
# Visual Tcl v1.10 Project
#

#################################
# GLOBAL VARIABLES
#
global widget; 
global csh;
global after_id

#################################
# USER DEFINED PROCEDURES
#
proc init {argc argv} {
  load ../bin/coshclient.dll

}

init $argc $argv


proc checkserver {} {
  global csh after_id
  catch {
    set count [$csh eval getcount]
    .demo.lb2 configure -text $count
    set after_id [after 1000 checkserver]
  }
}

proc stopserver {} {
  global csh after_id
  after cancel $after_id
  $csh release
}

proc main {argc argv} {
  global csh
  wm protocol .demo WM_DELETE_WINDOW {destroy .}

  #== open a com shell
  set csh [comshell localhost]

  #== read the bootstrap script
  set f [open server.tcl r]
  set s [read $f]
  close $f

  #== eval bootstrap in server
  $csh eval $s

  set after_id [after idle checkserver]
}




#################################
# Visual TCL generated stuff
#
proc Window {args} {
global vTcl
    set cmd [lindex $args 0]
    set name [lindex $args 1]
    set newname [lindex $args 2]
    set rest [lrange $args 3 end]
    if {$name == "" || $cmd == ""} {return}
    if {$newname == ""} {
        set newname $name
    }
    set exists [winfo exists $newname]
    switch $cmd {
        show {
            if {$exists == "1" && $name != "."} {wm deiconify $name; return}
            if {[info procs vTclWindow(pre)$name] != ""} {
                eval "vTclWindow(pre)$name $newname $rest"
            }
            if {[info procs vTclWindow$name] != ""} {
                eval "vTclWindow$name $newname $rest"
            }
            if {[info procs vTclWindow(post)$name] != ""} {
                eval "vTclWindow(post)$name $newname $rest"
            }
        }
        hide    { if $exists {wm withdraw $newname; return} }
        iconify { if $exists {wm iconify $newname; return} }
        destroy { if $exists {destroy $newname; return} }
    }
}

#################################
# VTCL GENERATED GUI PROCEDURES
#

proc vTclWindow. {base} {
    if {$base == ""} {
        set base .
    }
    ###################
    # CREATING WIDGETS
    ###################
    wm focusmodel $base passive
    wm geometry $base 200x200+0+0
    wm maxsize $base 1028 753
    wm minsize $base 104 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm withdraw $base
    wm title $base "vt"
    ###################
    # SETTING GEOMETRY
    ###################
}

proc vTclWindow.demo {base} {
    if {$base == ""} {
        set base .demo
    }
    if {[winfo exists $base]} {
        wm deiconify $base; return
    }
    ###################
    # CREATING WIDGETS
    ###################
    toplevel $base -class Toplevel
    wm focusmodel $base passive
    wm geometry $base 225x28+395+411
    wm maxsize $base 1028 753
    wm minsize $base 104 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm deiconify $base
    wm title $base "Demo client"
    label $base.lb1 \
        -borderwidth 1 -text {Server count is currently } 
    label $base.lb2 \
        -background white -borderwidth 1 -relief raised -text {   } 
    button $base.bt1 \
        -command {stopserver} -text {stop server} 
    ###################
    # SETTING GEOMETRY
    ###################
    pack $base.lb1 \
        -in .demo -anchor center -expand 0 -fill none -padx 4 -side left 
    pack $base.lb2 \
        -in .demo -anchor center -expand 0 -fill none -padx 4 -side left 
    pack $base.bt1 \
        -in .demo -anchor center -expand 0 -fill none -padx 4 -side top 
}

Window show .
Window show .demo

main $argc $argv
