#############################################################################
# Visual Tcl v1.10 Project
#

#################################
# GLOBAL VARIABLES
#
global widget; 
global count

#################################
# USER DEFINED PROCEDURES
#
proc init {argc argv} {
  global count
  set count 0
}

init $argc $argv

proc getcount {} {
  global count
  return $count
}

proc bumpcount {} {
  global count
  incr count
  catch {
    .server.lb2 configure -text $count
    after 200 bumpcount
  }
}

proc main {argc argv} {
  wm protocol .server WM_DELETE_WINDOW {exit}
  after idle bumpcount
}

proc Window {args} {
global vTcl
    set cmd [lindex $args 0]
    set name [lindex $args 1]
    set newname [lindex $args 2]
    set rest [lrange $args 3 end]
    if {$name == "" || $cmd == ""} {return}
    if {$newname == ""} {
        set newname $name
    }
    set exists [winfo exists $newname]
    switch $cmd {
        show {
            if {$exists == "1" && $name != "."} {wm deiconify $name; return}
            if {[info procs vTclWindow(pre)$name] != ""} {
                eval "vTclWindow(pre)$name $newname $rest"
            }
            if {[info procs vTclWindow$name] != ""} {
                eval "vTclWindow$name $newname $rest"
            }
            if {[info procs vTclWindow(post)$name] != ""} {
                eval "vTclWindow(post)$name $newname $rest"
            }
        }
        hide    { if $exists {wm withdraw $newname; return} }
        iconify { if $exists {wm iconify $newname; return} }
        destroy { if $exists {destroy $newname; return} }
    }
}

#################################
# VTCL GENERATED GUI PROCEDURES
#

proc vTclWindow. {base} {
    if {$base == ""} {
        set base .
    }
    ###################
    # CREATING WIDGETS
    ###################
    wm focusmodel $base passive
    wm geometry $base 200x200+0+0
    wm maxsize $base 1028 753
    wm minsize $base 104 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm withdraw $base
    wm title $base "vt"
    ###################
    # SETTING GEOMETRY
    ###################
}

proc vTclWindow.server {base} {
    if {$base == ""} {
        set base .server
    }
    if {[winfo exists $base]} {
        wm deiconify $base; return
    }
    ###################
    # CREATING WIDGETS
    ###################
    toplevel $base -class Toplevel
    wm focusmodel $base passive
    wm geometry $base 143x16+348+240
    wm maxsize $base 1028 753
    wm minsize $base 104 1
    wm overrideredirect $base 0
    wm resizable $base 1 1
    wm deiconify $base
    wm title $base "Test server"
    label $base.lb1 \
        -borderwidth 1 -text {Server count} 
    label $base.lb2 \
        -background white -borderwidth 1 -width 8 
    ###################
    # SETTING GEOMETRY
    ###################
    pack $base.lb1 \
        -in .server -anchor center -expand 0 -fill none -side left 
    pack $base.lb2 \
        -in .server -anchor center -expand 0 -fill none -side right 
}

Window show .
Window show .server

main $argc $argv
