// comshell.cpp




#include <tcl.h>

#include "cosh.h"
#include "ustring.h"

CTclScript* g_pTclScript = NULL;   // the global instance for this server

unsigned long g_dwCTclScriptCF = 0;

#ifdef REGISTER_ACTIVE
unsigned long g_dwRegisterCTclScript = 0;
#endif

static int ShutdownCmd(ClientData, Tcl_Interp*, int, char**);

//////////////////////////////////////////////////////////////////
//
CTclScript* CTclScript::Create(Tcl_Interp* interp) 
{   
    CTclScript* psrvr = NULL;   
     
    // Create CTclScript Application object
    psrvr = new CTclScript();
    if (psrvr == NULL)
        return NULL;
   
     
    psrvr->m_cRef = 0;
	psrvr->m_interp = interp;
    

    return psrvr;
    
}

CTclScript::CTclScript(void)
{
	m_cRef=0;
}

CTclScript::~CTclScript (void)
{
}



//---------------------------------------------------------------------
//                        IUnknown methods
//---------------------------------------------------------------------


STDMETHODIMP
CTclScript::QueryInterface(REFIID riid, void * * ppv)
{
    if(IsEqualIID(riid, IID_IUnknown) ||
		IsEqualIID(riid, IID_ITclScript) ){
      *ppv = this;
    }else {
      *ppv = NULL;	    
      return ResultFromScode(E_NOINTERFACE);
    }

    AddRef();
    return NOERROR;
}


STDMETHODIMP_(ULONG)
CTclScript::AddRef()
{
    return ++m_cRef;
}


STDMETHODIMP_(ULONG)
CTclScript::Release()
{
    if(--m_cRef == 0){
		try   // m_interp may not be valid here for a number of reasons
		{
			Tcl_Eval(m_interp,"after idle {comshell_shutdown; exit}");  
		}
		catch (...)
		{
			//...
		}
      delete this;
      return 0;
    }
    return m_cRef;
}


//---------------------------------------------------------------------
//                        ITclScript methods
//---------------------------------------------------------------------


STDMETHODIMP
CTclScript::eval(BSTR script, BSTR* result, long* retcode, BSTR* errorinfo)
{
	HRESULT hr = NOERROR;

	//===============pack BSTR in autoconverter class String816
	String816 strScript(script);    

	//===============eval the script

	*retcode = Tcl_Eval(m_interp, (char*)(const char*)strScript);

	if (m_interp->result[0]!=0)      // watch out - (""==NULL) in COM
	{
		String816 strResult = m_interp->result;
		*result = SysAllocString((const wchar_t*)strResult);   
	}

	if (*retcode!=TCL_OK)         // get errorInfo
	{
		char* errstr = Tcl_GetVar(m_interp,"errorInfo",TCL_GLOBAL_ONLY);
		if (errstr) 
		{
			String816 strErrorInfo = errstr;
			*errorinfo = SysAllocString((const wchar_t*)strErrorInfo);
		}
	}

	return hr;
}



//---------------------------------------------------------------------
//                      The CTclScript Class Factory
//---------------------------------------------------------------------


IClassFactory *
CTclScriptCF::Create()
{
    return new  CTclScriptCF();
}

////////////////////////////////////////////////////////////////////////
STDMETHODIMP
CTclScriptCF::QueryInterface(REFIID riid, void * * ppv)
{
    if(IsEqualIID(riid, IID_IUnknown) || IsEqualIID(riid, IID_IClassFactory)){
      AddRef();
      *ppv = this;
      return NOERROR;
    }
    *ppv = NULL;
    return ResultFromScode(E_NOINTERFACE);
}


////////////////////////////////////////////////////////////////////////
STDMETHODIMP_(ULONG)
CTclScriptCF::AddRef()
{
    return ++m_refs;
}


////////////////////////////////////////////////////////////////////////
STDMETHODIMP_(ULONG)
CTclScriptCF::Release()
{
    if(--m_refs == 0){
      delete this;
      return 0;
    }
    return m_refs;
}

////////////////////////////////////////////////////////////////////////
STDMETHODIMP
CTclScriptCF::CreateInstance(
    IUnknown * /*punkOuter*/,
    REFIID riid,
    void * * ppv)
{
	extern CTclScript* g_pTclScript;

    return g_pTclScript->QueryInterface(riid, ppv);
}

////////////////////////////////////////////////////////////////////////
STDMETHODIMP
CTclScriptCF::LockServer(BOOL fLock)
{
    return NOERROR;
}




BOOL InitCom(Tcl_Interp* interp)
{
    HRESULT hresult;
    IClassFactory * pcf;


    if((hresult = CoInitialize(NULL)) != NOERROR)
      goto LError0;

	// create the single global instance of CTclScript
    if((g_pTclScript = CTclScript::Create(interp)) == NULL){
      hresult = ResultFromScode(E_OUTOFMEMORY);
      goto LError0;
    }
//	g_pTclScript->AddRef();

    if((pcf = CTclScriptCF::Create()) == NULL)
      goto LError1;

	//====================== class object registration
    hresult = CoRegisterClassObject(
      CLSID_comshell,
      pcf,
      CLSCTX_LOCAL_SERVER,
      REGCLS_SINGLEUSE,
      &g_dwCTclScriptCF);

    if(hresult != NOERROR)
      goto LError2;

    
	//====================== active object (ROT) registration
#ifdef REGISTER_ACTIVE
	hresult = RegisterActiveObject(g_pTclScript, CLSID_comshell, 
								   ACTIVEOBJECT_WEAK, 
								   &g_dwRegisterCTclScript);
    if(hresult != NOERROR)
      goto LError2;
#endif

    pcf->Release();

	Tcl_CreateCommand(interp,"comshell_shutdown",ShutdownCmd,NULL,NULL);

    return TRUE;

LError2:;
    pcf->Release();

LError1:;
    UnInitCom();

LError0:;
    return (hresult=NOERROR);
}

//////////////////////////////////////////////////////////////////////////
BOOL UnInitCom()
{
#ifdef REGISTER_ACTIVE
    if(g_dwRegisterCTclScript != 0)
      RevokeActiveObject(g_dwRegisterCTclScript, NULL);
#endif
    
	if(g_dwCTclScriptCF != 0)
      CoRevokeClassObject(g_dwCTclScriptCF);


    CoUninitialize();

    return TRUE;
}

//////////////////////////////////////////////////////////////////////////
int ShutdownCmd(ClientData data, Tcl_Interp* interp, int argc, char** argv)
{
  UnInitCom();
  return TCL_OK;
}