// COSHCLIENT.cpp
//

////////////////////////////////////////////////////////////////////

#include <windows.h>
#include <tcl.h>
#include "ustring.h"

#include <objbase.h>
#include <initguid.h>
#include "..\coshps\coshps.h"
#include "..\coshps\coshps_i.c"

///////////////////////////////////////////////////////////////////////
//
// CoCreateInstanceEx is prototyped here because my compiler
// couldn't find it in the standard windows headers (?!)

WINOLEAPI CoCreateInstanceEx(
    REFCLSID                    Clsid,
    IUnknown    *               punkOuter, // only relevant locally
    DWORD                       dwClsCtx,
    COSERVERINFO *              pServerInfo,
    DWORD                       dwCount,
    MULTI_QI        *           pResults );

static int ComshellCounter=0;

////////////////////////////////////////////////////////////////////////////
void ComshellInstDelete(ClientData data)
{
	ITclScript* pTclScript = (ITclScript*)data;
	pTclScript->Release();
}

#define CONST2LPSTR(x) (char*)(const char*)(x)

////////////////////////////////////////////////////////////////////////////
int ComshellInstCmd (ClientData data, Tcl_Interp *interp, int argc, char **argv)
{
	ITclScript* pTclScript = (ITclScript*)data;

	if (argc==1) {
		Tcl_SetResult(interp,"comshell instance: wrong # args", TCL_VOLATILE);
		return TCL_ERROR;
	}

	//======================================== invoke
	if (stricmp(argv[1],"eval")==0) 
	{
		if (argc==3) 
		{
			int retcode = TCL_OK;
			String816 str1(argv[2]);
			BSTR bstrScript = SysAllocString(str1);
			BSTR bstrResult = NULL;
			BSTR bstrErrorInfo = NULL;
			long lRetcode;

			HRESULT hr = pTclScript->eval(bstrScript, &bstrResult, 
				                          &lRetcode, &bstrErrorInfo);

			if (SUCCEEDED(hr)) 
			{
				if (bstrResult) 
				{
					String816 str2(bstrResult);
					Tcl_SetResult(interp,CONST2LPSTR(str2),TCL_VOLATILE);
				}

				if (bstrErrorInfo)
				{
					String816 errstr(bstrErrorInfo);
					Tcl_AddErrorInfo(interp,"\n-- remotely evaluated via comshell --\n");
					Tcl_AddErrorInfo(interp,CONST2LPSTR(errstr));
				}

				retcode = lRetcode;
								
			} else {

				char msg[64];
				sprintf(msg,"comshell eval failed: 0x%x", hr);
				Tcl_SetResult(interp,msg,TCL_VOLATILE);
				retcode = TCL_ERROR;

			}

			::SysFreeString(bstrScript);
			if (bstrResult)
				::SysFreeString(bstrResult);
			if (bstrErrorInfo)
				::SysFreeString(bstrErrorInfo);

			return retcode;
		
		} else {

			Tcl_SetResult(interp,"comshell eval: wrong # args",TCL_VOLATILE);
			return TCL_ERROR;

		}

	//======================================== release
	} else if (stricmp(argv[1],"release")==0) {
		if (argc>2) {
			if (stricmp(argv[2],"-lockserver")==0) {
				pTclScript->AddRef();
			}
		}

		Tcl_DeleteCommand(interp,argv[0]);

	//======================================== release
	} else if (stricmp(argv[1],"getptr")==0) {
		sprintf(interp->result,"%08X",(DWORD)pTclScript);

	//======================================== not found
	} else { 
		char msg[128];
		if (strlen(argv[1])>80)
			argv[1][80]=0;
		sprintf(msg,"comshell eval: unknown keyword \"%s\"",argv[1]);
		Tcl_SetResult(interp,(LPSTR)(LPCSTR)msg,TCL_VOLATILE);
	}

	return TCL_OK;
}

///////////////////////////////////////////////////////////////////////
int ComshellCmd (ClientData dummy, Tcl_Interp* interp, int argc, char** argv)
{
	int retcode = TCL_OK;
	HRESULT hr;
	COSERVERINFO serverinfo;
	COSERVERINFO* pServerInfo=NULL;

	serverinfo.dwReserved1 = 0;
	serverinfo.dwReserved2 = 0;
	serverinfo.pwszName = NULL;
	serverinfo.pAuthInfo = NULL;

	int clsctx = CLSCTX_LOCAL_SERVER;


	if (argc>1 && (stricmp(argv[1],"localhost")!=0)) {
		String816 str1(argv[1]);
		serverinfo.pwszName = SysAllocString(str1);
		pServerInfo = &serverinfo;
		clsctx |= CLSCTX_REMOTE_SERVER;
	}

   
   MULTI_QI qi = {&IID_ITclScript, NULL, 0};

   hr = CoCreateInstanceEx(CLSID_comshell, 
	                       NULL, 
						   clsctx,
						   pServerInfo, 
						   1, 
						   &qi);

	if (serverinfo.pwszName)
		::SysFreeString(serverinfo.pwszName);

   if (SUCCEEDED(hr) && SUCCEEDED(qi.hr))
   {
      // Now get the interface
      ITclScript* pTclScript = (ITclScript*)qi.pItf;
	  char buf[16];
	  sprintf(buf,"cosh%03d",ComshellCounter++);
	  Tcl_CreateCommand(interp,buf,ComshellInstCmd,pTclScript,ComshellInstDelete);
	  Tcl_SetResult(interp,buf,TCL_VOLATILE);

   }
   else
   {
      char buf[128];
      sprintf(buf,"cannot activate comshell: 0x%x and QI: 0x%x", hr, qi.hr);
	  Tcl_SetResult(interp,buf,TCL_VOLATILE);
	  retcode = TCL_ERROR;
   }
   

	return retcode;
}


/*********************************************************************/
extern "C" __declspec(dllexport)
int Coshclient_Init (Tcl_Interp *interp)
/*********************************************************************/
{ // initialized through the TCL "load" command

	Tcl_CreateCommand(interp,"comshell",ComshellCmd,NULL,NULL);
	Tcl_SetResult(interp,"COSH client 1.0",TCL_VOLATILE);
	return TCL_OK;
}

//////////////////////////////////////////////////////////////////////////
// LIBRARY INITIALIZATION ROUTINE
//

int APIENTRY
DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)
{
	if (dwReason == DLL_PROCESS_ATTACH)
	{
        CoInitialize(NULL);
	}
	else if (dwReason == DLL_PROCESS_DETACH)
	{
//        CoUninitialize();
	}
	return 1;   // ok
}

